/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.gateway;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddGatewayFeature<T extends Gateway>
extends AbstractBpmn2AddElementFeature<T> {
    public AddGatewayFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        int height;
        Gateway businessObject = (Gateway)this.getBusinessObject(context);
        IGaService gaService = Graphiti.getGaService();
        IPeService peService = Graphiti.getPeService();
        int width = this.getWidth(context);
        if (width != (height = this.getHeight(context))) {
            width = height = Math.min(width, height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle gatewayRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)gatewayRect, x, y, width, height);
        Shape gatewayShape = peService.createShape(containerShape, false);
        Polygon gatewayPolygon = GraphicsUtil.createGateway(gatewayShape, width, height);
        StyleUtil.applyStyle((GraphicsAlgorithm)gatewayPolygon, (BaseElement)businessObject);
        gaService.setLocationAndSize((GraphicsAlgorithm)gatewayPolygon, 0, 0, width, height);
        boolean isImport = context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)gatewayPolygon);
        this.splitConnection(context, containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        this.prepareAddContext(context, (PictogramElement)containerShape, width, height);
        this.getFeatureProvider().getAddFeature(context).add(context);
        return containerShape;
    }

    @Override
    public int getHeight() {
        return GraphicsUtil.getGatewaySize(this.getDiagram()).getHeight();
    }

    @Override
    public int getWidth() {
        return GraphicsUtil.getGatewaySize(this.getDiagram()).getWidth();
    }
}

