/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.flow;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.core.utils.Tuple;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractAddFlowFeature<T extends BaseElement>
extends AbstractBpmn2AddElementFeature<T> {
    public AbstractAddFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (context instanceof IAddConnectionContext) {
            BaseElement obj;
            IAddConnectionContext acc = (IAddConnectionContext)context;
            if (acc.getSourceAnchor() != null && (obj = BusinessObjectUtil.getFirstElementOfType((PictogramElement)acc.getSourceAnchor().getParent(), BaseElement.class)) instanceof EndEvent) {
                List eventDefinitions = ((EndEvent)obj).getEventDefinitions();
                for (EventDefinition eventDefinition : eventDefinitions) {
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    return true;
                }
                return false;
            }
            return this.getBoClass().isAssignableFrom(this.getBusinessObject(context).getClass());
        }
        return false;
    }

    public PictogramElement add(IAddContext context) {
        Point p;
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        Object businessObject = this.getBusinessObject(context);
        IAddConnectionContext addContext = (IAddConnectionContext)context;
        AnchorContainer sourceContainer = addContext.getSourceAnchor().getParent();
        AnchorContainer targetContainer = addContext.getTargetAnchor().getParent();
        FreeFormConnection connection = peService.createFreeFormConnection(this.getDiagram());
        if (AnchorUtil.useAdHocAnchors((PictogramElement)sourceContainer, (Connection)connection) && (p = (Point)addContext.getProperty((Object)"connection.source.location")) != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.source.location", AnchorUtil.pointToString(p));
        }
        if (AnchorUtil.useAdHocAnchors((PictogramElement)targetContainer, (Connection)connection) && (p = (Point)addContext.getProperty((Object)"connection.target.location")) != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.target.location", AnchorUtil.pointToString(p));
        }
        if (addContext.getProperty((Object)"connection.created") != null) {
            peService.setPropertyValue((PropertyContainer)connection, "connection.created", "true");
        }
        Anchor sourceAnchor = addContext.getSourceAnchor();
        Anchor targetAnchor = addContext.getTargetAnchor();
        Object importProp = context.getProperty((Object)DIImport.IMPORT_PROPERTY);
        if (importProp != null && ((Boolean)importProp).booleanValue()) {
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
        } else {
            Tuple<FixPointAnchor, FixPointAnchor> anchors;
            if (sourceAnchor == null || targetAnchor == null) {
                anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(sourceContainer, targetContainer, null);
                sourceAnchor = (Anchor)anchors.getFirst();
                targetAnchor = (Anchor)anchors.getSecond();
            } else {
                anchors = AnchorUtil.getSourceAndTargetBoundaryAnchors(sourceContainer, targetContainer, (Connection)connection);
                sourceAnchor = (Anchor)anchors.getFirst();
                targetAnchor = (Anchor)anchors.getSecond();
            }
            connection.setStart(sourceAnchor);
            connection.setEnd(targetAnchor);
        }
        if (ModelUtil.hasName(businessObject)) {
            ConnectionDecorator labelDecorator = Graphiti.getPeService().createConnectionDecorator((Connection)connection, true, 0.5, true);
            Text text = gaService.createText((GraphicsAlgorithmContainer)labelDecorator, ModelUtil.getName(businessObject));
            peService.setPropertyValue((PropertyContainer)labelDecorator, "baseelement.text", Boolean.toString(true));
            StyleUtil.applyStyle((GraphicsAlgorithm)text, businessObject);
            peService.setPropertyValue((PropertyContainer)labelDecorator, "label", Boolean.toString(true));
            this.link((PictogramElement)labelDecorator, businessObject);
        }
        this.createDIEdge((Connection)connection, (BaseElement)businessObject);
        this.createConnectionLine((Connection)connection);
        this.decorateConnection(addContext, (Connection)connection, businessObject);
        return connection;
    }

    @Override
    public int getHeight() {
        return -1;
    }

    @Override
    public int getWidth() {
        return -1;
    }

    protected abstract Class<? extends BaseElement> getBoClass();

    protected Polyline createConnectionLine(Connection connection) {
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        Polyline connectionLine = Graphiti.getGaService().createPolyline((GraphicsAlgorithmContainer)connection);
        StyleUtil.applyStyle((GraphicsAlgorithm)connectionLine, be);
        return connectionLine;
    }
}

