/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event.definitions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.DecorationAlgorithm;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public abstract class AbstractAddEventDefinitionFeature<T extends EventDefinition>
extends AbstractBpmn2AddFeature<T> {
    public AbstractAddEventDefinitionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        List<EClass> allowedItems;
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        Object ed = context.getNewObject();
        return bo instanceof Event && ed instanceof EventDefinition && (allowedItems = FeatureSupport.getAllowedEventDefinitions((Event)bo)).contains(((EventDefinition)ed).eClass());
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape containerShape = context.getTargetContainer();
        T businessObject = this.getBusinessObject(context);
        this.decorateShape(context, containerShape, businessObject);
        return null;
    }

    @Override
    protected void decorateShape(IAddContext context, ContainerShape containerShape, T businessObject) {
        Event event = (Event)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
        this.draw(event, (EventDefinition)businessObject, containerShape);
    }

    public void draw(Event event, EventDefinition eventDef, ContainerShape container) {
        if (FeatureSupport.isLabelShape((Shape)container)) {
            return;
        }
        List<EventDefinition> eventDefinitions = ModelUtil.getEventDefinitions(event);
        int size = eventDefinitions.size();
        GraphicsUtil.deleteEventShape(container);
        if (size > 1) {
            Shape multipleShape = Graphiti.getPeService().createShape(container, false);
            this.drawForEvent(event, multipleShape);
            this.link((PictogramElement)multipleShape, eventDefinitions.toArray(new EventDefinition[size]));
        } else {
            Shape addedShape = this.getDecorationAlgorithm(event).draw(container);
            if (addedShape == null) {
                addedShape = Graphiti.getPeService().createShape(container, false);
                GraphicsUtil.createEventNotAllowed(addedShape);
            }
            this.link((PictogramElement)addedShape, eventDef);
        }
    }

    public abstract DecorationAlgorithm getDecorationAlgorithm(Event var1);

    private void drawForEvent(Event event, Shape shape) {
        if (event instanceof CatchEvent && ((CatchEvent)event).isParallelMultiple()) {
            this.drawParallelMultiple(event, shape);
        } else {
            this.drawMultiple(event, shape);
        }
    }

    private void drawMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon pentagon = GraphicsUtil.createEventPentagon(shape);
        if (event instanceof ThrowEvent) {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_FOREGROUND);
        } else {
            StyleUtil.setFillStyle((GraphicsAlgorithm)pentagon, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        }
        StyleUtil.applyStyle((GraphicsAlgorithm)pentagon, be);
    }

    private void drawParallelMultiple(Event event, Shape shape) {
        BaseElement be = BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, BaseElement.class, true);
        Polygon cross = GraphicsUtil.createEventParallelMultiple(shape);
        StyleUtil.setFillStyle((GraphicsAlgorithm)cross, StyleUtil.FillStyle.FILL_STYLE_BACKGROUND);
        StyleUtil.applyStyle((GraphicsAlgorithm)cross, be);
    }

    @Override
    public T getBusinessObject(IAddContext context) {
        Object businessObject = context.getProperty((Object)"businessObject");
        if (businessObject instanceof EventDefinition) {
            return (T)((EventDefinition)businessObject);
        }
        return (T)((EventDefinition)context.getNewObject());
    }

    @Override
    public void putBusinessObject(IAddContext context, T businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        ArrayList<ContainerShape> pes = new ArrayList<ContainerShape>();
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            fc.getFeature();
            if (context instanceof AddContext) {
                AddContext ac = (AddContext)context;
                pes.add(ac.getTargetContainer());
            }
            ++n2;
        }
        this.getDiagramEditor().setPictogramElementsForSelection(pes.toArray(new PictogramElement[pes.size()]));
    }
}

