/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddEventFeature<T extends Event>
extends AbstractBpmn2AddElementFeature<T> {
    public static final String EVENT_ELEMENT = "event.graphics.element";
    public static final String EVENT_CIRCLE = "event.graphics.element.circle";

    public AddEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAdd(IAddContext context) {
        return FeatureSupport.isValidFlowElementTarget((ITargetContext)context);
    }

    public PictogramElement add(IAddContext context) {
        int height;
        Event businessObject = (Event)this.getBusinessObject(context);
        IGaService gaService = Graphiti.getGaService();
        IPeService peService = Graphiti.getPeService();
        int width = this.getWidth(context);
        if (width != (height = this.getHeight(context))) {
            width = height = Math.min(width, height);
        }
        this.adjustLocation(context, width, height);
        int x = context.getX();
        int y = context.getY();
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle invisibleRect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRect, x, y, width, height);
        Shape ellipseShape = peService.createShape(containerShape, false);
        peService.setPropertyValue((PropertyContainer)ellipseShape, EVENT_ELEMENT, EVENT_CIRCLE);
        peService.setPropertyValue((PropertyContainer)containerShape, "event.marker.container", Boolean.toString(true));
        Ellipse ellipse = GraphicsUtil.createEventShape(ellipseShape, width, height);
        StyleUtil.applyStyle((GraphicsAlgorithm)ellipse, (BaseElement)businessObject);
        boolean isImport = context.getProperty((Object)DIImport.IMPORT_PROPERTY) != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        this.decorateShape(context, containerShape, businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        AnchorUtil.addFixedPointAnchors((Shape)containerShape, (GraphicsAlgorithm)ellipse);
        this.splitConnection(context, containerShape);
        this.updatePictogramElement((PictogramElement)containerShape);
        this.layoutPictogramElement((PictogramElement)containerShape);
        this.prepareAddContext(context, (PictogramElement)containerShape, width, height);
        this.getFeatureProvider().getAddFeature(context).add(context);
        return containerShape;
    }

    @Override
    public int getHeight() {
        return GraphicsUtil.getEventSize(this.getDiagram()).getHeight();
    }

    @Override
    public int getWidth() {
        return GraphicsUtil.getEventSize(this.getDiagram()).getWidth();
    }
}

