/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.data;

import java.io.IOException;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.ModelHandlerLocator;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public abstract class AbstractCreateDataInputOutputFeature<T extends ItemAwareElement>
extends AbstractBpmn2CreateFeature<T> {
    public AbstractCreateDataInputOutputFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public boolean canCreate(ICreateContext context) {
        BPMNDiagram bpmnDiagram;
        EObject containerBO = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        boolean intoDiagram = containerBO instanceof BPMNDiagram;
        if (intoDiagram && (bpmnDiagram = (BPMNDiagram)containerBO).getPlane().getBpmnElement() instanceof SubProcess) {
            intoDiagram = false;
        }
        boolean intoLane = FeatureSupport.isTargetLane((ITargetContext)context) && FeatureSupport.isTargetLaneOnTop((ITargetContext)context);
        boolean intoParticipant = FeatureSupport.isTargetParticipant((ITargetContext)context);
        return intoDiagram || intoLane || intoParticipant;
    }

    public Object[] create(ICreateContext context) {
        ItemAwareElement element = (ItemAwareElement)this.createBusinessObject(context);
        try {
            ModelHandler handler = ModelHandlerLocator.getModelHandler(this.getDiagram().eResource());
            handler.addDataInputOutput(context.getTargetContainer(), element);
        }
        catch (IOException e) {
            Activator.logError(e);
        }
        this.addGraphicalRepresentation((IAreaContext)context, element);
        return new Object[]{element};
    }

    protected abstract String getStencilImageId();

    public String getCreateImageId() {
        return this.getStencilImageId();
    }

    public String getCreateLargeImageId() {
        return this.getStencilImageId();
    }
}

