/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.choreography;

import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class LayoutChoreographyFeature
extends DefaultLayoutBPMNShapeFeature {
    protected IPeService peService = Graphiti.getPeService();
    protected IGaService gaService = Graphiti.getGaService();

    public LayoutChoreographyFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean canLayout(ILayoutContext context) {
        return BusinessObjectUtil.getFirstElementOfType(context.getPictogramElement(), ChoreographyActivity.class) != null;
    }

    @Override
    public boolean layout(ILayoutContext context) {
        ContainerShape choreographyContainer = (ContainerShape)context.getPictogramElement();
        GraphicsAlgorithm parentGa = choreographyContainer.getGraphicsAlgorithm();
        int newWidth = parentGa.getWidth();
        int newHeight = parentGa.getHeight();
        for (Shape s : this.peService.getAllContainedShapes(choreographyContainer)) {
            GraphicsAlgorithm ga;
            String property = this.peService.getPropertyValue((PropertyContainer)s, "choreography.name");
            if (property != null && new Boolean(property).booleanValue()) {
                ga = s.getGraphicsAlgorithm();
                this.setTextLocation(choreographyContainer, (AbstractText)ga, newWidth, newHeight);
            }
            if ((property = this.peService.getPropertyValue((PropertyContainer)s, "call.choreography.border")) == null || !new Boolean(property).booleanValue()) continue;
            ga = s.getGraphicsAlgorithm();
            this.gaService.setSize(ga, newWidth, newHeight);
            GraphicsUtil.sendToFront(s);
        }
        return super.layout(context);
    }

    protected void setTextLocation(ContainerShape choreographyContainer, AbstractText text, int w, int h) {
        this.gaService.setLocationAndSize((GraphicsAlgorithm)text, 5, 5, w - 5, h);
    }
}

