/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.bendpoint;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.dd.dc.DcFactory;
import org.eclipse.dd.dc.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.impl.DefaultAddBendpointFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class AddBendpointFeature
extends DefaultAddBendpointFeature {
    public AddBendpointFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canAddBendpoint(IAddBendpointContext context) {
        try {
            FreeFormConnection connection = context.getConnection();
            BaseElement element = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            BPMNEdge edge = DIUtils.findBPMNEdge((EObject)element);
            return edge != null;
        }
        catch (Exception e) {
            Activator.logError(e);
            return false;
        }
    }

    public void addBendpoint(IAddBendpointContext context) {
        super.addBendpoint(context);
        try {
            FreeFormConnection connection = context.getConnection();
            BaseElement element = BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, BaseElement.class);
            Point p = DcFactory.eINSTANCE.createPoint();
            p.setX((float)context.getX());
            p.setY((float)context.getY());
            BPMNEdge edge = DIUtils.findBPMNEdge((EObject)element);
            int index = context.getBendpointIndex() + 1;
            edge.getWaypoint().add(index, p);
            BendpointConnectionRouter.setAddedBendpoint((Connection)connection, context.getBendpointIndex());
            FeatureSupport.updateConnection(this.getFeatureProvider(), (Connection)connection);
        }
        catch (Exception e) {
            Activator.logError(e);
        }
    }
}

