/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.features.MoveFlowNodeFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractBoundaryEventOperation;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeLayoutService;

public class MoveActivityFeature
extends MoveFlowNodeFeature {
    public static final String ACTIVITY_MOVE_PROPERTY = "activity.move";
    public static final String SELECTION_MOVE_PROPERTY = "selection.move";

    public MoveActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    protected void preMoveShape(IMoveShapeContext context) {
        MoveShapeContext msc = (MoveShapeContext)context;
        ContainerShape oldContainer = context.getSourceContainer();
        ContainerShape newContainer = context.getTargetContainer();
        IPeLayoutService peLayoutService = Graphiti.getPeLayoutService();
        ILocation oldLoc = peLayoutService.getLocationRelativeToDiagram((Shape)oldContainer);
        ILocation newLoc = peLayoutService.getLocationRelativeToDiagram((Shape)newContainer);
        if (oldContainer != newContainer) {
            newLoc.getX();
            msc.getX();
            oldLoc.getX();
            newLoc.getY();
            msc.getY();
            oldLoc.getY();
            newLoc.getX();
            msc.getDeltaX();
            oldLoc.getX();
            newLoc.getY();
            msc.getDeltaY();
            oldLoc.getY();
        }
        super.preMoveShape(context);
    }

    @Override
    protected void postMoveShape(final IMoveShapeContext context) {
        PictogramElement pe;
        super.postMoveShape(context);
        PictogramElement containerShape = context.getPictogramElement();
        Activity activity = BusinessObjectUtil.getFirstElementOfType(containerShape, Activity.class);
        GraphicsUtil.sendToFront(context.getShape());
        new AbstractBoundaryEventOperation(){

            @Override
            protected void doWorkInternal(ContainerShape container) {
                GraphicsAlgorithm ga = container.getGraphicsAlgorithm();
                MoveShapeContext newContext = new MoveShapeContext((Shape)container);
                newContext.setDeltaX(context.getDeltaX());
                newContext.setDeltaY(context.getDeltaY());
                newContext.setSourceContainer(context.getSourceContainer());
                newContext.setTargetContainer(context.getTargetContainer());
                newContext.setTargetConnection(context.getTargetConnection());
                newContext.setLocation(ga.getX(), ga.getY());
                newContext.putProperty((Object)MoveActivityFeature.ACTIVITY_MOVE_PROPERTY, (Object)true);
                IMoveShapeFeature moveFeature = MoveActivityFeature.this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)newContext);
                if (moveFeature.canMoveShape((IMoveShapeContext)newContext)) {
                    moveFeature.moveShape((IMoveShapeContext)newContext);
                }
            }
        }.doWork(activity, this.getDiagram());
        if (containerShape.eContainer() instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(pe = (PictogramElement)containerShape.eContainer(), SubProcess.class)) {
            this.layoutPictogramElement(pe);
        }
    }
}

