/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.activity;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public abstract class AbstractUpdateMarkerFeature<T extends FlowElement>
extends AbstractUpdateFeature {
    public AbstractUpdateMarkerFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo != null && bo instanceof Activity && context.getPictogramElement() instanceof ContainerShape;
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement element;
        IPeService peService = Graphiti.getPeService();
        String property = peService.getPropertyValue((PropertyContainer)(element = context.getPictogramElement()), this.getPropertyKey());
        if (property == null) {
            return Reason.createFalseReason();
        }
        FlowElement activity = (FlowElement)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        boolean changed = this.isPropertyChanged(activity, property);
        return changed ? Reason.createTrueReason() : Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService peService = Graphiti.getPeService();
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        FlowElement element = (FlowElement)this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        this.doUpdate(element, container);
        peService.setPropertyValue((PropertyContainer)container, this.getPropertyKey(), this.convertPropertyToString(element));
        return true;
    }

    protected abstract String getPropertyKey();

    protected abstract boolean isPropertyChanged(T var1, String var2);

    protected abstract void doUpdate(T var1, ContainerShape var2);

    protected abstract String convertPropertyToString(T var1);
}

