/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;

public class MultiUpdateFeature
extends AbstractUpdateFeature {
    public static final String FORCE_UPDATE_ALL = "force.update.all";
    protected List<IUpdateFeature> features = new ArrayList<IUpdateFeature>();

    public MultiUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        for (IUpdateFeature p : this.features) {
            if (!p.canUpdate(context)) continue;
            return true;
        }
        return false;
    }

    public IReason updateNeeded(IUpdateContext context) {
        String text = null;
        for (IUpdateFeature p : this.features) {
            IReason reason = p.updateNeeded(context);
            if (!reason.toBoolean()) continue;
            text = text == null ? reason.getText() : String.valueOf(text) + "\n" + reason.getText();
        }
        if (text != null) {
            return Reason.createTrueReason(text);
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        boolean updated = false;
        boolean forceUpdate = Boolean.TRUE.equals(context.getProperty((Object)FORCE_UPDATE_ALL));
        for (IUpdateFeature p : this.features) {
            if (!p.updateNeeded(context).toBoolean() && !forceUpdate || !p.update(context)) continue;
            updated = true;
        }
        return updated;
    }

    public void addUpdateFeature(IUpdateFeature feature) {
        if (feature != null) {
            this.features.add(feature);
        }
    }
}

