/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.ModelHandler;
import org.eclipse.bpmn2.modeler.core.features.DefaultMoveBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.ITargetContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class MoveFlowNodeFeature
extends DefaultMoveBPMNShapeFeature {
    private final List<Algorithm> algorithms = new ArrayList<Algorithm>();
    private AlgorithmContainer algorithmContainer;
    protected IMoveShapeContext context;

    public MoveFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
        this.algorithms.add(new FromLaneAlgorithm());
        this.algorithms.add(new ToLaneAlgorithm());
        this.algorithms.add(new FromParticipantAlgorithm());
        this.algorithms.add(new ToParticipantAlgorithm());
        this.algorithms.add(new FromFlowElementsContainerAlgorithm());
        this.algorithms.add(new ToFlowElementsContainerAlgorithm());
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        if (!(this.getBusinessObjectForPictogramElement((PictogramElement)context.getShape()) instanceof FlowNode)) {
            return false;
        }
        try {
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            this.algorithmContainer = this.getAlgorithmContainer(context);
            if (this.algorithmContainer.isEmpty()) {
                return this.onMoveAlgorithmNotFound(context);
            }
            return this.algorithmContainer.isMoveAllowed(this.getSourceBo(context, handler), this.getTargetBo(context, handler));
        }
        catch (IOException e) {
            Activator.logError(e);
            return false;
        }
    }

    protected boolean onMoveAlgorithmNotFound(IMoveShapeContext context) {
        return super.canMoveShape(context);
    }

    public void moveShape(IMoveShapeContext context) {
        this.context = context;
        super.moveShape(context);
    }

    @Override
    protected void postMoveShape(IMoveShapeContext context) {
        try {
            Object[] nodes;
            ModelHandler handler = ModelHandler.getInstance((EObject)this.getDiagram());
            Object[] objectArray = nodes = this.getAllBusinessObjectsForPictogramElement((PictogramElement)context.getShape());
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof FlowNode && this.algorithmContainer != null && !this.algorithmContainer.isEmpty()) {
                    this.algorithmContainer.move((FlowNode)object, this.getSourceBo(context, handler), this.getTargetBo(context, handler));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        super.postMoveShape(context);
    }

    private Object getSourceBo(IMoveShapeContext context, ModelHandler handler) {
        if (context.getSourceContainer().equals(this.getDiagram())) {
            return handler.getFlowElementContainer(context.getSourceContainer());
        }
        return this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
    }

    private Object getTargetBo(IMoveShapeContext context, ModelHandler handler) {
        if (context.getTargetContainer().equals(this.getDiagram())) {
            return handler.getFlowElementContainer(context.getTargetContainer());
        }
        return this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
    }

    private boolean isSourceParticipant(IMoveShapeContext context) {
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        return context.getSourceContainer().equals(this.getDiagram()) || bo != null && bo instanceof Participant;
    }

    private boolean isSourceLane(IMoveShapeContext context) {
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
        return bo != null && bo instanceof Lane;
    }

    private AlgorithmContainer getAlgorithmContainer(IMoveShapeContext context) {
        Algorithm fromAlgorithm = null;
        Algorithm toAlgorithm = null;
        for (Algorithm a : this.algorithms) {
            if (!a.canApplyTo(context)) continue;
            switch (a.getType()) {
                case 0: {
                    fromAlgorithm = a;
                    break;
                }
                case 1: {
                    toAlgorithm = a;
                }
            }
        }
        return new AlgorithmContainer(fromAlgorithm, toAlgorithm);
    }

    static interface Algorithm {
        public static final int TYPE_FROM = 0;
        public static final int TYPE_TO = 1;

        public int getType();

        public boolean canApplyTo(IMoveShapeContext var1);

        public boolean isMoveAllowed(Object var1, Object var2);

        public void move(FlowNode var1, Object var2, Object var3);
    }

    class AlgorithmContainer {
        public Algorithm fromAlgorithm;
        public Algorithm toAlgorithm;

        public AlgorithmContainer(Algorithm fromAlgorithm, Algorithm toAlgorithm) {
            this.fromAlgorithm = fromAlgorithm;
            this.toAlgorithm = toAlgorithm;
        }

        boolean isMoveAllowed(Object source, Object target) {
            return this.fromAlgorithm.isMoveAllowed(source, target) && this.toAlgorithm.isMoveAllowed(source, target);
        }

        void move(FlowNode node, Object source, Object target) {
            this.fromAlgorithm.move(node, source, target);
            this.toAlgorithm.move(node, source, target);
            ArrayList<Connection> connections = new ArrayList<Connection>();
            IFeatureProvider fp = MoveFlowNodeFeature.this.getFeatureProvider();
            Shape shape = MoveFlowNodeFeature.this.context.getShape();
            for (Anchor a : shape.getAnchors()) {
                BaseElement cbo;
                for (Connection c : a.getIncomingConnections()) {
                    cbo = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                    if (!(cbo instanceof SequenceFlow) && !(cbo instanceof MessageFlow) || this.isConnectionValid(cbo)) continue;
                    connections.add(c);
                }
                for (Connection c : a.getOutgoingConnections()) {
                    cbo = BusinessObjectUtil.getFirstBaseElement((PictogramElement)c);
                    if (!(cbo instanceof SequenceFlow) && !(cbo instanceof MessageFlow) || this.isConnectionValid(cbo)) continue;
                    connections.add(c);
                }
            }
            for (Connection c : connections) {
                DeleteContext dc = new DeleteContext((PictogramElement)c);
                IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
                df.delete((IDeleteContext)dc);
            }
        }

        boolean isEmpty() {
            return this.fromAlgorithm == null || this.toAlgorithm == null;
        }

        boolean isConnectionValid(BaseElement flow) {
            EStructuralFeature sourceRef = flow.eClass().getEStructuralFeature("sourceRef");
            EStructuralFeature targetRef = flow.eClass().getEStructuralFeature("targetRef");
            BaseElement source = (BaseElement)flow.eGet(sourceRef);
            BaseElement target = (BaseElement)flow.eGet(targetRef);
            EObject sourceContainer = source.eContainer();
            while (sourceContainer != null) {
                if (sourceContainer instanceof FlowElementsContainer) break;
                sourceContainer = sourceContainer.eContainer();
            }
            if (sourceContainer == null) {
                return true;
            }
            EObject targetContainer = target.eContainer();
            while (targetContainer != null) {
                if (targetContainer instanceof FlowElementsContainer) break;
                targetContainer = targetContainer.eContainer();
            }
            if (targetContainer == null) {
                return true;
            }
            if (flow instanceof SequenceFlow) {
                return sourceContainer == targetContainer;
            }
            if (flow instanceof MessageFlow) {
                return sourceContainer != targetContainer;
            }
            return false;
        }
    }

    abstract class DefaultAlgorithm
    implements Algorithm {
        DefaultAlgorithm() {
        }

        @Override
        public boolean isMoveAllowed(Object source, Object target) {
            return true;
        }

        @Override
        public void move(FlowNode node, Object source, Object target) {
            try {
                ModelHandler handler = ModelHandler.getInstance((EObject)MoveFlowNodeFeature.this.getDiagram());
                handler.moveFlowNode(node, source, target);
            }
            catch (IOException e) {
                Activator.logError(e);
            }
        }
    }

    class FromFlowElementsContainerAlgorithm
    extends DefaultAlgorithm {
        FromFlowElementsContainerAlgorithm() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            Object bo = MoveFlowNodeFeature.this.getBusinessObjectForPictogramElement((PictogramElement)context.getSourceContainer());
            return bo != null && bo instanceof FlowElementsContainer;
        }

        @Override
        public void move(FlowNode node, Object source, Object target) {
        }
    }

    class FromLaneAlgorithm
    extends DefaultAlgorithm {
        FromLaneAlgorithm() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            return MoveFlowNodeFeature.this.isSourceLane(context);
        }

        @Override
        public void move(FlowNode node, Object source, Object target) {
            Lane lane = (Lane)source;
            lane.getFlowNodeRefs().remove(node);
            node.getLanes().remove(lane);
        }
    }

    class FromParticipantAlgorithm
    extends DefaultAlgorithm {
        FromParticipantAlgorithm() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            return MoveFlowNodeFeature.this.isSourceParticipant(context);
        }

        @Override
        public void move(FlowNode node, Object source, Object target) {
        }
    }

    class ToFlowElementsContainerAlgorithm
    extends DefaultAlgorithm {
        ToFlowElementsContainerAlgorithm() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            Object bo = MoveFlowNodeFeature.this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
            return bo != null && bo instanceof FlowElementsContainer;
        }
    }

    class ToLaneAlgorithm
    extends DefaultAlgorithm {
        ToLaneAlgorithm() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            return FeatureSupport.isTargetLane((ITargetContext)context);
        }

        @Override
        public boolean isMoveAllowed(Object source, Object target) {
            Lane lane = (Lane)target;
            return lane.getChildLaneSet() == null || lane.getChildLaneSet().getLanes().isEmpty();
        }

        @Override
        public void move(FlowNode node, Object source, Object target) {
            Lane lane = (Lane)target;
            lane.getFlowNodeRefs().add(node);
            node.getLanes().add(lane);
            super.move(node, source, target);
        }
    }

    class ToParticipantAlgorithm
    extends DefaultAlgorithm {
        ToParticipantAlgorithm() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public boolean canApplyTo(IMoveShapeContext context) {
            return context.getTargetContainer().equals(MoveFlowNodeFeature.this.getDiagram()) || FeatureSupport.isTargetParticipant((ITargetContext)context);
        }

        @Override
        public boolean isMoveAllowed(Object source, Object target) {
            block9: {
                Participant p;
                block11: {
                    block10: {
                        block8: {
                            if (source != target) break block8;
                            return true;
                        }
                        if (!(target instanceof Participant)) break block9;
                        p = (Participant)target;
                        if (!p.equals(ModelHandler.getInstance((EObject)MoveFlowNodeFeature.this.getDiagram()).getInternalParticipant())) break block10;
                        return true;
                    }
                    if (p.getProcessRef() != null) break block11;
                    return true;
                }
                if (p.getProcessRef().getLaneSets().isEmpty()) {
                    return true;
                }
            }
            try {
                FlowElementsContainer p;
                if (target instanceof FlowElementsContainer && (p = (FlowElementsContainer)target).getLaneSets().isEmpty()) {
                    return true;
                }
            }
            catch (Exception e) {
                Activator.logError(e);
            }
            return false;
        }
    }
}

