/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultMoveBPMNShapeFeature
extends DefaultMoveShapeFeature {
    protected int preShapeX;
    protected int preShapeY;

    public DefaultMoveBPMNShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        if (Graphiti.getPeService().getProperty((PropertyContainer)context.getShape(), "ROUTING_NET_LANE") != null) {
            return false;
        }
        ContainerShape targetContainer = context.getTargetContainer();
        if (FeatureSupport.isLabelShape((Shape)targetContainer)) {
            return false;
        }
        if (Graphiti.getPeService().getProperty((PropertyContainer)targetContainer, "ROUTING_NET_LANE") != null) {
            int x = context.getX();
            int y = context.getY();
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)targetContainer);
            ((MoveShapeContext)context).setX(x + loc.getX());
            ((MoveShapeContext)context).setY(y + loc.getY());
            ((MoveShapeContext)context).setSourceContainer(targetContainer.getContainer());
            ((MoveShapeContext)context).setTargetContainer(targetContainer.getContainer());
        }
        return context.getSourceContainer() != null && context.getSourceContainer().equals(context.getTargetContainer());
    }

    protected void preMoveShape(IMoveShapeContext context) {
        super.preMoveShape(context);
        this.preShapeX = 0;
        this.preShapeX = 0;
        if (context.getShape().getGraphicsAlgorithm() != null) {
            this.preShapeX = context.getShape().getGraphicsAlgorithm().getX();
            this.preShapeY = context.getShape().getGraphicsAlgorithm().getY();
        }
    }

    protected void postMoveShape(IMoveShapeContext context) {
        PictogramElement pe;
        DIUtils.updateDIShape(context.getPictogramElement());
        Shape shape = context.getShape();
        for (EObject o : shape.getLink().getBusinessObjects()) {
            if (!(o instanceof Shape) || !FeatureSupport.isLabelShape((Shape)o)) continue;
            ContainerShape textContainerShape = (ContainerShape)o;
            GraphicsUtil.alignWithShape((AbstractText)((Shape)textContainerShape.getChildren().get(0)).getGraphicsAlgorithm(), textContainerShape, shape.getGraphicsAlgorithm().getWidth(), shape.getGraphicsAlgorithm().getHeight(), shape.getGraphicsAlgorithm().getX(), shape.getGraphicsAlgorithm().getY(), this.preShapeX, this.preShapeY);
            if (context.getSourceContainer() == context.getTargetContainer()) break;
            context.getTargetContainer().getChildren().add((Object)textContainerShape);
            break;
        }
        if (shape instanceof ContainerShape && BusinessObjectUtil.containsElementOfType(pe = (PictogramElement)((ContainerShape)shape).eContainer(), SubProcess.class)) {
            this.layoutPictogramElement(pe);
        }
        FeatureSupport.updateConnections(this.getFeatureProvider(), (AnchorContainer)shape);
        for (Connection connection : this.getDiagram().getConnections()) {
            if (!GraphicsUtil.intersects(shape, connection) || Graphiti.getPeService().getProperty((PropertyContainer)connection, "ROUTING_NET_CONNECTION") == null) continue;
            FeatureSupport.updateConnection(this.getFeatureProvider(), connection);
        }
        FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)shape);
        for (Anchor a : shape.getAnchors()) {
            for (Connection c : a.getIncomingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
            for (Connection c : a.getOutgoingConnections()) {
                FeatureSupport.updateCategoryValues(this.getFeatureProvider(), (PictogramElement)c);
            }
        }
    }
}

