/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.features.BendpointConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ManhattanConnectionRouter;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class DefaultLayoutBPMNConnectionFeature
extends AbstractLayoutFeature {
    boolean hasDoneChanges = false;

    public DefaultLayoutBPMNConnectionFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canLayout(ILayoutContext context) {
        Connection connection = (Connection)context.getPictogramElement();
        BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
        Bpmn2Preferences prefs = Bpmn2Preferences.getInstance((EObject)be);
        return prefs.getEnableConnectionRouting();
    }

    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }

    public boolean layout(ILayoutContext context) {
        ShapeStyle ss;
        Bpmn2Preferences preferences;
        Connection connection;
        BaseElement be;
        if (this.canLayout(context) && (be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)(connection = (Connection)context.getPictogramElement()))) != null && (preferences = Bpmn2Preferences.getInstance((EObject)be)) != null && (ss = preferences.getShapeStyle((EObject)be)) != null) {
            IFeatureProvider fp = this.getFeatureProvider();
            BendpointConnectionRouter router = null;
            if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.Manhattan) {
                router = new ManhattanConnectionRouter(fp);
            } else if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.ManualBendpoint) {
                router = new BendpointConnectionRouter(fp);
                ((BendpointConnectionRouter)router).setManualRouting(true);
            } else if (ss.getRoutingStyle() == ShapeStyle.RoutingStyle.AutomaticBendpoint) {
                router = new BendpointConnectionRouter(fp);
                router.setManualRouting(false);
            }
            if (router != null) {
                this.hasDoneChanges = router.route(connection);
                router.dispose();
            }
        }
        return this.hasDoneChanges;
    }
}

