/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.ConnectionRoute;
import org.eclipse.bpmn2.modeler.core.features.DefaultConnectionRouter;
import org.eclipse.bpmn2.modeler.core.features.DetourPoints;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;

public class BendpointConnectionRouter
extends DefaultConnectionRouter {
    protected static final int margin = 10;
    protected FreeFormConnection ffc;
    protected Point movedBendpoint;
    protected Point removedBendpoint;
    protected List<Point> oldPoints;
    protected boolean manual = true;

    public BendpointConnectionRouter(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public boolean route(Connection connection) {
        super.route(connection);
        if (!(connection instanceof FreeFormConnection)) {
            return false;
        }
        this.ffc = (FreeFormConnection)connection;
        this.initialize();
        ConnectionRoute route = this.calculateRoute();
        boolean changed = this.isRouteChanged(route);
        if (changed) {
            this.applyRoute(route);
        }
        this.dispose();
        return changed;
    }

    public void setManualRouting(boolean manual) {
        this.manual = manual;
    }

    public boolean isManualRouting() {
        return this.manual;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.movedBendpoint = BendpointConnectionRouter.getMovedBendpoint((Connection)this.ffc);
        if (this.movedBendpoint == null) {
            this.movedBendpoint = BendpointConnectionRouter.getAddedBendpoint((Connection)this.ffc);
        }
        this.removedBendpoint = BendpointConnectionRouter.getRemovedBendpoint((Connection)this.ffc);
        this.oldPoints = new ArrayList<Point>();
        this.oldPoints.add(GraphicsUtil.createPoint(this.ffc.getStart()));
        for (Point p : this.ffc.getBendpoints()) {
            this.oldPoints.add(GraphicsUtil.createPoint(p));
        }
        this.oldPoints.add(GraphicsUtil.createPoint(this.ffc.getEnd()));
    }

    protected ConnectionRoute calculateRoute() {
        Point pEnd;
        Point pStart;
        AnchorUtil.BoundaryAnchor ba;
        if (this.isSelfConnection()) {
            return this.calculateSelfConnectionRoute();
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        if (this.sourceAnchor == null) {
            ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.source, this.oldPoints.get(1));
            pStart = GraphicsUtil.createPoint((Anchor)ba.anchor);
        } else {
            pStart = this.oldPoints.get(0);
        }
        if (this.targetAnchor == null) {
            ba = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.target, this.oldPoints.get(this.oldPoints.size() - 2));
            pEnd = GraphicsUtil.createPoint((Anchor)ba.anchor);
        } else {
            pEnd = this.oldPoints.get(this.oldPoints.size() - 1);
        }
        route.add(pStart);
        if (!this.manual) {
            this.oldPoints.clear();
            this.oldPoints.add(pStart);
            if (this.movedBendpoint != null) {
                this.oldPoints.add(this.movedBendpoint);
            }
            this.oldPoints.add(pEnd);
        }
        Point p1 = pStart;
        int i = 1;
        while (i < this.oldPoints.size() - 1) {
            Point p2 = this.oldPoints.get(i);
            ContainerShape shape = this.getCollision(p1, p2);
            if (shape != null && !this.manual) {
                if (shape == this.target) {
                    if (this.targetAnchor != null) break;
                    AnchorUtil.BoundaryAnchor ba2 = AnchorUtil.findNearestBoundaryAnchor((AnchorContainer)this.target, p1);
                    pEnd = GraphicsUtil.createPoint((Anchor)ba2.anchor);
                    break;
                }
                DetourPoints detour = new DetourPoints(shape, 10);
                for (Point d : detour.calculateDetour(p1, p2)) {
                    if (!route.add(d)) {
                        ++i;
                        break;
                    }
                    p2 = d;
                }
                --i;
            } else {
                route.add(p2);
            }
            p1 = p2;
            ++i;
        }
        route.add(pEnd);
        this.oldPoints.clear();
        return route;
    }

    protected ConnectionRoute calculateSelfConnectionRoute() {
        if (!this.isSelfConnection()) {
            return null;
        }
        if (this.movedBendpoint == null && this.ffc.getStart() != this.ffc.getEnd() && this.ffc.getBendpoints().size() > 0 && !BendpointConnectionRouter.forceRouting((Connection)this.ffc)) {
            return null;
        }
        Map<AnchorUtil.AnchorLocation, AnchorUtil.BoundaryAnchor> targetBoundaryAnchors = AnchorUtil.getBoundaryAnchors((AnchorContainer)this.target);
        AnchorUtil.BoundaryAnchor targetTop = targetBoundaryAnchors.get((Object)AnchorUtil.AnchorLocation.TOP);
        AnchorUtil.BoundaryAnchor targetRight = targetBoundaryAnchors.get((Object)AnchorUtil.AnchorLocation.RIGHT);
        ILocation loc = peService.getLocationRelativeToDiagram(this.target);
        IDimension size = GraphicsUtil.calculateSize((AnchorContainer)this.target);
        int x1 = loc.getX() + size.getWidth() + 20;
        int y1 = loc.getY() + size.getHeight() / 2;
        int x2 = loc.getX() + size.getWidth() / 2;
        int y2 = loc.getY() - 20;
        Point right = gaService.createPoint(x1, y1);
        Point corner = gaService.createPoint(x1, y2);
        Point top = gaService.createPoint(x2, y2);
        Point p = this.movedBendpoint;
        if (p != null) {
            int x = p.getX();
            int y = p.getY();
            if (x > loc.getX() + size.getWidth() + 2) {
                right.setX(x);
                corner.setX(x);
            }
            if (y < loc.getY() - 2) {
                top.setY(y);
                corner.setY(y);
            }
        }
        ConnectionRoute route = new ConnectionRoute(this, 1, this.source, this.target);
        route.add(GraphicsUtil.createPoint((Anchor)targetRight.anchor));
        route.add(right);
        route.add(corner);
        route.add(top);
        route.add(GraphicsUtil.createPoint((Anchor)targetTop.anchor));
        return route;
    }

    protected boolean isRouteChanged(ConnectionRoute route) {
        if (route == null || route.size() == 0) {
            return false;
        }
        if (this.oldPoints.size() != route.size()) {
            return true;
        }
        int i = 0;
        while (i < this.oldPoints.size()) {
            Point p2;
            Point p1 = this.oldPoints.get(i);
            if (!GraphicsUtil.pointsEqual(p1, p2 = route.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void applyRoute(ConnectionRoute route) {
        route.apply(this.ffc, this.sourceAnchor, this.targetAnchor);
        DIUtils.updateDIEdge((Connection)this.ffc);
    }

    protected DetourPoints getDetourPoints(ContainerShape shape) {
        DetourPoints detour = new DetourPoints(shape, 10);
        return detour;
    }

    public static void setMovedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "moved.", index);
    }

    public static void setAddedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "added.", index);
    }

    public static void setRemovedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "removed.", index);
    }

    public static void setFixedBendpoint(Connection connection, int index) {
        BendpointConnectionRouter.setInterestingBendpoint(connection, "fixed." + index + ".", index);
    }

    protected static void setInterestingBendpoint(Connection connection, String type, int index) {
        if (connection instanceof FreeFormConnection) {
            int size = ((FreeFormConnection)connection).getBendpoints().size();
            if (index >= 0 && size > 0) {
                if (index >= size) {
                    index = size - 1;
                }
                AbstractConnectionRouter.setRoutingInfoInt(connection, String.valueOf(type) + "bendpoint", index);
            } else {
                AbstractConnectionRouter.removeRoutingInfo(connection, String.valueOf(type) + "bendpoint");
            }
        }
    }

    public static Point getMovedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "moved.");
    }

    public static Point getAddedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "added.");
    }

    public static Point getRemovedBendpoint(Connection connection) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "removed.");
    }

    public static Point getFixedBendpoint(Connection connection, int index) {
        return BendpointConnectionRouter.getInterestingBendpoint(connection, "fixed." + index + ".");
    }

    protected static Point getInterestingBendpoint(Connection connection, String type) {
        try {
            int index = AbstractConnectionRouter.getRoutingInfoInt(connection, String.valueOf(type) + "bendpoint");
            return (Point)((FreeFormConnection)connection).getBendpoints().get(index);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

