/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.IBpmn2CreateFeature;
import org.eclipse.bpmn2.modeler.core.features.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractBpmn2CreateFeature<T extends BaseElement>
extends AbstractCreateFeature
implements IBpmn2CreateFeature<T, ICreateContext> {
    protected boolean changesDone = true;

    public AbstractBpmn2CreateFeature(IFeatureProvider fp, String name, String description) {
        super(fp, name, description);
    }

    public boolean isAvailable(IContext context) {
        return this.isModelObjectEnabled();
    }

    public String getCreateDescription() {
        return NLS.bind((String)Messages.AbstractBpmn2CreateFeature_Create, (Object)ModelUtil.toDisplayName(this.getBusinessObjectClass().getName()));
    }

    @Override
    public T createBusinessObject(ICreateContext context) {
        ContainerShape shape = context.getTargetContainer();
        EObject container = BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)shape);
        Resource resource = container.eResource();
        EClass eclass = this.getBusinessObjectClass();
        ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eclass);
        BaseElement businessObject = (BaseElement)adapter.getObjectDescriptor().createObject(resource, eclass);
        this.putBusinessObject(context, (T)businessObject);
        this.changesDone = true;
        return (T)businessObject;
    }

    @Override
    public T getBusinessObject(ICreateContext context) {
        return (T)((BaseElement)context.getProperty((Object)"businessObject"));
    }

    @Override
    public void putBusinessObject(ICreateContext context, T businessObject) {
        context.putProperty((Object)"businessObject", businessObject);
        String id = (String)context.getProperty((Object)"custom.element.id");
        if (id != null) {
            TargetRuntime rt = TargetRuntime.getCurrentRuntime();
            CustomTaskDescriptor ctd = rt.getCustomTask(id);
            ctd.populateObject((EObject)businessObject, businessObject.eResource(), true);
        }
    }

    @Override
    public void postExecute(IExecutionInfo executionInfo) {
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext fc = iFeatureAndContextArray[n2];
            IContext context = fc.getContext();
            if (context instanceof ICreateContext) {
                ICreateContext cc = (ICreateContext)context;
                T businessObject = this.getBusinessObject(cc);
                Bpmn2Preferences prefs = (Bpmn2Preferences)((DiagramEditor)this.getDiagramEditor()).getAdapter(Bpmn2Preferences.class);
                if (prefs != null && prefs.getShowPopupConfigDialog(businessObject)) {
                    ObjectEditingDialog dialog = new ObjectEditingDialog((DiagramEditor)this.getDiagramEditor(), (EObject)businessObject);
                    dialog.open();
                }
            }
            ++n2;
        }
    }

    protected AddContext createAddContext(ICreateContext context, Object newObject) {
        AddContext newContext = new AddContext((IAreaContext)context, newObject);
        Object value = context.getProperty((Object)"custom.element.id");
        newContext.putProperty((Object)"custom.element.id", value);
        value = context.getProperty((Object)DIImport.IMPORT_PROPERTY);
        newContext.putProperty((Object)DIImport.IMPORT_PROPERTY, value);
        value = context.getProperty((Object)"businessObject");
        newContext.putProperty((Object)"businessObject", value);
        return newContext;
    }

    protected boolean isModelObjectEnabled() {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(this.getBusinessObjectClass());
        }
        return false;
    }

    protected boolean isModelObjectEnabled(EObject o) {
        ModelEnablements me = this.getModelEnablements();
        if (me != null) {
            return me.isEnabled(o.eClass());
        }
        return false;
    }

    protected ModelEnablements getModelEnablements() {
        DiagramEditor editor = (DiagramEditor)this.getDiagramEditor();
        return (ModelEnablements)editor.getAdapter(ModelEnablements.class);
    }

    public boolean hasDoneChanges() {
        return this.changesDone;
    }
}

