/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.di;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNShape;

public class DiagramElementTreeNode
implements Iterable<DiagramElementTreeNode> {
    private static List<DiagramElementTreeNode> EMPTY = new ArrayList<DiagramElementTreeNode>();
    private DiagramElementTreeNode parent;
    private BaseElement baseElement;
    private List<DiagramElementTreeNode> children;
    private boolean checked = true;
    private BPMNShape bpmnShape;

    public DiagramElementTreeNode(DiagramElementTreeNode parent, BaseElement element) {
        this.parent = parent;
        this.baseElement = element;
    }

    public BaseElement getBaseElement() {
        return this.baseElement;
    }

    public void setBaseElement(BaseElement baseElement) {
        this.baseElement = baseElement;
    }

    public BPMNShape getBpmnShape() {
        return this.bpmnShape;
    }

    public void setBpmnShape(BPMNShape bpmnShape) {
        this.bpmnShape = bpmnShape;
    }

    public DiagramElementTreeNode getParent() {
        return this.parent;
    }

    public boolean getChecked() {
        return this.checked;
    }

    private void setParentChecked(boolean checked) {
        if (this.parent != null) {
            if (!checked) {
                if (this.parent.hasChildren()) {
                    for (DiagramElementTreeNode child : this.parent.children) {
                        if (!child.getChecked()) continue;
                        checked = true;
                        break;
                    }
                }
                this.parent.checked = checked;
            } else {
                this.parent.checked = true;
            }
            this.parent.setParentChecked(checked);
        }
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                child.setChecked(checked);
            }
        }
        this.setParentChecked(checked);
    }

    public DiagramElementTreeNode addChild(BaseElement element) {
        DiagramElementTreeNode child = this.getChild(element);
        if (child != null) {
            return child;
        }
        if (this.children == null) {
            this.children = new ArrayList<DiagramElementTreeNode>();
        }
        DiagramElementTreeNode newElement = new DiagramElementTreeNode(this, element);
        this.children.add(newElement);
        return newElement;
    }

    public DiagramElementTreeNode getChild(BaseElement element) {
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                if (child.getBaseElement() != element) continue;
                return child;
            }
        }
        return null;
    }

    public void removeChild(BaseElement element) {
        if (this.hasChildren()) {
            for (DiagramElementTreeNode child : this.children) {
                if (child.getBaseElement() != element) continue;
                this.children.remove(child);
                break;
            }
        }
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public List<DiagramElementTreeNode> getChildren() {
        if (this.hasChildren()) {
            return this.children;
        }
        return EMPTY;
    }

    @Override
    public Iterator<DiagramElementTreeNode> iterator() {
        return new Iterator<DiagramElementTreeNode>(){
            int iteratorIndex = -1;
            int childIndex = 0;
            List<Iterator<DiagramElementTreeNode>> iterators;

            @Override
            public boolean hasNext() {
                if (!DiagramElementTreeNode.this.hasChildren()) {
                    return false;
                }
                if (this.iteratorIndex == -1) {
                    this.iteratorIndex = 0;
                    this.iterators = new ArrayList<Iterator<DiagramElementTreeNode>>();
                    for (DiagramElementTreeNode child : DiagramElementTreeNode.this.children) {
                        this.iterators.add(child.iterator());
                    }
                }
                return this.iteratorIndex < this.iterators.size() || this.childIndex < DiagramElementTreeNode.this.children.size();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public DiagramElementTreeNode next() {
                if (DiagramElementTreeNode.this.hasChildren()) ** GOTO lbl7
                return null;
lbl-1000:
                // 1 sources

                {
                    iter = this.iterators.get(this.iteratorIndex);
                    if (iter.hasNext()) {
                        return iter.next();
                    }
                    ++this.iteratorIndex;
lbl7:
                    // 2 sources

                    ** while (this.iteratorIndex < this.iterators.size())
                }
lbl8:
                // 1 sources

                if (this.childIndex < DiagramElementTreeNode.access$0(DiagramElementTreeNode.this).size()) {
                    return (DiagramElementTreeNode)DiagramElementTreeNode.access$0(DiagramElementTreeNode.this).get(this.childIndex++);
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

