/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.builder;

import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.bpmn2.modeler.core.validation.BPMN2ProjectValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BPMN2Builder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.bpmn2.modeler.core.bpmn2Builder";
    private static final String MARKER_TYPE = "org.eclipse.bpmn2.modeler.core.xmlProblem";
    private SAXParserFactory parserFactory;

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new BPMN2DeltaVisitor(monitor));
    }

    void validate(IResourceDelta delta, IProgressMonitor monitor) {
        BPMN2ProjectValidator.validate(delta, monitor);
    }

    void validate(IResource resource, IProgressMonitor monitor) {
        BPMN2ProjectValidator.validate(resource, monitor);
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new BPMN2ResourceVisitor(monitor));
        }
        catch (CoreException coreException) {}
    }

    private void addMarker(IFile file, String message, int lineNumber, int severity) {
        try {
            IMarker marker = file.createMarker(MARKER_TYPE);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber == -1) {
                lineNumber = 1;
            }
            marker.setAttribute("lineNumber", lineNumber);
        }
        catch (CoreException coreException) {}
    }

    void checkXML(IResource resource) {
        if (BPMN2ProjectValidator.isBPMN2File(resource)) {
            IFile file = (IFile)resource;
            this.deleteMarkers(file);
            XMLErrorHandler reporter = new XMLErrorHandler(file);
            try {
                this.getParser().parse(file.getContents(), (DefaultHandler)reporter);
            }
            catch (Exception exception) {}
        }
    }

    private void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {}
    }

    private SAXParser getParser() throws ParserConfigurationException, SAXException {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory.newSAXParser();
    }

    class BPMN2DeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor monitor;

        public BPMN2DeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            switch (delta.getKind()) {
                case 1: {
                    BPMN2Builder.this.validate(delta, this.monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    BPMN2Builder.this.validate(delta, this.monitor);
                }
            }
            return true;
        }
    }

    class BPMN2ResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor monitor;

        public BPMN2ResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            BPMN2Builder.this.validate(resource, this.monitor);
            return true;
        }
    }

    private class XMLErrorHandler
    extends DefaultHandler {
        private IFile file;

        public XMLErrorHandler(IFile file) {
            this.file = file;
        }

        private void addMarker(SAXParseException e, int severity) {
            BPMN2Builder.this.addMarker(this.file, e.getMessage(), e.getLineNumber(), severity);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 2);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.addMarker(exception, 1);
        }
    }
}

