/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ObjectDescriptor;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class FeatureDescriptor<T extends EObject>
extends ObjectDescriptor<T> {
    protected EStructuralFeature feature;
    protected int multiline = 0;
    protected Hashtable<String, Object> choiceOfValues;

    public FeatureDescriptor(AdapterFactory adapterFactory, T object, EStructuralFeature feature) {
        super(adapterFactory, object);
        this.feature = feature;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getLabel(Object context) {
        Object object = this.adopt(context);
        if (this.label == null) {
            IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(this.feature);
            this.label = propertyDescriptor != null ? propertyDescriptor.getDisplayName(object) : (this.feature instanceof EReference && this.feature.getEType().getInstanceClass() != EObject.class ? ModelUtil.getLabel(this.feature.getEType()) : ModelUtil.toDisplayName(this.feature.getName()));
        }
        return this.label;
    }

    @Override
    public void setDisplayName(String text) {
        this.name = text;
    }

    @Override
    public String getDisplayName(Object context) {
        Object object = this.adopt(context);
        if (this.name == null) {
            Object id;
            String name;
            String t = null;
            EObject o = null;
            EStructuralFeature f = null;
            if (this.feature != null) {
                Object value = object.eGet(this.feature);
                if (value instanceof EObject) {
                    o = (EObject)value;
                } else if (value != null) {
                    t = value.toString();
                }
            }
            if (t == null && o != null && (f = o.eClass().getEStructuralFeature("name")) != null && (name = (String)o.eGet(f)) != null && !name.isEmpty()) {
                t = name;
            }
            if (t == null && o != null && (f = o.eClass().getEStructuralFeature("id")) != null && (id = o.eGet(f)) != null && !id.toString().isEmpty()) {
                t = id.toString();
            }
            return t == null ? "" : t;
        }
        return this.name == null ? "" : this.name;
    }

    public void setChoiceOfValues(Hashtable<String, Object> choiceOfValues) {
        this.choiceOfValues = choiceOfValues;
    }

    public void setChoiceOfValues(Collection values) {
        if (values != null) {
            this.choiceOfValues = new Hashtable();
            for (Object value : values) {
                if (value == null) continue;
                String text = this.getChoiceString(value);
                while (this.choiceOfValues.containsKey(text)) {
                    text = String.valueOf(text) + " ";
                }
                this.choiceOfValues.put(text, value);
            }
        }
    }

    public Hashtable<String, Object> getChoiceOfValues(Object context) {
        EObject object;
        EObject eObject = object = context instanceof EObject ? (EObject)context : this.object;
        if (this.choiceOfValues == null) {
            Collection<Object> values = null;
            try {
                IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(this.feature);
                if (propertyDescriptor != null) {
                    values = propertyDescriptor.getChoiceOfValues((Object)object);
                }
            }
            catch (Exception exception) {}
            if (values == null) {
                values = ModelUtil.getAllReachableObjects(object, this.feature);
            }
            if (values != null) {
                Hashtable<String, Object> choices = new Hashtable<String, Object>();
                for (Object value : values) {
                    if (value == null) continue;
                    String text = this.getChoiceString(value);
                    if (text == null) {
                        text = "";
                    }
                    while (choices.containsKey(text)) {
                        text = String.valueOf(text) + " ";
                    }
                    choices.put(text, value);
                }
                return choices;
            }
        }
        return this.choiceOfValues;
    }

    public String getChoiceString(Object value) {
        if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt(eObject);
            if (adapter != null) {
                return adapter.getObjectDescriptor().getDisplayName(eObject);
            }
            return ModelUtil.toDisplayName(eObject.eClass().getName());
        }
        return value.toString();
    }

    public void setMultiLine(boolean multiline) {
        this.multiline = multiline ? 1 : -1;
    }

    public boolean isMultiLine(Object context) {
        IItemPropertyDescriptor propertyDescriptor;
        Object object = this.adopt(context);
        if (this.multiline == 0 && (propertyDescriptor = this.getPropertyDescriptor(this.feature)) != null) {
            int n = this.multiline = propertyDescriptor.isMultiLine(object) ? 1 : -1;
        }
        return this.multiline == 1;
    }

    public EObject createFeature(Object context) {
        Object object = this.adopt(context);
        if (context instanceof EClass) {
            return this.createFeature(object, (EClass)context);
        }
        return this.createFeature(context, null);
    }

    public EObject createFeature(Object context, EClass eclass) {
        Object object = this.adopt(context);
        return this.createFeature(object.eResource(), context, eclass);
    }

    public EObject createFeature(Resource resource, Object context, EClass eclass) {
        Object object = this.adopt(context);
        Object newFeature = null;
        try {
            ExtendedPropertiesAdapter adapter;
            if (context instanceof EClass) {
                eclass = (EClass)context;
            }
            if (eclass == null) {
                eclass = (EClass)this.feature.getEType();
            }
            if ((adapter = ExtendedPropertiesAdapter.adapt(eclass)) != null) {
                if (resource == null) {
                    resource = object.eResource();
                }
                if ((newFeature = (Object)adapter.getObjectDescriptor().createObject(resource, eclass)).eContainer() != null || this.feature instanceof EAttribute || this.feature instanceof EReference && ((EReference)this.feature).isContainment()) {
                    if (object.eGet(this.feature) instanceof List) {
                        ((List)object.eGet(this.feature)).add(newFeature);
                    } else {
                        object.eSet(this.feature, newFeature);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newFeature;
    }

    public Object getValue() {
        return this.getValue(this.object);
    }

    public Object getValue(Object context) {
        Object object = this.adopt(context);
        return object.eGet(this.feature);
    }

    public void setValue(Object value) {
        this.setValue(this.object, value);
    }

    public void setValue(Object context, final Object value) {
        Object object = this.adopt(context);
        if (object.eGet(this.feature) instanceof EObjectEList) {
            final EObjectEList list = (EObjectEList)object.eGet(this.feature);
            TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
            if (editingDomain == null) {
                list.add(value);
                this.insertRootElementIfNeeded(value);
            } else {
                editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        list.add(value);
                        FeatureDescriptor.this.insertRootElementIfNeeded(value);
                    }
                });
            }
        } else {
            IItemPropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(object, this.feature);
            if (propertyDescriptor != null) {
                propertyDescriptor.setPropertyValue(object, value);
            } else {
                TransactionalEditingDomain editingDomain = this.getEditingDomain(object);
                if (editingDomain == null) {
                    object.eSet(this.feature, value);
                    this.insertRootElementIfNeeded(value);
                } else {
                    editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, (EObject)object, value){
                        private final /* synthetic */ EObject val$object;
                        private final /* synthetic */ Object val$value;
                        {
                            this.val$object = eObject;
                            this.val$value = object;
                            super($anonymous0);
                        }

                        protected void doExecute() {
                            this.val$object.eSet(FeatureDescriptor.this.feature, this.val$value);
                            FeatureDescriptor.this.insertRootElementIfNeeded(this.val$value);
                        }
                    });
                }
            }
        }
    }

    public void unset() {
        this.unset(this.object);
    }

    public void unset(Object context) {
        Object object = this.adopt(context);
        this.setValue(object, this.feature.getDefaultValue());
    }

    private void insertRootElementIfNeeded(Object value) {
        Definitions definitions;
        if (value instanceof RootElement && ((RootElement)value).eContainer() == null && (definitions = ModelUtil.getDefinitions(this.object)) != null) {
            definitions.getRootElements().add((RootElement)value);
        }
    }

    @Override
    public boolean equals(Object obj) {
        Object thisValue = this.object.eGet(this.feature);
        if (thisValue == null && obj == null) {
            return true;
        }
        if (thisValue instanceof EObject && obj instanceof EObject) {
            return FeatureDescriptor.compare((EObject)thisValue, (EObject)obj, false);
        }
        if (thisValue != null && obj != null) {
            return thisValue.equals(obj);
        }
        return false;
    }

    @Override
    public boolean similar(Object obj) {
        Object thisValue = this.object.eGet(this.feature);
        if (thisValue == null && obj == null) {
            return true;
        }
        if (thisValue instanceof EObject && obj instanceof EObject) {
            return FeatureDescriptor.compare((EObject)thisValue, (EObject)obj, true);
        }
        if (thisValue != null && obj != null) {
            return thisValue.equals(obj);
        }
        return false;
    }
}

