/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.elements.adapters;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerManager;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.internal.ui.views.launch.DecorationManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;

public class StackFrameSourceDisplayAdapter
implements ISourceDisplay {
    private IStackFrame fPrevFrame;
    private SourceLookupResult fPrevResult;

    public StackFrameSourceDisplayAdapter() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    final DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 8: {
                            StackFrameSourceDisplayAdapter.this.clearCachedModel(event.getSource());
                        }
                        case 1: {
                            if (event.isEvaluation()) break;
                            UIJob uijob = new UIJob("clear source selection"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    StackFrameSourceDisplayAdapter.this.clearSourceSelection(event.getSource());
                                    return Status.OK_STATUS;
                                }
                            };
                            uijob.setSystem(true);
                            uijob.schedule();
                            break;
                        }
                        case 16: {
                            if (!(event.getSource() instanceof IStackFrame) || event.getDetail() != 512) break;
                            StackFrameSourceDisplayAdapter.this.clearCachedModel(event.getSource());
                            break;
                        }
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public synchronized void displaySource(Object context, IWorkbenchPage page, boolean force) {
        IStackFrame frame = (IStackFrame)context;
        if (!force && frame.equals(this.fPrevFrame)) {
            this.fPrevResult.updateArtifact(context);
            SourceDisplayJob sdj = new SourceDisplayJob(this.fPrevResult, page);
            Job.getJobManager().cancel((Object)sdj);
            sdj.schedule();
        } else {
            SourceLookupJob slj = new SourceLookupJob(frame, frame.getLaunch().getSourceLocator(), page);
            Job.getJobManager().cancel((Object)slj);
            slj.schedule();
        }
    }

    private void clearSourceSelection(Object source) {
        if (source instanceof IThread) {
            IThread thread = (IThread)source;
            DecorationManager.removeDecorations(thread);
            InstructionPointerManager.getDefault().removeAnnotations(thread);
        } else if (source instanceof IDebugTarget) {
            IDebugTarget target = (IDebugTarget)source;
            DecorationManager.removeDecorations(target);
            InstructionPointerManager.getDefault().removeAnnotations(target);
        }
    }

    private synchronized void clearCachedModel(Object source) {
        if (this.fPrevFrame != null) {
            IDebugTarget target = null;
            if (source instanceof IDebugElement) {
                target = ((IDebugElement)source).getDebugTarget();
            }
            if (this.fPrevFrame.getDebugTarget().equals(target)) {
                this.fPrevFrame = null;
                this.fPrevResult = null;
            }
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;

        public SourceDisplayJob(ISourceLookupResult result, IWorkbenchPage page) {
            super("Debug Source Display");
            this.setSystem(true);
            this.setPriority(10);
            this.fResult = result;
            this.fPage = page;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && this.fResult != null) {
                Object artifact;
                DebugUITools.displaySource(this.fResult, this.fPage);
                if (monitor.isCanceled() && (artifact = this.fResult.getArtifact()) instanceof IStackFrame) {
                    StackFrameSourceDisplayAdapter.this.clearSourceSelection(((IStackFrame)artifact).getThread());
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof SourceDisplayJob) {
                SourceDisplayJob sdj = (SourceDisplayJob)((Object)family);
                return sdj.fPage.equals(this.fPage);
            }
            return false;
        }
    }

    class SourceLookupJob
    extends Job {
        private IStackFrame fTarget;
        private ISourceLocator fLocator;
        private IWorkbenchPage fPage;

        public SourceLookupJob(IStackFrame frame, ISourceLocator locator, IWorkbenchPage page) {
            super("Debug Source Lookup");
            this.setPriority(10);
            this.setSystem(true);
            this.fTarget = frame;
            this.fLocator = locator;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled() && !this.fTarget.isTerminated()) {
                ISourceLookupResult result = DebugUITools.lookupSource(this.fTarget, this.fLocator);
                StackFrameSourceDisplayAdapter stackFrameSourceDisplayAdapter = StackFrameSourceDisplayAdapter.this;
                synchronized (stackFrameSourceDisplayAdapter) {
                    StackFrameSourceDisplayAdapter.this.fPrevResult = (SourceLookupResult)result;
                    StackFrameSourceDisplayAdapter.this.fPrevFrame = this.fTarget;
                }
                if (!monitor.isCanceled() && !this.fTarget.isTerminated()) {
                    new SourceDisplayJob(result, this.fPage).schedule();
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            if (family instanceof SourceLookupJob) {
                SourceLookupJob slj = (SourceLookupJob)((Object)family);
                return slj.fPage.equals(this.fPage);
            }
            return false;
        }
    }
}

