/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.core.project.facet;

import org.eclipse.osgi.util.NLS;
import org.jboss.tools.seam.core.SeamUtil;

public enum SeamVersion {
    SEAM_1_2("1.2"),
    SEAM_2_0("2.0"),
    SEAM_2_1("2.1"),
    SEAM_2_2("2.2"),
    SEAM_2_3("2.3");

    String version = "";
    public static SeamVersion[] ALL_VERSIONS;

    static {
        ALL_VERSIONS = new SeamVersion[]{SEAM_1_2, SEAM_2_0, SEAM_2_1, SEAM_2_2, SEAM_2_3};
    }

    private SeamVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.version;
    }

    public static SeamVersion parseFromString(String version) {
        if (SEAM_1_2.toString().equals(version)) {
            return SEAM_1_2;
        }
        if (SEAM_2_0.toString().equals(version)) {
            return SEAM_2_0;
        }
        if (SEAM_2_1.toString().equals(version)) {
            return SEAM_2_1;
        }
        if (SEAM_2_2.toString().equals(version)) {
            return SEAM_2_2;
        }
        if (SEAM_2_3.toString().equals(version)) {
            return SEAM_2_3;
        }
        throw new IllegalArgumentException(NLS.bind((String)"Seam version ''{0}'' is not supported", (Object)version));
    }

    public static SeamVersion getLatestDefaultVersion() {
        return SEAM_2_2;
    }

    public static SeamVersion findByString(String version) {
        if (SEAM_1_2.toString().equals(version)) {
            return SEAM_1_2;
        }
        if (SEAM_2_0.toString().equals(version)) {
            return SEAM_2_0;
        }
        if (SEAM_2_1.toString().equals(version)) {
            return SEAM_2_1;
        }
        if (SEAM_2_2.toString().equals(version)) {
            return SEAM_2_2;
        }
        if (SEAM_2_3.toString().equals(version)) {
            return SEAM_2_3;
        }
        return null;
    }

    public static SeamVersion findMatchingVersion(String vs) {
        if (vs == null) {
            return null;
        }
        if (SeamUtil.areSeamVersionsMatched(SEAM_1_2.toString(), vs)) {
            return SEAM_1_2;
        }
        if (SeamUtil.areSeamVersionsMatched(SEAM_2_0.toString(), vs)) {
            return SEAM_2_0;
        }
        if (SeamUtil.areSeamVersionsMatched(SEAM_2_1.toString(), vs)) {
            return SEAM_2_1;
        }
        if (SeamUtil.areSeamVersionsMatched(SEAM_2_2.toString(), vs)) {
            return SEAM_2_2;
        }
        if (SeamUtil.areSeamVersionsMatched(SEAM_2_3.toString(), vs)) {
            return SEAM_2_3;
        }
        return null;
    }
}

