/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.util.mediator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.core.mediator.IMediatorTarget;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.core.DisposeEvent;
import org.eclipse.birt.report.model.api.core.IDisposeListener;

public class ModuleMediatorTarget
implements IMediatorTarget {
    private ModuleHandle model;
    private Map<IMediatorTarget.ITargetDisposeListener, IDisposeListener> listeners;

    public ModuleMediatorTarget(ModuleHandle model) {
        this.model = model;
        this.listeners = new HashMap<IMediatorTarget.ITargetDisposeListener, IDisposeListener>();
    }

    public int hashCode() {
        return this.model == null ? 0 : this.model.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModuleMediatorTarget)) {
            return false;
        }
        if (((ModuleMediatorTarget)obj).model == this.model) {
            return true;
        }
        if (this.model != null) {
            return this.model.equals(((ModuleMediatorTarget)obj).model);
        }
        return false;
    }

    public void addDisposeListener(final IMediatorTarget.ITargetDisposeListener listener) {
        if (this.model != null && listener != null) {
            if (this.listeners.containsKey(listener)) {
                return;
            }
            IDisposeListener modelListener = new IDisposeListener(){

                public void moduleDisposed(ModuleHandle targetElement, DisposeEvent ev) {
                    listener.dispose(new ModuleMediatorTarget(targetElement));
                }
            };
            this.listeners.put(listener, modelListener);
            this.model.addDisposeListener(modelListener);
        }
    }

    public void removeDisposeListener(IMediatorTarget.ITargetDisposeListener listener) {
        IDisposeListener modelListener;
        if (this.model != null && listener != null && (modelListener = this.listeners.remove(listener)) != null) {
            this.model.removeDisposeListener(modelListener);
        }
    }
}

