/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.mediator;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.birt.report.designer.core.mediator.IMediator;
import org.eclipse.birt.report.designer.core.mediator.IMediatorColleague;
import org.eclipse.birt.report.designer.core.mediator.IMediatorTarget;
import org.eclipse.birt.report.designer.core.mediator.impl.MediatorImpl;

public final class MediatorManager {
    private static volatile MediatorManager manager;
    private Map<IMediatorTarget, IMediator> mediatorMap = new WeakHashMap<IMediatorTarget, IMediator>();
    private IMediatorTarget.ITargetDisposeListener listener = new IMediatorTarget.ITargetDisposeListener(){

        public void dispose(IMediatorTarget target) {
            MediatorManager.this.removeMediator(target);
        }
    };

    public static synchronized MediatorManager getInstance() {
        if (manager == null) {
            manager = new MediatorManager();
        }
        return manager;
    }

    public static void addGlobalColleague(IMediatorColleague colleague) {
        MediatorImpl.addGlobalColleague(colleague);
    }

    public static void removeGlobalColleague(IMediatorColleague colleague) {
        MediatorImpl.removeGlobalColleague(colleague);
    }

    public IMediator getMediator(IMediatorTarget target, boolean force) {
        if (target == null) {
            return null;
        }
        IMediator mediator = this.mediatorMap.get(target);
        if (mediator == null && force) {
            mediator = new MediatorImpl();
            this.mediatorMap.put(target, mediator);
            target.addDisposeListener(this.listener);
        }
        return mediator;
    }

    public void removeMediator(IMediatorTarget target) {
        if (target == null) {
            return;
        }
        target.removeDisposeListener(this.listener);
        IMediator mediator = this.mediatorMap.remove(target);
        if (mediator != null) {
            mediator.dispose();
        }
    }

    public void resetTarget(IMediatorTarget oldTarget, IMediatorTarget newTarget) {
        if (oldTarget == null || newTarget == null) {
            return;
        }
        IMediator mediator = this.mediatorMap.get(oldTarget);
        if (mediator == null) {
            return;
        }
        oldTarget.removeDisposeListener(this.listener);
        this.mediatorMap.remove(oldTarget);
        newTarget.addDisposeListener(this.listener);
        this.mediatorMap.put(newTarget, mediator);
    }
}

