/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.wizards.xpl.export;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.ide.eclipse.as.wtp.core.util.VCFUtil;
import org.jboss.ide.eclipse.as.wtp.core.vcf.ModuleExportOperation;
import org.jboss.ide.eclipse.as.wtp.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.ui.WTPOveridePlugin;

public class ProjectModuleExportDataModelProvider
extends AbstractDataModelProvider
implements IJ2EEComponentExportDataModelProperties {
    public HashMap<String, IVirtualComponent> componentMap;

    public IDataModelOperation getDefaultOperation() {
        return new ModuleExportOperation(this.model);
    }

    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.RUN_BUILD");
        propertyNames.add("IJ2EEComponentExportDataModelProperties.COMPONENT");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")) {
            return "";
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.RUN_BUILD")) {
            return Boolean.TRUE;
        }
        return super.getDefaultProperty(propertyName);
    }

    public boolean isPropertyEnabled(String propertyName) {
        return true;
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean set = super.propertySet(propertyName, propertyValue);
        IDataModel dm = this.getDataModel();
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            IVirtualComponent component;
            if (this.getComponentMap().isEmpty()) {
                this.intializeComponentMap();
            }
            if ((component = this.getComponentMap().get(propertyValue)) != null && component.getName().equals(propertyValue)) {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", component);
            } else {
                this.setProperty("IJ2EEComponentExportDataModelProperties.COMPONENT", null);
            }
            dm.notifyPropertyChange("IJ2EEComponentExportDataModelProperties.RUNTIME", 4);
            if (component != null) {
                try {
                    ProjectFacetsManager.create((IProject)component.getProject());
                }
                catch (CoreException e) {
                    WTPOveridePlugin.logError(e);
                }
            }
        }
        return set;
    }

    public HashMap<String, IVirtualComponent> getComponentMap() {
        if (this.componentMap == null) {
            this.componentMap = new HashMap();
        }
        return this.componentMap;
    }

    public void intializeComponentMap() {
        IVirtualComponent[] comps = ComponentUtilities.getAllWorkbenchComponents();
        int i = 0;
        while (i < comps.length) {
            this.getComponentMap().put(comps[i].getName(), comps[i]);
            ++i;
        }
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("IJ2EEComponentExportDataModelProperties.PROJECT_NAME")) {
            ArrayList<String> componentNames = new ArrayList<String>();
            IVirtualComponent[] wbComps = ComponentUtilities.getAllWorkbenchComponents();
            ArrayList<IVirtualComponent> relevantComponents = new ArrayList<IVirtualComponent>();
            int i = 0;
            while (i < wbComps.length) {
                relevantComponents.add(wbComps[i]);
                this.getComponentMap().put(wbComps[i].getName(), wbComps[i]);
                ++i;
            }
            if (relevantComponents == null || relevantComponents.size() == 0) {
                return null;
            }
            int j = 0;
            while (j < relevantComponents.size()) {
                componentNames.add(((IVirtualComponent)relevantComponents.get(j)).getName());
                ++j;
            }
            Object[] names = componentNames.toArray(new String[componentNames.size()]);
            return DataModelPropertyDescriptor.createDescriptors((Object[])names);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public IStatus validate(String propertyName) {
        String location;
        if ("IJ2EEComponentExportDataModelProperties.PROJECT_NAME".equals(propertyName)) {
            String projectName = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
            if (projectName == null || projectName.equals("")) {
                return WTPOveridePlugin.createErrorStatus(Messages.MODULE_EXISTS_ERROR);
            }
            IVirtualComponent component = this.componentMap.get(projectName);
            if (component == null) {
                return WTPOveridePlugin.createErrorStatus(Messages.MODULE_EXISTS_ERROR);
            }
        }
        if ("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName)) {
            String assumedExtension;
            String archiveLocation = (String)this.model.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION");
            if (!this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") || archiveLocation.equals("")) {
                return WTPOveridePlugin.createErrorStatus(Messages.DESTINATION_INVALID);
            }
            if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION")) {
                IStatus tempStatus = this.validateLocation(archiveLocation);
                if (tempStatus != OK_STATUS) {
                    return tempStatus;
                }
            } else if (this.model.isPropertySet("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION") && !this.validateModuleType(archiveLocation) && (assumedExtension = VCFUtil.getModuleFacetExtension((IProject)this.getProject())) != null) {
                return WTPOveridePlugin.createWarningStatus(NLS.bind((String)Messages.DESTINATION_ARCHIVE_SHOULD_END_WITH, (Object)assumedExtension));
            }
        }
        if (("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION".equals(propertyName) || "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING".equals(propertyName)) && this.checkForExistingFileResource(location = (String)this.getProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION"))) {
            return WTPOveridePlugin.createErrorStatus(NLS.bind((String)Messages.RESOURCE_EXISTS_ERROR, (Object)location));
        }
        return OK_STATUS;
    }

    private IStatus validateLocation(String archiveLocation) {
        Path path = null;
        try {
            path = new Path(archiveLocation);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return WTPOveridePlugin.createErrorStatus(Messages.DESTINATION_INVALID);
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(path.lastSegment(), 1);
        if (!status.isOK()) {
            return status;
        }
        String device = path.getDevice();
        if (device == null) {
            return OK_STATUS;
        }
        if (path == null || device.length() == 1 && device.charAt(0) == ':') {
            return WTPOveridePlugin.createErrorStatus(Messages.DESTINATION_INVALID);
        }
        if (!path.toFile().canWrite()) {
            if (path.toFile().exists()) {
                return WTPOveridePlugin.createErrorStatus(Messages.IS_READ_ONLY);
            }
            boolean OK = false;
            path = path.removeLastSegments(1);
            int i = 1;
            while (!OK && i < 20 && path.segmentCount() > 0) {
                if (path.toFile().exists()) {
                    OK = true;
                }
                if (!(status = workspace.validateName(path.lastSegment(), 2)).isOK()) {
                    return WTPOveridePlugin.createErrorStatus(Messages.DESTINATION_INVALID);
                }
                path = path.removeLastSegments(1);
                ++i;
            }
        }
        return OK_STATUS;
    }

    private boolean checkForExistingFileResource(String fileName) {
        File externalFile;
        return !this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING") && (externalFile = new File(fileName)) != null && externalFile.exists();
    }

    private boolean validateModuleType(String archive) {
        String assumedExtension = VCFUtil.getModuleFacetExtension((IProject)this.getProject());
        if (archive.length() < 4) {
            return false;
        }
        String lastFour = archive.substring(archive.length() - 4, archive.length());
        return lastFour.equalsIgnoreCase(assumedExtension);
    }

    private IProject getProject() {
        IVirtualComponent component = (IVirtualComponent)this.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        return component == null ? null : component.getProject();
    }
}

