/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;

public class ServerWorkingCopyPropertyComboCommand
extends ServerCommand {
    public static int POST_EXECUTE = 1;
    public static int POST_UNDO = 2;
    public static int POST_REDO = 3;
    protected String oldVal;
    protected String newVal;
    protected String key;
    protected Combo combo;
    protected ModifyListener listener;
    protected IServerWorkingCopy wc;

    public ServerWorkingCopyPropertyComboCommand(IServerWorkingCopy wc, String commandName, Combo combo, String newVal, String attributeKey, ModifyListener listener) {
        super(wc, commandName);
        this.wc = wc;
        this.combo = combo;
        this.key = attributeKey;
        this.newVal = newVal;
        this.listener = listener;
        if (this.key != null) {
            this.oldVal = wc.getAttribute(attributeKey, "");
        }
    }

    public void execute() {
        this.wc.setAttribute(this.key, this.newVal);
        this.postOp(POST_EXECUTE);
    }

    public void undo() {
        if (this.listener != null) {
            this.combo.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.oldVal);
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setText(this.oldVal);
        }
        if (this.listener != null) {
            this.combo.addModifyListener(this.listener);
        }
        this.postOp(POST_UNDO);
    }

    public IStatus redo() {
        if (this.listener != null) {
            this.combo.removeModifyListener(this.listener);
        }
        this.wc.setAttribute(this.key, this.newVal);
        if (this.combo != null && !this.combo.isDisposed()) {
            this.combo.setText(this.newVal);
        }
        if (this.listener != null) {
            this.combo.addModifyListener(this.listener);
        }
        this.postOp(POST_REDO);
        return Status.OK_STATUS;
    }

    protected void postOp(int type) {
    }
}

