/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.preferences.CDIPreferences;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidationDelegate;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationMessages;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BeansXmlValidationDelegate
extends CDICoreValidationDelegate {
    private AlternativeClassValidator alternativeClassValidator;
    private AlternativeStereotypeValidator alternativeStereotypeValidator;
    private DecoratorTypeValidator decoratorTypeValidator;
    private InterceptorTypeValidator interceptorTypeValidator;
    private Map<IProject, IJavaProject> javaProjects;

    public BeansXmlValidationDelegate(CDICoreValidator validator) {
        super(validator);
    }

    private AlternativeClassValidator getAlternativeClassValidator() {
        if (this.alternativeClassValidator == null) {
            this.alternativeClassValidator = new AlternativeClassValidator();
        }
        return this.alternativeClassValidator;
    }

    private AlternativeStereotypeValidator getAlternativeStereotypeValidator() {
        if (this.alternativeStereotypeValidator == null) {
            this.alternativeStereotypeValidator = new AlternativeStereotypeValidator();
        }
        return this.alternativeStereotypeValidator;
    }

    private DecoratorTypeValidator getDecoratorTypeValidator() {
        if (this.decoratorTypeValidator == null) {
            this.decoratorTypeValidator = new DecoratorTypeValidator();
        }
        return this.decoratorTypeValidator;
    }

    private InterceptorTypeValidator getInterceptorTypeValidator() {
        if (this.interceptorTypeValidator == null) {
            this.interceptorTypeValidator = new InterceptorTypeValidator();
        }
        return this.interceptorTypeValidator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateBeansXml(CDICoreValidator.CDIValidationContext context, IFile beansXml) {
        XModelObject f = EclipseResourceUtil.createObjectForResource((IResource)beansXml);
        String xmodelpath = f == null ? "" : f.getPath();
        IModelManager manager = StructuredModelManager.getModelManager();
        if (manager == null) {
            return;
        }
        IStructuredModel model = null;
        try {
            try {
                model = manager.getModelForRead(beansXml);
                if (!(model instanceof IDOMModel)) return;
                IDOMModel domModel = (IDOMModel)model;
                IDOMDocument document = domModel.getDocument();
                this.validateTypeBeanForBeansXml(context, this.getAlternativeClassValidator(), document, beansXml, String.valueOf(xmodelpath) + "/" + "Alternatives");
                this.validateTypeBeanForBeansXml(context, this.getAlternativeStereotypeValidator(), document, beansXml, String.valueOf(xmodelpath) + "/" + "Alternatives");
                this.validateTypeBeanForBeansXml(context, this.getDecoratorTypeValidator(), document, beansXml, String.valueOf(xmodelpath) + "/" + "Decorators");
                this.validateTypeBeanForBeansXml(context, this.getInterceptorTypeValidator(), document, beansXml, String.valueOf(xmodelpath) + "/" + "Interceptors");
                return;
            }
            catch (CoreException e) {
                CDICorePlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (IOException e) {
                CDICorePlugin.getDefault().logError(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    private void validateTypeBeanForBeansXml(CDICoreValidator.CDIValidationContext context, TypeValidator typeValidator, IDOMDocument document, IFile beansXml, String xmodelpath) {
        try {
            NodeList parentNodeList = document.getElementsByTagName(typeValidator.getParrentElementname());
            int i = 0;
            while (i < parentNodeList.getLength()) {
                Node parentNode = parentNodeList.item(i);
                if (parentNode instanceof Element) {
                    List<TypeNode> typeNodes = this.getTypeElements((Element)parentNode, typeValidator.getTypeElementName());
                    HashMap<String, TypeNode> uniqueTypes = new HashMap<String, TypeNode>();
                    for (TypeNode typeNode : typeNodes) {
                        TypeNode node;
                        String typeError;
                        IType type;
                        String typepath = xmodelpath;
                        String attr = null;
                        if (typeNode.getTypeName() != null) {
                            typepath = String.valueOf(typepath) + "/" + typeNode.getTypeName();
                            attr = typeValidator.getTypeElementName();
                        }
                        if ((type = this.getType(beansXml, typeNode, typeValidator, typepath, attr)) == null) continue;
                        if (!this.validator.isAsYouTypeValidation() && !type.isBinary()) {
                            this.validator.getValidationContext().addLinkedCoreResource("jboss.cdi.core", beansXml.getFullPath().toOSString(), type.getPath(), false);
                            HashSet<IPath> relatedResources = new HashSet<IPath>();
                            IResource resource = type.getResource();
                            if (resource instanceof IFile) {
                                this.validator.collectAllRelatedInjectionsForBean((IFile)resource, relatedResources);
                                for (IPath path : relatedResources) {
                                    this.validator.getValidationContext().addLinkedCoreResource("jboss.cdi.core", path.toOSString(), beansXml.getFullPath(), false);
                                }
                            }
                        }
                        if ((typeError = typeValidator.validateType(context, type)) != null) {
                            IMarker marker = this.validator.addProblem(typeValidator.getIllegalTypeErrorMessage(), CDIPreferences.ILLEGAL_TYPE_NAME_IN_BEANS_XML, new String[]{typeNode.getTypeName()}, typeNode.getLength(), typeNode.getStartOffset(), (IResource)beansXml, typeValidator.getIllegalTypeErrorMessageId());
                            if (marker != null) {
                                this.bindMarkerToModel(marker, typepath, typeValidator.getTypeElementName());
                            }
                            if (type.isBinary()) continue;
                        }
                        if ((node = (TypeNode)uniqueTypes.get(typeNode.getTypeName())) != null) {
                            IMarker marker;
                            if (!node.isMarkedAsDuplicated() && (marker = this.validator.addProblem(typeValidator.getDuplicateTypeErrorMessage(), CDIPreferences.DUPLICATE_TYPE_IN_BEANS_XML, new String[0], node.getLength(), node.getStartOffset(), (IResource)beansXml)) != null) {
                                this.bindMarkerToModel(marker, typepath, typeValidator.getTypeElementName());
                            }
                            node.setMarkedAsDuplicated(true);
                            typeNode.setMarkedAsDuplicated(true);
                            typeNode.setDuplicationIndex(node.getDuplicationIndex() + 1);
                            marker = this.validator.addProblem(typeValidator.getDuplicateTypeErrorMessage(), CDIPreferences.DUPLICATE_TYPE_IN_BEANS_XML, new String[0], typeNode.getLength(), typeNode.getStartOffset(), (IResource)beansXml);
                            if (marker != null) {
                                int di = typeNode.getDuplicationIndex();
                                if (di > 0) {
                                    typepath = String.valueOf(typepath) + "__duplicate" + di;
                                }
                                this.bindMarkerToModel(marker, typepath, typeValidator.getTypeElementName());
                            }
                        }
                        uniqueTypes.put(typeNode.getTypeName(), typeNode);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    public IJavaProject getJavaProject(IResource resource) {
        IProject project;
        if (this.javaProjects == null) {
            this.javaProjects = new HashMap<IProject, IJavaProject>();
        }
        if ((project = resource.getProject()).isAccessible()) {
            IJavaProject javaProject = this.javaProjects.get(project);
            if (javaProject == null && (javaProject = EclipseUtil.getJavaProject((IProject)project)) != null) {
                this.javaProjects.put(project, javaProject);
            }
            return javaProject;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private IType getType(IFile beansXml, TypeNode node, TypeValidator typeValidator, String xmodelpath, String attr) {
        type = null;
        typeName = node.getTypeName();
        if (typeName != null && typeName.trim().length() > 0) {
            try {
                javaProject = this.getJavaProject((IResource)beansXml);
                if (javaProject == null) ** GOTO lbl15
                type = EclipseJavaUtil.findType((IJavaProject)javaProject, (String)typeName);
            }
            catch (JavaModelException e) {
                CDICorePlugin.getDefault().logError(e);
                return null;
            }
        } else {
            marker = this.validator.addProblem(typeValidator.getEmptyTypeErrorMessage(), CDIPreferences.ILLEGAL_TYPE_NAME_IN_BEANS_XML, new String[]{node.getTypeName()}, node.getLength(), node.getStartOffset(), (IResource)beansXml, typeValidator.getUnknownTypeErrorMessageId());
            this.bindMarkerToModel(marker, xmodelpath, attr);
            return null;
        }
lbl15:
        // 2 sources

        if (type == null) {
            this.addLinkedResourcesForUnknownType(beansXml, node.getTypeName());
            marker = this.validator.addProblem(typeValidator.getUnknownTypeErrorMessage(), CDIPreferences.ILLEGAL_TYPE_NAME_IN_BEANS_XML, new String[]{node.getTypeName()}, node.getLength(), node.getStartOffset(), (IResource)beansXml, typeValidator.getUnknownTypeErrorMessageId());
            this.bindMarkerToModel(marker, xmodelpath, attr);
        }
        return type;
    }

    private void bindMarkerToModel(IMarker marker, String path, String attribute) {
        try {
            if (marker != null) {
                marker.setAttribute("path", (Object)path);
                if (attribute != null) {
                    marker.setAttribute("attribute", (Object)attribute);
                }
            }
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    private void addLinkedResourcesForUnknownType(IFile beansXml, String typeName) {
        IStatus status;
        if (!this.validator.isAsYouTypeValidation() && typeName != null && typeName.trim().length() > 0 && (status = JavaConventions.validateJavaTypeName((String)typeName, (String)"1.7", (String)"1.7")).getSeverity() != 4) {
            String packagePath = typeName.replace('.', '/');
            Set sources = EclipseResourceUtil.getSourceFolders((IProject)beansXml.getProject());
            for (IFolder source : sources) {
                IPath path = source.getFullPath().append(String.valueOf(packagePath) + ".java");
                this.validator.getValidationContext().addLinkedCoreResource("jboss.cdi.core", beansXml.getFullPath().toOSString(), path, false);
            }
        }
    }

    private List<TypeNode> getTypeElements(Element parentElement, String typeElementName) {
        ArrayList<TypeNode> result = new ArrayList<TypeNode>();
        NodeList list = parentElement.getElementsByTagName(typeElementName);
        int i = 0;
        while (i < list.getLength()) {
            Node classNode = list.item(i);
            NodeList children = classNode.getChildNodes();
            boolean empty = true;
            int j = 0;
            while (j < children.getLength()) {
                String className;
                String value;
                Node node = children.item(j);
                if (node.getNodeType() == 3 && (value = node.getNodeValue()) != null && (className = value.trim()).length() != 0) {
                    empty = false;
                    if (node instanceof IndexedRegion) {
                        int start = ((IndexedRegion)node).getStartOffset() + value.indexOf(className);
                        int length = className.length();
                        result.add(new TypeNode(start, length, className));
                        break;
                    }
                }
                ++j;
            }
            if (empty && classNode instanceof IndexedRegion) {
                int start = ((IndexedRegion)classNode).getStartOffset();
                int end = ((IndexedRegion)classNode).getEndOffset();
                int length = end - start;
                result.add(new TypeNode(start, length, null));
            }
            ++i;
        }
        return result;
    }

    private abstract class AbstractTypeValidator
    implements TypeValidator {
        private AbstractTypeValidator() {
        }

        @Override
        public String getTypeElementName() {
            return "class";
        }

        @Override
        public String validateType(CDICoreValidator.CDIValidationContext context, IType type) throws JavaModelException {
            if (!this.validateKindOfType(type)) {
                return this.getIllegalTypeErrorMessage();
            }
            if (type.isBinary() ? !this.validateBinaryType(type) : !this.validateSourceType(context, type)) {
                return this.getIllegalTypeErrorMessage();
            }
            return null;
        }

        public abstract boolean validateSourceType(CDICoreValidator.CDIValidationContext var1, IType var2);

        public boolean validateKindOfType(IType type) throws JavaModelException {
            return type.isClass();
        }

        public boolean validateBinaryType(IType type) throws JavaModelException {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = type.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                if (annotation.getElementName().equals(this.getAnnotationName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        protected abstract String getAnnotationName();
    }

    private class AlternativeClassValidator
    extends AbstractTypeValidator {
        private AlternativeClassValidator() {
        }

        @Override
        public boolean validateSourceType(CDICoreValidator.CDIValidationContext context, IType type) {
            IClassBean classBean = context.getCdiProject().getBeanClass(type);
            return classBean != null && classBean.isAlternative();
        }

        @Override
        public String getParrentElementname() {
            return "alternatives";
        }

        @Override
        public String getEmptyTypeErrorMessage() {
            return CDIValidationMessages.EMPTY_ALTERNATIVE_BEAN_CLASS_NAME;
        }

        @Override
        public String getUnknownTypeErrorMessage() {
            return CDIValidationMessages.UNKNOWN_ALTERNATIVE_BEAN_CLASS_NAME;
        }

        @Override
        public int getUnknownTypeErrorMessageId() {
            return 43;
        }

        @Override
        public String getIllegalTypeErrorMessage() {
            return CDIValidationMessages.ILLEGAL_ALTERNATIVE_BEAN_CLASS;
        }

        @Override
        public int getIllegalTypeErrorMessageId() {
            return 45;
        }

        @Override
        public String getDuplicateTypeErrorMessage() {
            return CDIValidationMessages.DUPLICATE_ALTERNATIVE_TYPE;
        }

        @Override
        protected String getAnnotationName() {
            return "javax.enterprise.inject.Alternative";
        }
    }

    private class AlternativeStereotypeValidator
    extends AbstractTypeValidator {
        private AlternativeStereotypeValidator() {
        }

        @Override
        public boolean validateSourceType(CDICoreValidator.CDIValidationContext context, IType type) {
            IStereotype stereotype = context.getCdiProject().getStereotype(type);
            return stereotype != null && stereotype.isAlternative();
        }

        @Override
        public boolean validateKindOfType(IType type) throws JavaModelException {
            return type.isAnnotation();
        }

        @Override
        public String getTypeElementName() {
            return "stereotype";
        }

        @Override
        public String getParrentElementname() {
            return "alternatives";
        }

        @Override
        public String getEmptyTypeErrorMessage() {
            return CDIValidationMessages.EMPTY_ALTERNATIVE_ANNOTATION_NAME;
        }

        @Override
        public String getUnknownTypeErrorMessage() {
            return CDIValidationMessages.UNKNOWN_ALTERNATIVE_ANNOTATION_NAME;
        }

        @Override
        public int getUnknownTypeErrorMessageId() {
            return 44;
        }

        @Override
        public String getIllegalTypeErrorMessage() {
            return CDIValidationMessages.ILLEGAL_ALTERNATIVE_ANNOTATION;
        }

        @Override
        public int getIllegalTypeErrorMessageId() {
            return 46;
        }

        @Override
        public String getDuplicateTypeErrorMessage() {
            return CDIValidationMessages.DUPLICATE_ALTERNATIVE_TYPE;
        }

        @Override
        protected String getAnnotationName() {
            return "javax.enterprise.inject.Alternative";
        }
    }

    private class DecoratorTypeValidator
    extends AbstractTypeValidator {
        private DecoratorTypeValidator() {
        }

        @Override
        public boolean validateSourceType(CDICoreValidator.CDIValidationContext context, IType type) {
            IClassBean classBean = context.getCdiProject().getBeanClass(type);
            return classBean instanceof IDecorator;
        }

        @Override
        public String getParrentElementname() {
            return "decorators";
        }

        @Override
        public String getEmptyTypeErrorMessage() {
            return CDIValidationMessages.EMPTY_DECORATOR_BEAN_CLASS_NAME;
        }

        @Override
        public String getUnknownTypeErrorMessage() {
            return CDIValidationMessages.UNKNOWN_DECORATOR_BEAN_CLASS_NAME;
        }

        @Override
        public int getUnknownTypeErrorMessageId() {
            return 47;
        }

        @Override
        public String getIllegalTypeErrorMessage() {
            return CDIValidationMessages.ILLEGAL_DECORATOR_BEAN_CLASS;
        }

        @Override
        public int getIllegalTypeErrorMessageId() {
            return 49;
        }

        @Override
        public String getDuplicateTypeErrorMessage() {
            return CDIValidationMessages.DUPLICATE_DECORATOR_CLASS;
        }

        @Override
        protected String getAnnotationName() {
            return "javax.decorator.Decorator";
        }
    }

    private class InterceptorTypeValidator
    extends AbstractTypeValidator {
        private InterceptorTypeValidator() {
        }

        @Override
        public boolean validateSourceType(CDICoreValidator.CDIValidationContext context, IType type) {
            IClassBean classBean = context.getCdiProject().getBeanClass(type);
            return classBean instanceof IInterceptor;
        }

        @Override
        public String getParrentElementname() {
            return "interceptors";
        }

        @Override
        public String getEmptyTypeErrorMessage() {
            return CDIValidationMessages.EMPTY_INTERCEPTOR_CLASS_NAME;
        }

        @Override
        public String getUnknownTypeErrorMessage() {
            return CDIValidationMessages.UNKNOWN_INTERCEPTOR_CLASS_NAME;
        }

        @Override
        public int getUnknownTypeErrorMessageId() {
            return 48;
        }

        @Override
        public String getIllegalTypeErrorMessage() {
            return CDIValidationMessages.ILLEGAL_INTERCEPTOR_CLASS;
        }

        @Override
        public int getIllegalTypeErrorMessageId() {
            return 50;
        }

        @Override
        public String getDuplicateTypeErrorMessage() {
            return CDIValidationMessages.DUPLICATE_INTERCEPTOR_CLASS;
        }

        @Override
        protected String getAnnotationName() {
            return "javax.interceptor.Interceptor";
        }
    }

    private static class TypeNode {
        private int startOffset;
        private int length;
        private String typeName;
        private boolean markedAsDuplicated;
        private int duplicationIndex = 0;

        public TypeNode(int startOffset, int length, String typeName) {
            this.startOffset = startOffset;
            this.length = length;
            this.typeName = typeName;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public boolean isMarkedAsDuplicated() {
            return this.markedAsDuplicated;
        }

        public void setMarkedAsDuplicated(boolean markedAsDuplicated) {
            this.markedAsDuplicated = markedAsDuplicated;
        }

        public int getDuplicationIndex() {
            return this.duplicationIndex;
        }

        public void setDuplicationIndex(int i) {
            this.duplicationIndex = i;
        }
    }

    private static interface TypeValidator {
        public String validateType(CDICoreValidator.CDIValidationContext var1, IType var2) throws JavaModelException;

        public String getTypeElementName();

        public String getParrentElementname();

        public String getEmptyTypeErrorMessage();

        public String getUnknownTypeErrorMessage();

        public int getUnknownTypeErrorMessageId();

        public String getIllegalTypeErrorMessage();

        public int getIllegalTypeErrorMessageId();

        public String getDuplicateTypeErrorMessage();
    }
}

