/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.validation;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.ICDIAnnotation;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IInterceptorBindingDeclaration;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.core.preferences.CDIPreferences;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidationDelegate;
import org.jboss.tools.cdi.internal.core.validation.CDICoreValidator;
import org.jboss.tools.cdi.internal.core.validation.CDIValidationMessages;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IAnnotationType;
import org.jboss.tools.common.text.ITextSourceReference;

public class AnnotationValidationDelegate
extends CDICoreValidationDelegate {
    public static final String ELEMENT_TYPE_TYPE_NAME = "java.lang.annotation.ElementType";
    public static final String TARGET_METHOD = "METHOD";
    public static final String TARGET_FIELD = "FIELD";
    public static final String TARGET_PARAMETER = "PARAMETER";
    public static final String TARGET_TYPE = "TYPE";
    static final String[] TMF = new String[]{"METHOD", "FIELD", "TYPE"};
    static final String[] MF = new String[]{"METHOD", "FIELD"};
    static final String[][] STEREOTYPE_GENERAL_TARGET_VARAINTS = new String[][]{TMF, MF, {"TYPE"}, {"METHOD"}, {"FIELD"}};
    static final String[][] QUALIFIER_GENERAL_TARGET_VARIANTS = new String[][]{{"METHOD", "FIELD", "PARAMETER", "TYPE"}, {"FIELD", "PARAMETER"}};
    static final String[][] SCOPE_GENERAL_TARGET_VARIANTS = new String[][]{TMF};
    static final String[][] STEREOTYPE_TMF_VARIANTS = new String[][]{TMF};
    static final String[][] STEREOTYPE_MF_VARIANTS = new String[][]{MF};
    static final String[][] STEREOTYPE_M_VARIANTS = new String[][]{{"METHOD"}};
    static final String[][] STEREOTYPE_F_VARIANTS = new String[][]{{"FIELD"}};
    static final String[][] TYPE_VARIANTS = new String[][]{{"TYPE"}};
    static final String[][] TYPE__METHOD_VARIANTS = new String[][]{{"TYPE", "METHOD"}};

    public AnnotationValidationDelegate(CDICoreValidator validator) {
        super(validator);
    }

    public void validateStereotypeAnnotationTypeAnnotations(IStereotype stereotype, IResource resource) throws JavaModelException {
        this.validateTargetAnnotation(stereotype, STEREOTYPE_GENERAL_TARGET_VARAINTS, CDIValidationMessages.MISSING_TARGET_ANNOTATION_IN_STEREOTYPE_TYPE, resource, 15);
        this.validateRetentionAnnotation(stereotype, CDIValidationMessages.MISSING_RETENTION_ANNOTATION_IN_STEREOTYPE_TYPE, resource, 12);
        IAnnotationDeclaration target = stereotype.getAnnotationDeclaration("java.lang.annotation.Target");
        if (target != null) {
            for (IStereotypeDeclaration stereotypeDeclaration : stereotype.getStereotypeDeclarations()) {
                Boolean result;
                IStereotype superStereotype = stereotypeDeclaration.getStereotype();
                if (superStereotype == null || (result = CDIUtil.checkTargetAnnotation(superStereotype, TYPE_VARIANTS)) == null || !result.booleanValue()) continue;
                result = CDIUtil.checkTargetAnnotation(target, STEREOTYPE_TMF_VARIANTS);
                String stName = stereotype.getSourceType().getElementName();
                String superStName = superStereotype.getSourceType().getElementName();
                if (result.booleanValue()) {
                    this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_STEREOTYPE_TYPE_TMF, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{superStName, stName}, (ITextSourceReference)stereotypeDeclaration, resource);
                    continue;
                }
                result = CDIUtil.checkTargetAnnotation(target, STEREOTYPE_M_VARIANTS);
                if (result.booleanValue()) {
                    this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_STEREOTYPE_TYPE_M, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{superStName, stName}, (ITextSourceReference)stereotypeDeclaration, resource);
                    continue;
                }
                result = CDIUtil.checkTargetAnnotation(target, STEREOTYPE_F_VARIANTS);
                if (result.booleanValue()) {
                    this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_STEREOTYPE_TYPE_F, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{superStName, stName}, (ITextSourceReference)stereotypeDeclaration, resource);
                    continue;
                }
                result = CDIUtil.checkTargetAnnotation(target, STEREOTYPE_MF_VARIANTS);
                if (!result.booleanValue()) continue;
                this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_STEREOTYPE_TYPE_MF, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{superStName, stName}, (ITextSourceReference)stereotypeDeclaration, resource);
            }
            Collection interceptorBindingDeclarations = stereotype.getInterceptorBindingDeclarations(false);
            if (!interceptorBindingDeclarations.isEmpty() && !CDIUtil.checkTargetAnnotation(target, TYPE_VARIANTS)) {
                StringBuffer bindings = new StringBuffer();
                boolean first = true;
                for (IInterceptorBindingDeclaration binding : interceptorBindingDeclarations) {
                    if (!first) {
                        bindings.append(", ");
                    }
                    bindings.append(binding.getType().getElementName());
                    first = false;
                }
                String stName = stereotype.getSourceType().getElementName();
                this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_INTERCEPTOR_BINDING_TYPE_FOR_STEREOTYPE, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{stName, bindings.toString()}, (ITextSourceReference)target, resource);
            }
        }
    }

    public void validateInterceptorBindingAnnotationTypeAnnotations(IInterceptorBinding binding) throws JavaModelException {
        IAnnotationDeclaration target;
        Collection declarations = binding.getInterceptorBindingDeclarations(false);
        if (!declarations.isEmpty() && (target = binding.getAnnotationDeclaration("java.lang.annotation.Target")) != null && CDIUtil.checkTargetAnnotation(target, TYPE__METHOD_VARIANTS)) {
            for (IInterceptorBindingDeclaration declaration : declarations) {
                IAnnotationType superBinding = declaration.getAnnotation();
                Boolean result = CDIUtil.checkTargetAnnotation(superBinding, TYPE_VARIANTS);
                if (result == null || !result.booleanValue()) continue;
                this.validator.addProblem(CDIValidationMessages.ILLEGAL_TARGET_IN_INTERCEPTOR_BINDING_TYPE, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, new String[]{superBinding.getSourceType().getElementName(), binding.getSourceType().getElementName()}, (ITextSourceReference)declaration, binding.getResource());
            }
        }
    }

    public void validateScopeType(IScope scope) {
        if (scope == null) {
            return;
        }
        IResource resource = scope.getResource();
        if (!this.validator.shouldValidateResourceOfElement(resource)) {
            return;
        }
        try {
            this.validateScopeAnnotationTypeAnnotations(scope, resource);
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    private void validateScopeAnnotationTypeAnnotations(IScope scope, IResource resource) throws JavaModelException {
        this.validateTargetAnnotation(scope, SCOPE_GENERAL_TARGET_VARIANTS, CDIValidationMessages.MISSING_TARGET_ANNOTATION_IN_SCOPE_TYPE, resource, 16);
        this.validateRetentionAnnotation(scope, CDIValidationMessages.MISSING_RETENTION_ANNOTATION_IN_SCOPE_TYPE, resource, 13);
    }

    void validateRetentionAnnotation(ICDIAnnotation type, String message, IResource resource, int message_id) throws JavaModelException {
        IAnnotationDeclaration retention = type.getAnnotationDeclaration("java.lang.annotation.Retention");
        if (retention == null) {
            this.validator.addProblem(message, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, CDIUtil.convertToSourceReference(type.getSourceType().getNameRange(), resource, (IMember)type.getSourceType()), resource, message_id);
        } else {
            Object o = retention.getMemberValue(null);
            if (o == null || !"java.lang.annotation.RetentionPolicy.RUNTIME".equals(o.toString())) {
                this.validator.addProblem(message, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, (ITextSourceReference)retention, resource, message_id);
            }
        }
    }

    public void validateQualifierAnnotationTypeAnnotations(IQualifier qualifier, IResource resource) throws JavaModelException {
        this.validateTargetAnnotation(qualifier, QUALIFIER_GENERAL_TARGET_VARIANTS, CDIValidationMessages.MISSING_TARGET_ANNOTATION_IN_QUALIFIER_TYPE, resource, 14);
        this.validateRetentionAnnotation(qualifier, CDIValidationMessages.MISSING_RETENTION_ANNOTATION_IN_QUALIFIER_TYPE, resource, 11);
    }

    private void validateTargetAnnotation(ICDIAnnotation annotationType, String[][] variants, String message, IResource resource, int message_id) throws JavaModelException {
        IAnnotationDeclaration target = annotationType.getAnnotationDeclaration("java.lang.annotation.Target");
        if (target == null) {
            this.validator.addProblem(message, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, CDIUtil.convertToSourceReference(annotationType.getSourceType().getNameRange(), resource, (IMember)annotationType.getSourceType()), resource, message_id);
        } else if (!CDIUtil.checkTargetAnnotation(target, variants)) {
            this.validator.addProblem(message, CDIPreferences.MISSING_OR_INCORRECT_TARGET_OR_RETENTION_IN_ANNOTATION_TYPE, (ITextSourceReference)target, resource, message_id);
        }
    }
}

