/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.scanner;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreBuilder;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.ICDIBuilderDelegate;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.internal.core.impl.CDIProject;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeansXMLDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.PackageDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.common.model.XModelObject;

public class CDIBuilderDelegate
implements ICDIBuilderDelegate {
    @Override
    public int computeRelevance(IProject project) {
        return 1;
    }

    @Override
    public String getID() {
        return this.getClass().getName();
    }

    @Override
    public Class<? extends ICDIProject> getProjectImplementationClass() {
        return CDIProject.class;
    }

    @Override
    public void build(FileSet fileSet, CDICoreNature projectNature) {
        DefinitionContext context = projectNature.getDefinitions().getWorkingCopy();
        this.build(fileSet, context);
    }

    public void build(FileSet fileSet, DefinitionContext context) {
        Object def;
        Set<IPath> ps = fileSet.getAllPaths();
        for (IPath p : ps) {
            context.clean(p);
        }
        Map<IPath, List<IType>> as = fileSet.getAnnotations();
        for (IPath f : as.keySet()) {
            for (IType type : as.get(f)) {
                context.getAnnotationKind(type);
            }
        }
        Map<IPath, List<IType>> is = fileSet.getInterfaces();
        for (IPath f : is.keySet()) {
            for (IType type : is.get(f)) {
                if (!type.getElementName().equals("package-info")) continue;
                PackageDefinition def2 = new PackageDefinition();
                def2.setBinaryType(type, context);
                context.addPackage(f, def2.getQualifiedName(), def2);
            }
        }
        Map<IPath, List<IType>> cs = fileSet.getClasses();
        for (IPath f : cs.keySet()) {
            for (IType type : cs.get(f)) {
                def = new TypeDefinition();
                ((AbstractTypeDefinition)def).setType(type, context, 0);
                context.addType(f, type.getFullyQualifiedName(), (AbstractTypeDefinition)def);
            }
        }
        Map<IPath, IPackageDeclaration> pkgs = fileSet.getPackages();
        for (IPath f : pkgs.keySet()) {
            IPackageDeclaration pkg = pkgs.get(f);
            def = new PackageDefinition();
            ((PackageDefinition)def).setPackage(pkg, context);
            context.addPackage(f, ((PackageDefinition)def).getQualifiedName(), (PackageDefinition)def);
            IResource res = pkg.getResource();
            if (!CDICoreBuilder.isPackageInfo(res)) continue;
            IResource[] ms = new IResource[]{};
            try {
                ms = res.getParent().members();
            }
            catch (CoreException e) {
                CDICorePlugin.getDefault().logError(e);
            }
            IResource[] iResourceArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (n2 < n) {
                IResource m = iResourceArray[n2];
                if (m instanceof IFile && !m.getName().equals("package-info.java")) {
                    context.addDependency(f, m.getFullPath());
                }
                ++n2;
            }
        }
        for (IPath f : ps) {
            XModelObject beansXML = fileSet.getBeanXML(f);
            if (beansXML == null) continue;
            def = new BeansXMLDefinition();
            ((BeansXMLDefinition)def).setPath(f);
            ((BeansXMLDefinition)def).setBeansXML(beansXML);
            context.addBeanXML(f, (BeansXMLDefinition)def);
        }
    }
}

