/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.internal.core.refactoring.AbstractCDIProcessor;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.refactoring.FileChangeFactory;
import org.jboss.tools.jst.web.kb.refactoring.RefactorSearcher;

public abstract class CDIRenameProcessor
extends AbstractCDIProcessor {
    protected TextFileChange lastChange;
    protected IFile declarationFile = null;
    private String newName;
    private String oldName;
    private CDISearcher searcher = null;
    protected IBean bean;
    Set<String> keys = new HashSet<String>();

    public CDIRenameProcessor(String label, IBean bean) {
        super(label);
        this.bean = bean;
        this.setOldName(bean.getName());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.bean == null) {
            result.addFatalError(CDICoreMessages.RENAME_NAMED_BEAN_PROCESSOR_ERROR);
        }
        return result;
    }

    protected CDISearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new CDISearcher(this.declarationFile, this.getOldName());
        }
        return this.searcher;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    protected String getNewName() {
        return this.newName;
    }

    protected void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = FileChangeFactory.getFileChange((IFile)file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    protected void clearChanges() {
        this.keys.clear();
    }

    protected void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    @Override
    public boolean isApplicable() throws CoreException {
        return this.bean != null;
    }

    public Object[] getElements() {
        return new IBean[]{this.bean};
    }

    class CDISearcher
    extends RefactorSearcher {
        public CDISearcher(IFile declarationFile, String oldName) {
            super(declarationFile, oldName, CDIUtil.getJavaElement(CDIRenameProcessor.this.bean));
        }

        protected void outOfSynch(IResource resource) {
            CDIRenameProcessor.this.status.addWarning(NLS.bind((String)CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_OUT_OF_SYNC_PROJECT, (Object)resource.getFullPath().toString()));
        }

        protected void match(IFile file, int offset, int length) {
            if (this.isFileReadOnly(file)) {
                CDIRenameProcessor.this.status.addFatalError(NLS.bind((String)CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
            } else {
                CDIRenameProcessor.this.change(file, offset, length, CDIRenameProcessor.this.newName);
            }
        }

        protected ELInvocationExpression findComponentReference(ELInvocationExpression invocationExpression) {
            if (CDIRenameProcessor.this.bean != null) {
                return invocationExpression;
            }
            ELInvocationExpression invExp = invocationExpression;
            while (invExp != null) {
                if (invExp instanceof ELPropertyInvocation) {
                    if (((ELPropertyInvocation)invExp).getQualifiedName() != null && ((ELPropertyInvocation)invExp).getQualifiedName().equals(this.propertyName)) {
                        return invExp;
                    }
                    invExp = invExp.getLeft();
                    continue;
                }
                invExp = invExp.getLeft();
            }
            return null;
        }

        protected IProject[] getProjects() {
            return new IProject[]{this.baseFile.getProject()};
        }
    }
}

