/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedMemberFeature;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.FieldDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.ParametedType;

public class TypeDefinition
extends AbstractTypeDefinition {
    boolean isAbstract;
    List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    List<MethodDefinition> methods = new ArrayList<MethodDefinition>();
    boolean hasBeanConstructor = false;

    @Override
    protected void init(IType contextType, IRootDefinitionContext context, int flags) throws CoreException {
        super.init(contextType, context, flags);
        boolean allMembers = (flags & FLAG_ALL_MEMBERS) > 0;
        this.isAbstract = Flags.isAbstract((int)this.type.getFlags()) || this.type.isInterface();
        for (IAnnotationDeclaration a : this.annotations) {
            context.getAnnotationKind(a.getType());
        }
        Set<IProcessAnnotatedMemberFeature> extensions = context.getProject().getExtensionManager().getProcessAnnotatedMemberFeatures();
        IField[] fs = this.getType().getFields();
        int i = 0;
        while (i < fs.length) {
            FieldDefinition f = this.newFieldDefinition();
            f.setTypeDefinition(this);
            f.setField(fs[i], context, flags);
            for (IProcessAnnotatedMemberFeature e : extensions) {
                e.processAnnotatedMember(f, context);
            }
            if (allMembers || f.isCDIAnnotated()) {
                this.fields.add(f);
            }
            ++i;
        }
        IMethod[] ms = this.getType().getMethods();
        boolean hasConstructor = false;
        int i2 = 0;
        while (i2 < ms.length) {
            MethodDefinition m = this.newMethodDefinition();
            m.setTypeDefinition(this);
            m.setMethod(ms[i2], context, flags);
            for (IProcessAnnotatedMemberFeature e : extensions) {
                e.processAnnotatedMember(m, context);
            }
            if (allMembers || m.isCDIAnnotated() || ms[i2].isConstructor() && ms[i2].getNumberOfParameters() == 0) {
                this.methods.add(m);
            }
            if (ms[i2].isConstructor()) {
                hasConstructor = true;
                if (!(ms[i2].getNumberOfParameters() != 0 && m.getInjectAnnotation() == null || this.isAbstract && !this.isAnnotationPresent("javax.decorator.Decorator"))) {
                    this.setBeanConstructor(true);
                }
            }
            ++i2;
        }
        if (!(hasConstructor || this.isAbstract && !this.isAnnotationPresent("javax.decorator.Decorator"))) {
            this.setBeanConstructor(true);
        }
    }

    protected FieldDefinition newFieldDefinition() {
        return new FieldDefinition();
    }

    protected MethodDefinition newMethodDefinition() {
        return new MethodDefinition();
    }

    public void setBeanConstructor(boolean b) {
        this.hasBeanConstructor = b;
    }

    public void checkConstructor() {
        for (MethodDefinition m : this.methods) {
            if (!m.isConstructor() || m.getAnnotation("javax.inject.Inject") == null) continue;
            this.setBeanConstructor(true);
        }
    }

    @Override
    public void annotationKindChanged(String typeName, IRootDefinitionContext context) {
        super.annotationKindChanged(typeName, context);
        for (FieldDefinition f : this.fields) {
            f.annotationKindChanged(typeName, context);
        }
        for (FieldDefinition m : this.fields) {
            m.annotationKindChanged(typeName, context);
        }
    }

    public ParametedType getSuperType() {
        return this.parametedType == null ? null : this.parametedType.getSuperType();
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public List<MethodDefinition> getMethods() {
        return this.methods;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean hasBeanConstructor() {
        return this.hasBeanConstructor;
    }

    public AnnotationDeclaration getDecoratorAnnotation() {
        return this.getAnnotation("javax.decorator.Decorator");
    }

    public AnnotationDeclaration getInterceptorAnnotation() {
        return this.getAnnotation("javax.interceptor.Interceptor");
    }

    public AnnotationDeclaration getStatefulAnnotation() {
        return this.getAnnotation("javax.ejb.Stateful");
    }

    public AnnotationDeclaration getStatelessAnnotation() {
        return this.getAnnotation("javax.ejb.Stateless");
    }

    public AnnotationDeclaration getSingletonAnnotation() {
        return this.getAnnotation("javax.ejb.Singleton");
    }
}

