/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.util.UniquePaths;

public class Dependencies {
    protected Map<IPath, Set<IPath>> direct = new HashMap<IPath, Set<IPath>>();
    protected Map<IPath, Set<IPath>> reverse = new HashMap<IPath, Set<IPath>>();

    public void addDependency(IPath source, IPath target) {
        source = UniquePaths.getInstance().intern(source);
        target = UniquePaths.getInstance().intern(target);
        Set<IPath> ps = this.direct.get(source);
        if (ps == null) {
            ps = new HashSet<IPath>();
            this.direct.put(source, ps);
        }
        ps.add(target);
        ps = this.reverse.get(target);
        if (ps == null) {
            ps = new HashSet<IPath>();
            this.reverse.put(target, ps);
        }
        ps.add(source);
    }

    public void clean() {
        this.direct.clear();
        this.reverse.clear();
    }

    public void clean(IPath path) {
        Set<IPath> ps = this.reverse.remove(path);
        if (ps != null) {
            for (IPath p : ps) {
                Set<IPath> ps1 = this.direct.get(p);
                if (ps1 == null) continue;
                ps1.remove(path);
            }
        }
    }

    public Set<IPath> getDirectDependencies(IPath path) {
        return this.direct.get(path);
    }
}

