/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl.definition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.IRootDefinitionContext;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractTypeDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationHelper;
import org.jboss.tools.cdi.internal.core.impl.definition.BeansXMLDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.Dependencies;
import org.jboss.tools.cdi.internal.core.impl.definition.PackageDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.UniquePaths;

public class DefinitionContext
implements IRootDefinitionContext {
    protected CDICoreNature project;
    protected IJavaProject javaProject;
    private Set<String> types = new HashSet<String>();
    private Map<IPath, Set<IPath>> childPaths = new HashMap<IPath, Set<IPath>>();
    private Map<IPath, Set<String>> resources = new HashMap<IPath, Set<String>>();
    private Map<String, TypeDefinition> typeDefinitions = new TreeMap<String, TypeDefinition>();
    private Map<String, AnnotationDefinition> annotations = new HashMap<String, AnnotationDefinition>();
    private Map<String, AnnotationDefinition> usedAnnotations = new HashMap<String, AnnotationDefinition>();
    private Set<String> vetoedTypes = new HashSet<String>();
    private Set<String> packages = new HashSet<String>();
    private Map<String, PackageDefinition> packageDefinitions = new HashMap<String, PackageDefinition>();
    private Map<IPath, BeansXMLDefinition> beanXMLs = new HashMap<IPath, BeansXMLDefinition>();
    Set<IDefinitionContextExtension> extensions = new HashSet<IDefinitionContextExtension>();
    private Dependencies dependencies = new Dependencies();
    private DefinitionContext workingCopy;
    private DefinitionContext original;
    private Set<String> underConstruction = new HashSet<String>();

    public void setExtensions(Set<IDefinitionContextExtension> extensions) {
        this.extensions.clear();
        this.extensions.addAll(extensions);
        for (IDefinitionContextExtension e : extensions) {
            e.setRootContext(this);
        }
    }

    @Override
    public Set<IDefinitionContextExtension> getExtensions() {
        return this.extensions;
    }

    public DefinitionContext getCleanCopy() {
        return this.copy(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefinitionContext copy(boolean clean) {
        DefinitionContext copy = new DefinitionContext();
        copy.project = this.project;
        copy.javaProject = this.javaProject;
        copy.extensions = new HashSet<IDefinitionContextExtension>();
        for (IDefinitionContextExtension e : this.extensions) {
            e.newWorkingCopy(clean);
            IDefinitionContextExtension ecopy = e.getWorkingCopy();
            ecopy.setRootContext(copy);
            copy.extensions.add(ecopy);
        }
        if (!clean) {
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                HashSet<String> s1;
                Set<String> set;
                AbstractMemberDefinition d;
                copy.types.addAll(this.types);
                for (String qn : this.typeDefinitions.keySet()) {
                    d = this.typeDefinitions.get(qn);
                    if (d.exists()) {
                        copy.typeDefinitions.put(qn, (TypeDefinition)d);
                        continue;
                    }
                    copy.types.remove(qn);
                }
                for (String qn : this.annotations.keySet()) {
                    d = this.annotations.get(qn);
                    if (!d.exists()) continue;
                    copy.annotations.put(qn, (AnnotationDefinition)d);
                }
                copy.vetoedTypes.addAll(this.vetoedTypes);
                copy.packages.addAll(this.packages);
                for (String qn : this.packageDefinitions.keySet()) {
                    d = this.packageDefinitions.get(qn);
                    if (d.exists()) {
                        copy.packageDefinitions.put(qn, (PackageDefinition)d);
                        continue;
                    }
                    this.packages.remove(qn);
                }
                for (IPath p : this.resources.keySet()) {
                    set = this.resources.get(p);
                    if (set == null) continue;
                    s1 = new HashSet<String>();
                    s1.addAll(set);
                    copy.resources.put(p, s1);
                }
                for (IPath p : this.childPaths.keySet()) {
                    set = this.childPaths.get(p);
                    if (set == null) continue;
                    s1 = new HashSet();
                    s1.addAll(set);
                    copy.childPaths.put(p, s1);
                }
                copy.beanXMLs.putAll(this.beanXMLs);
                copy.dependencies = this.dependencies;
            }
        }
        return copy;
    }

    public void setProject(CDICoreNature project) {
        this.project = project;
        this.javaProject = EclipseResourceUtil.getJavaProject((IProject)project.getProject());
    }

    @Override
    public CDICoreNature getProject() {
        return this.project;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public synchronized void addType(IPath file, String typeName, AbstractTypeDefinition def) {
        this.addType(file, typeName);
        if (def != null) {
            if (def instanceof AnnotationDefinition) {
                AnnotationDefinition newD = (AnnotationDefinition)def;
                AnnotationDefinition oldD = this.annotations.get(def.getQualifiedName());
                this.annotations.put(def.getQualifiedName(), newD);
                if (oldD != null && oldD.getKind() != newD.getKind()) {
                    this.annotationKindChanged(typeName);
                }
            } else {
                this.typeDefinitions.put(def.getQualifiedName(), (TypeDefinition)def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(IPath file, String packageName, PackageDefinition def) {
        if (file != null) {
            file = UniquePaths.getInstance().intern(file);
            Set<String> ts = this.resources.get(file);
            if (ts == null) {
                ts = new HashSet<String>();
                this.resources.put(file, ts);
            }
            packageName = packageName.intern();
            ts.add(packageName);
            this.packages.add(packageName);
            this.addToParents(file);
        }
        if (def != null) {
            DefinitionContext definitionContext = this;
            synchronized (definitionContext) {
                this.packageDefinitions.put(def.getQualifiedName(), def);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeanXML(IPath path, BeansXMLDefinition def) {
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            this.beanXMLs.put(path, def);
        }
        this.addToParents(path);
    }

    @Override
    public void addType(IPath file, String typeName) {
        if (file != null) {
            file = UniquePaths.getInstance().intern(file);
            Set<String> ts = this.resources.get(file);
            if (ts == null) {
                ts = new HashSet<String>();
                this.resources.put(file, ts);
            }
            typeName = typeName.intern();
            ts.add(typeName);
            this.types.add(typeName);
            this.addToParents(file);
        }
    }

    @Override
    public void addToParents(IPath file) {
        if (file == null) {
            return;
        }
        if (file.segmentCount() < 2) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            Set<IPath> cs = this.childPaths.get(q = q.removeLastSegments(1));
            if (cs == null) {
                cs = new HashSet<IPath>();
                this.childPaths.put(UniquePaths.getInstance().intern(q), cs);
            }
            cs.add(file);
        }
    }

    @Override
    public synchronized void clean() {
        this.childPaths.clear();
        this.resources.clear();
        this.types.clear();
        this.packages.clear();
        this.typeDefinitions.clear();
        this.vetoedTypes.clear();
        this.annotations.clear();
        this.packageDefinitions.clear();
        this.beanXMLs.clear();
        this.clean((IProject)null);
        for (IDefinitionContextExtension e : this.extensions) {
            e.clean();
        }
        this.dependencies.clean();
    }

    public synchronized void clean(IProject project) {
        Iterator<String> it = this.usedAnnotations.keySet().iterator();
        while (it.hasNext()) {
            AnnotationDefinition d = this.usedAnnotations.get(it.next());
            IType t = d.getType();
            if (t != null && t.exists() && t.getJavaProject().getProject() != project && t.getJavaProject().exists()) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(IPath path) {
        Set<String> ts = this.resources.remove(path);
        if (ts != null) {
            for (String string : ts) {
                this.clean(string);
            }
        }
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            this.beanXMLs.remove(path);
        }
        Set<IPath> set = this.childPaths.get(path);
        if (set != null) {
            IPath[] ps;
            IPath[] iPathArray = ps = set.toArray(new IPath[0]);
            int n = ps.length;
            int n2 = 0;
            while (n2 < n) {
                IPath p = iPathArray[n2];
                this.clean(p);
                ++n2;
            }
        } else {
            this.removeFromParents(path);
        }
        for (IDefinitionContextExtension e : this.extensions) {
            e.clean(path);
        }
        this.dependencies.clean(path);
    }

    @Override
    public synchronized void clean(String typeName) {
        this.types.remove(typeName);
        this.typeDefinitions.remove(typeName);
        this.vetoedTypes.remove(typeName);
        this.annotations.remove(typeName);
        this.packages.remove(typeName);
        this.packageDefinitions.remove(typeName);
        for (IDefinitionContextExtension e : this.extensions) {
            e.clean(typeName);
        }
    }

    void removeFromParents(IPath file) {
        if (file == null) {
            return;
        }
        IPath q = file;
        while (q.segmentCount() >= 2) {
            Set<IPath> cs = this.childPaths.get(q = q.removeLastSegments(1));
            if (cs == null) continue;
            cs.remove(file);
            if (!cs.isEmpty()) continue;
            this.childPaths.remove(q);
        }
    }

    @Override
    public int getAnnotationKind(IType annotationType) {
        if (annotationType == null) {
            return -1;
        }
        if (!annotationType.exists()) {
            return -1;
        }
        AnnotationDefinition d = this.getAnnotation(annotationType);
        if (d != null) {
            return d.getKind();
        }
        String name = annotationType.getFullyQualifiedName();
        if (this.types.contains(name)) {
            return 0;
        }
        if (AnnotationHelper.SCOPE_ANNOTATION_TYPES.contains(name)) {
            this.createAnnotation(annotationType, name);
            return 32;
        }
        if (AnnotationHelper.STEREOTYPE_ANNOTATION_TYPES.contains(name)) {
            this.createAnnotation(annotationType, name);
            return 8;
        }
        if (AnnotationHelper.QUALIFIER_ANNOTATION_TYPES.contains(name)) {
            this.createAnnotation(annotationType, name);
            return 4;
        }
        if (AnnotationHelper.BASIC_ANNOTATION_TYPES.contains(name)) {
            return 1;
        }
        if (AnnotationHelper.CDI_ANNOTATION_TYPES.contains(name)) {
            return 2;
        }
        if (this.underConstruction.contains(name)) {
            return 1;
        }
        return this.createAnnotation(annotationType, name);
    }

    private int createAnnotation(IType annotationType, String name) {
        this.underConstruction.add(name);
        AnnotationDefinition d = new AnnotationDefinition();
        d.setType(annotationType, this, 0);
        int kind = d.getKind();
        this.addType(annotationType.getPath(), name, d);
        this.underConstruction.remove(name);
        return kind;
    }

    @Override
    public void newWorkingCopy(boolean forFullBuild) {
        if (this.original != null || this.workingCopy != null) {
            return;
        }
        this.workingCopy = this.copy(forFullBuild);
        this.workingCopy.original = this;
    }

    @Override
    public DefinitionContext getWorkingCopy() {
        if (this.original != null) {
            return this;
        }
        if (this.workingCopy != null) {
            return this.workingCopy;
        }
        this.workingCopy = this.copy(false);
        this.workingCopy.original = this;
        return this.workingCopy;
    }

    @Override
    public void applyWorkingCopy() {
        if (this.original != null) {
            this.original.applyWorkingCopy();
            return;
        }
        if (this.workingCopy == null) {
            return;
        }
        HashSet<TypeDefinition> newTypeDefinitions = new HashSet<TypeDefinition>();
        for (String typeName : this.workingCopy.typeDefinitions.keySet()) {
            TypeDefinition nd = this.workingCopy.typeDefinitions.get(typeName);
            TypeDefinition od = this.typeDefinitions.get(typeName);
            if (od == nd) continue;
            newTypeDefinitions.add(nd);
        }
        this.types = this.workingCopy.types;
        this.resources = this.workingCopy.resources;
        this.childPaths = this.workingCopy.childPaths;
        this.typeDefinitions = this.workingCopy.typeDefinitions;
        this.vetoedTypes = this.workingCopy.vetoedTypes;
        this.annotations = this.workingCopy.annotations;
        this.packages = this.workingCopy.packages;
        this.packageDefinitions = this.workingCopy.packageDefinitions;
        this.beanXMLs = this.workingCopy.beanXMLs;
        Set<IProcessAnnotatedTypeFeature> fs = this.project.getExtensionManager().getProcessAnnotatedTypeFeatures();
        if (fs != null && !fs.isEmpty()) {
            for (TypeDefinition nd : newTypeDefinitions) {
                for (IProcessAnnotatedTypeFeature f : fs) {
                    f.processAnnotatedType(nd, this.workingCopy);
                }
            }
        }
        for (IDefinitionContextExtension e : this.extensions) {
            e.applyWorkingCopy();
        }
        this.dependencies = this.workingCopy.dependencies;
        this.project.getDelegate().update(true);
        this.workingCopy = null;
        if (!this.project.getProject().isAccessible()) {
            this.clean();
        }
    }

    public void dropWorkingCopy() {
        if (this.original != null) {
            this.original.dropWorkingCopy();
        } else {
            this.workingCopy = null;
        }
    }

    public AnnotationDefinition getAnnotation(IType type) {
        return this.getAnnotation(type.getFullyQualifiedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationDefinition getAnnotation(String fullyQualifiedName) {
        DefinitionContext definitionContext;
        AnnotationDefinition result = this.annotations.get(fullyQualifiedName);
        if (result != null && !result.getType().exists()) {
            definitionContext = this;
            synchronized (definitionContext) {
                this.annotations.remove(fullyQualifiedName);
            }
            result = null;
        }
        if (result == null || this.usedAnnotations.containsKey(fullyQualifiedName) || result.getType().getJavaProject() != null && result.getType().getJavaProject().getProject() != this.project.getProject()) {
            Set<CDICoreNature> ns2 = this.project.getCDIProjects(true);
            for (CDICoreNature n : DefinitionContext.toListOrderedByDependencies(ns2)) {
                DefinitionContext d = n.getDefinitions();
                AnnotationDefinition r = d.annotations.get(fullyQualifiedName);
                if (r == null) continue;
                result = r;
                DefinitionContext definitionContext2 = this;
                synchronized (definitionContext2) {
                    this.usedAnnotations.put(fullyQualifiedName, result);
                    break;
                }
            }
        }
        if (result == null && this.usedAnnotations.containsKey(fullyQualifiedName) && !(result = this.usedAnnotations.get(fullyQualifiedName)).getType().exists()) {
            definitionContext = this;
            synchronized (definitionContext) {
                this.usedAnnotations.remove(fullyQualifiedName);
            }
            result = null;
        }
        return result;
    }

    public synchronized List<AnnotationDefinition> getAllAnnotations() {
        ArrayList<AnnotationDefinition> result = new ArrayList<AnnotationDefinition>();
        result.addAll(this.annotations.values());
        result.addAll(this.usedAnnotations.values());
        return result;
    }

    public List<AnnotationDefinition> getAllAnnotationsWithDependencies() {
        Set<CDICoreNature> ps = this.project.getCDIProjects(true);
        if (ps.isEmpty() || ps.contains(this.project)) {
            return this.getAllAnnotations();
        }
        ArrayList<AnnotationDefinition> result = new ArrayList<AnnotationDefinition>();
        HashSet<IType> types = new HashSet<IType>();
        for (CDICoreNature p : DefinitionContext.toListOrderedByDependencies(ps)) {
            List<AnnotationDefinition> ds2 = p.getDefinitions().getAllAnnotations();
            for (AnnotationDefinition d : ds2) {
                IType t = d.getType();
                if (t == null || types.contains(t)) continue;
                types.add(t);
                result.add(d);
            }
        }
        List<AnnotationDefinition> ds = this.getAllAnnotations();
        for (AnnotationDefinition d : ds) {
            IType t = d.getType();
            if (t == null || types.contains(t)) continue;
            types.add(t);
            result.add(d);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypeDefinition> getTypeDefinitions() {
        ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.typeDefinitions.values());
        }
        for (IDefinitionContextExtension e : this.extensions) {
            List<TypeDefinition> ds = e.getTypeDefinitions();
            if (ds == null || ds.isEmpty()) continue;
            result.addAll(ds);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<BeansXMLDefinition> getBeansXMLDefinitions() {
        HashSet<BeansXMLDefinition> result = new HashSet<BeansXMLDefinition>();
        DefinitionContext definitionContext = this;
        synchronized (definitionContext) {
            result.addAll(this.beanXMLs.values());
        }
        return result;
    }

    public PackageDefinition getPackageDefinition(String packageName) {
        return this.packageDefinitions.get(packageName);
    }

    public TypeDefinition getTypeDefinition(String fullyQualifiedName) {
        return this.typeDefinitions.get(fullyQualifiedName);
    }

    private void annotationKindChanged(String typeName) {
        List<TypeDefinition> ds = this.getTypeDefinitions();
        for (TypeDefinition d : ds) {
            d.annotationKindChanged(typeName, this);
        }
    }

    public void veto(IType type) {
        TypeDefinition d = this.typeDefinitions.get(type.getFullyQualifiedName());
        if (d != null) {
            d.veto();
        } else {
            this.vetoedTypes.add(type.getFullyQualifiedName());
        }
    }

    public void unveto(IType type) {
        TypeDefinition d = this.typeDefinitions.get(type.getFullyQualifiedName());
        if (d != null) {
            d.unveto();
        } else {
            this.vetoedTypes.remove(type.getFullyQualifiedName());
        }
    }

    public Set<String> getVetoedTypes() {
        return this.vetoedTypes;
    }

    public boolean isVetoedTypeFromUsedProject(IType type) {
        TypeDefinition d = this.typeDefinitions.get(type.getFullyQualifiedName());
        return d == null && this.vetoedTypes.contains(type.getFullyQualifiedName());
    }

    @Override
    public void addDependency(IPath source, IPath target) {
        this.dependencies.addDependency(source, target);
    }

    public Dependencies getDependencies() {
        return this.dependencies;
    }

    public Dependencies getAllDependencies() {
        Set<CDICoreNature> ns = this.project.getCDIProjects(true);
        if (!ns.isEmpty()) {
            Dependencies d = new Dependencies();
            d.direct.putAll(this.dependencies.direct);
            d.reverse.putAll(this.dependencies.reverse);
            for (CDICoreNature n : ns) {
                d.direct.putAll(n.getDefinitions().getDependencies().direct);
                d.reverse.putAll(n.getDefinitions().getDependencies().reverse);
            }
            return d;
        }
        return this.dependencies;
    }

    /*
     * Exception decompiling
     */
    public static List<CDICoreNature> toListOrderedByDependencies(Set<CDICoreNature> set) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AnonBreakTarget
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

