/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.core.IDecorator;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInterceptor;
import org.jboss.tools.cdi.core.IInterceptorBinding;
import org.jboss.tools.cdi.core.IQualifier;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.InterceptorBindingElement;
import org.jboss.tools.cdi.internal.core.impl.QualifierElement;
import org.jboss.tools.cdi.internal.core.impl.ScopeElement;
import org.jboss.tools.cdi.internal.core.impl.StereotypeElement;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.java.IParametedType;

public class CDICache
implements Cloneable {
    static Collection<IBean> EMPTY = Collections.emptyList();
    private Map<String, StereotypeElement> stereotypes = new HashMap<String, StereotypeElement>();
    private Map<IPath, StereotypeElement> stereotypesByPath = new HashMap<IPath, StereotypeElement>();
    private Map<String, InterceptorBindingElement> interceptorBindings = new HashMap<String, InterceptorBindingElement>();
    private Map<IPath, InterceptorBindingElement> interceptorBindingsByPath = new HashMap<IPath, InterceptorBindingElement>();
    private Map<String, QualifierElement> qualifiers = new HashMap<String, QualifierElement>();
    private Map<IPath, QualifierElement> qualifiersByPath = new HashMap<IPath, QualifierElement>();
    private Map<String, ScopeElement> scopes = new HashMap<String, ScopeElement>();
    private Map<IPath, ScopeElement> scopesByPath = new HashMap<IPath, ScopeElement>();
    private Set<IBean> allBeans = new HashSet<IBean>();
    private Set<IBean> declaredBeans = new HashSet<IBean>();
    private Map<IPath, List<IBean>> beansByPath = new HashMap<IPath, List<IBean>>();
    private Map<String, Set<IBean>> beansByName = new HashMap<String, Set<IBean>>();
    private List<Set<IBean>> beansByTypes = new ArrayList<Set<IBean>>();
    private Set<IBean> namedBeans = new HashSet<IBean>();
    protected Map<IType, IClassBean> classBeans = new HashMap<IType, IClassBean>();
    private Set<IBean> alternatives = new HashSet<IBean>();
    private Set<IDecorator> decorators = new HashSet<IDecorator>();
    private Set<IInterceptor> interceptors = new HashSet<IInterceptor>();
    protected Set<IType> allTypes = new HashSet<IType>();
    protected Map<TypeDefinition, ClassBean> definitionToClassbeans = new HashMap<TypeDefinition, ClassBean>();
    private Map<String, Set<IInjectionPoint>> injectionPointsByType = new HashMap<String, Set<IInjectionPoint>>();
    private int beansByTypeSize;
    private int objectIndex;

    public CDICache() {
        this.setBeansByTypeSize(21);
    }

    public synchronized void setBeansByTypeSize(int beansByTypeSize) {
        ArrayList<Set<IBean>> beansByTypes = new ArrayList<Set<IBean>>();
        int i = 0;
        while (i < beansByTypeSize) {
            beansByTypes.add(new HashSet());
            ++i;
        }
        this.beansByTypes = beansByTypes;
        this.beansByTypeSize = beansByTypeSize;
        this.objectIndex = Math.abs("java.lang.Object".hashCode()) % beansByTypeSize;
    }

    private int toTypeIndex(IType type) {
        return Math.abs(type.getFullyQualifiedName().hashCode()) % this.beansByTypeSize;
    }

    public synchronized IBean[] getBeans() {
        return this.allBeans.toArray(new IBean[this.allBeans.size()]);
    }

    public Collection<IBean> getAllBeans() {
        return this.allBeans;
    }

    public synchronized Collection<IBean> getDeclaredBeans() {
        return new ArrayList<IBean>(this.declaredBeans);
    }

    public synchronized IBean[] getBeansByLegalType(IParametedType type) {
        if (type.getType() == null) {
            return new IBean[0];
        }
        int index = this.toTypeIndex(type.getType());
        Set<IBean> bs = index == this.objectIndex ? this.allBeans : this.beansByTypes.get(index);
        return bs.toArray(new IBean[bs.size()]);
    }

    public synchronized IQualifier[] getQualifiers() {
        return this.qualifiers.values().toArray(new IQualifier[this.qualifiers.size()]);
    }

    public synchronized IStereotype[] getStereotypes() {
        return this.stereotypes.values().toArray(new IStereotype[this.stereotypes.size()]);
    }

    public synchronized IBean[] getAlternatives() {
        return this.alternatives.toArray(new IBean[this.alternatives.size()]);
    }

    public synchronized IDecorator[] getDecorators() {
        return this.decorators.toArray(new IDecorator[this.decorators.size()]);
    }

    public synchronized IInterceptor[] getInterceptors() {
        return this.interceptors.toArray(new IInterceptor[this.interceptors.size()]);
    }

    public synchronized StereotypeElement getStereotype(IPath path) {
        return this.stereotypesByPath.get(path);
    }

    public StereotypeElement getStereotype(String qualifiedName) {
        return this.stereotypes.get(qualifiedName.replace('$', '.'));
    }

    public synchronized IInterceptorBinding[] getInterceptorBindings() {
        return this.interceptorBindings.values().toArray(new IInterceptorBinding[this.interceptorBindings.size()]);
    }

    public InterceptorBindingElement getInterceptorBinding(String qualifiedName) {
        return this.interceptorBindings.get(qualifiedName.replace('$', '.'));
    }

    public IInterceptorBinding getInterceptorBinding(IPath path) {
        return this.interceptorBindingsByPath.get(path);
    }

    public QualifierElement getQualifier(String qualifiedName) {
        return this.qualifiers.get(qualifiedName.replace('$', '.'));
    }

    public QualifierElement getQualifier(IPath path) {
        return this.qualifiersByPath.get(path);
    }

    public synchronized Set<String> getScopeNames() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.scopes.keySet());
        return result;
    }

    public ScopeElement getScope(String qualifiedName) {
        return this.scopes.get(qualifiedName.replace('$', '.'));
    }

    public IScope getScope(IPath path) {
        return this.scopesByPath.get(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDICache getModifiedCopy(IFile file, Collection<IBean> beans) {
        CDICache p = null;
        try {
            p = (CDICache)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        p.allBeans = new HashSet<IBean>();
        CDICache e = this;
        synchronized (e) {
            p.allBeans.addAll(this.allBeans);
        }
        Collection<IBean> oldBeans = this.getBeans(file.getFullPath());
        p.allBeans.removeAll(oldBeans);
        p.allBeans.addAll(beans);
        p.beansByTypes = new ArrayList<Set<IBean>>();
        int i = 0;
        while (i < this.beansByTypeSize) {
            HashSet<IBean> bs = new HashSet<IBean>((Collection)this.beansByTypes.get(i));
            bs.removeAll(oldBeans);
            bs.addAll(beans);
            p.beansByTypes.add(bs);
            ++i;
        }
        HashSet<IBean> oldNamedBeans = null;
        for (IBean b : oldBeans) {
            if (b.getName() == null) continue;
            if (oldNamedBeans == null) {
                oldNamedBeans = new HashSet<IBean>();
            }
            oldNamedBeans.add(b);
        }
        HashSet<IBean> newNamedBeans = null;
        for (IBean b : beans) {
            if (b.getName() == null) continue;
            if (newNamedBeans == null) {
                newNamedBeans = new HashSet<IBean>();
            }
            newNamedBeans.add(b);
        }
        if (newNamedBeans != null || oldNamedBeans != null) {
            p.namedBeans = new HashSet<IBean>();
            p.beansByName = new HashMap<String, Set<IBean>>();
            CDICache cDICache = this;
            synchronized (cDICache) {
                Set<IBean> bs;
                String n;
                p.namedBeans.addAll(this.namedBeans);
                if (oldNamedBeans != null) {
                    p.namedBeans.removeAll(oldNamedBeans);
                }
                if (newNamedBeans != null) {
                    p.namedBeans.addAll(newNamedBeans);
                }
                for (String n2 : this.beansByName.keySet()) {
                    HashSet bs2 = new HashSet(this.beansByName.get(n2));
                    p.beansByName.put(n2, bs2);
                }
                if (oldNamedBeans != null) {
                    for (IBean b : oldNamedBeans) {
                        n = b.getName();
                        bs = p.beansByName.get(n);
                        if (bs == null || !bs.contains(b)) continue;
                        bs.remove(b);
                    }
                }
                if (newNamedBeans != null) {
                    for (IBean b : newNamedBeans) {
                        n = b.getName();
                        bs = p.beansByName.get(n);
                        if (bs == null) {
                            bs = new HashSet<IBean>();
                            p.beansByName.put(n, bs);
                        }
                        bs.add(b);
                    }
                }
            }
        }
        return p;
    }

    public synchronized Collection<IBean> getBeans(IPath path) {
        return this.beansByPath.containsKey(path) ? new ArrayList(this.beansByPath.get(path)) : EMPTY;
    }

    public Set<IInjectionPoint> getInjections(String fullyQualifiedTypeName) {
        Set<IInjectionPoint> result = this.injectionPointsByType.get(fullyQualifiedTypeName);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public Collection<IBean> getNamedBeans() {
        return this.namedBeans;
    }

    public boolean containsType(IType t) {
        return this.allTypes.contains(t);
    }

    public Collection<IType> getAllTypes() {
        return this.allTypes;
    }

    public Collection<IBean> getBeans(String name) {
        return this.beansByName.containsKey(name) ? (Collection)this.beansByName.get(name) : EMPTY;
    }

    public synchronized void addBean(IBean bean, boolean isDeclaredByThisProject) {
        IClassBean c;
        IType t;
        boolean isAbstract;
        String name = bean.getName();
        IPath path = bean.getSourcePath();
        List<IBean> bs = this.beansByPath.get(path);
        if (bs == null) {
            bs = new ArrayList<IBean>();
            this.beansByPath.put(path, bs);
        }
        bs.add(bean);
        this.buildInjectionPoinsByType(bean);
        boolean bl = isAbstract = bean instanceof ClassBean && !((ClassBean)bean).getDefinition().hasBeanConstructor();
        if (isAbstract) {
            return;
        }
        if (name != null && name.length() > 0) {
            Set<IBean> bsn = this.beansByName.get(name);
            if (bsn == null) {
                bsn = new HashSet<IBean>();
                this.beansByName.put(name, bsn);
            }
            bsn.add(bean);
            this.namedBeans.add(bean);
        }
        if (bean.isAlternative()) {
            this.alternatives.add(bean);
        }
        if (bean instanceof IDecorator) {
            this.decorators.add((IDecorator)bean);
        }
        if (bean instanceof IInterceptor) {
            this.interceptors.add((IInterceptor)bean);
        }
        if (bean instanceof IClassBean && (t = (c = (IClassBean)bean).getBeanClass()) != null && !this.classBeans.containsKey(t)) {
            this.classBeans.put(t, c);
        }
        this.allBeans.add(bean);
        if (isDeclaredByThisProject) {
            this.declaredBeans.add(bean);
        }
        for (IParametedType t2 : bean.getLegalTypes()) {
            int index;
            if (t2.getType() == null || !t2.getType().exists() || (index = this.toTypeIndex(t2.getType())) == this.objectIndex) continue;
            this.beansByTypes.get(index).add(bean);
        }
    }

    synchronized void buildInjectionPoinsByType(IBean b) {
        Collection<IInjectionPoint> ps = b.getInjectionPoints();
        for (IInjectionPoint p : ps) {
            IParametedType t = p.getType();
            if (t == null || t.getType() == null) continue;
            String n = t.getType().getFullyQualifiedName();
            Set<IInjectionPoint> s = this.injectionPointsByType.get(n);
            if (s == null) {
                s = new HashSet<IInjectionPoint>();
                this.injectionPointsByType.put(n, s);
            }
            s.add(p);
        }
    }

    public synchronized void clean() {
        this.beansByPath.clear();
        this.beansByName.clear();
        this.namedBeans.clear();
        this.alternatives.clear();
        this.decorators.clear();
        this.interceptors.clear();
        this.allBeans.clear();
        this.declaredBeans.clear();
        this.injectionPointsByType.clear();
        int i = 0;
        while (i < this.beansByTypeSize) {
            this.beansByTypes.get(i).clear();
            ++i;
        }
    }

    public synchronized void cleanAnnotations() {
        this.stereotypes.clear();
        this.stereotypesByPath.clear();
        this.interceptorBindings.clear();
        this.qualifiers.clear();
        this.qualifiersByPath.clear();
        this.interceptorBindingsByPath.clear();
        this.scopes.clear();
        this.scopesByPath.clear();
    }

    public void add(StereotypeElement s) {
        this.stereotypes.put(s.getDefinition().getQualifiedName().replace('$', '.'), s);
        if (s.getDefinition().getResource() != null && s.getDefinition().getResource().getFullPath() != null) {
            this.stereotypesByPath.put(s.getDefinition().getResource().getFullPath(), s);
        }
    }

    public void add(InterceptorBindingElement s) {
        this.interceptorBindings.put(s.getDefinition().getQualifiedName().replace('$', '.'), s);
        if (s.getDefinition().getResource() != null && s.getDefinition().getResource().getFullPath() != null) {
            this.interceptorBindingsByPath.put(s.getDefinition().getResource().getFullPath(), s);
        }
    }

    public void add(QualifierElement s) {
        this.qualifiers.put(s.getDefinition().getQualifiedName().replace('$', '.'), s);
        if (s.getDefinition().getResource() != null && s.getDefinition().getResource().getFullPath() != null) {
            this.qualifiersByPath.put(s.getDefinition().getResource().getFullPath(), s);
        }
    }

    public void add(ScopeElement s) {
        this.scopes.put(s.getDefinition().getQualifiedName().replace('$', '.'), s);
        if (s.getDefinition().getResource() != null && s.getDefinition().getResource().getFullPath() != null) {
            this.scopesByPath.put(s.getDefinition().getResource().getFullPath(), s);
        }
    }
}

