/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.internal.core.impl.AbstractBeanElement;
import org.jboss.tools.cdi.internal.core.impl.ClassBean;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.BeanMemberDefinition;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.java.ParametedTypeFactory;
import org.jboss.tools.common.java.TypeDeclaration;

public abstract class BeanMember
extends AbstractBeanElement
implements IBeanMember {
    protected IClassBean classBean;
    protected TypeDeclaration typeDeclaration;

    @Override
    public BeanMemberDefinition getDefinition() {
        return (BeanMemberDefinition)this.definition;
    }

    protected void setMember(IJavaElement member) {
        this.typeDeclaration = BeanMember.getTypeDeclaration(this.getDefinition(), this.getCDIProject().getNature().getTypeFactory());
    }

    public IJavaElement getSourceElement() {
        return (IJavaElement)this.getDefinition().getMember();
    }

    public static TypeDeclaration getTypeDeclaration(final AbstractMemberDefinition definition, ParametedTypeFactory typeFactory) {
        final IJavaElement member = (IJavaElement)definition.getMember();
        try {
            ParametedType p;
            String returnType = null;
            IMember currentMember = null;
            if (member instanceof IField) {
                returnType = ((IField)member).getTypeSignature();
                currentMember = (IMember)member;
            } else if (member instanceof IMethod) {
                returnType = ((IMethod)member).getReturnType();
                currentMember = (IMember)member;
            } else if (member instanceof ILocalVariable) {
                returnType = ((ILocalVariable)member).getTypeSignature();
                currentMember = ((ILocalVariable)member).getDeclaringMember();
            }
            if (returnType != null && (p = typeFactory.getParametedType(currentMember, returnType)) != null) {
                TypeDeclaration.Lazy lazy = new TypeDeclaration.Lazy(){

                    public void init(TypeDeclaration d) {
                        int offset = -1;
                        int length = 0;
                        String content = definition.getTypeDefinition().getContent();
                        if (content != null) {
                            ISourceRange sr = null;
                            ISourceRange nr = null;
                            try {
                                sr = ((ISourceReference)member).getSourceRange();
                                nr = ((ISourceReference)member).getNameRange();
                            }
                            catch (JavaModelException e) {
                                CDICorePlugin.getDefault().logError(e);
                            }
                            if (sr != null && nr != null && sr.getOffset() < nr.getOffset() && nr.getOffset() < content.length()) {
                                String start = content.substring(sr.getOffset(), nr.getOffset());
                                int off = -1;
                                int off0 = -1;
                                int bc = 0;
                                int i = start.length() - 1;
                                while (i >= 0) {
                                    char ch = start.charAt(i);
                                    if (ch == '>') {
                                        ++bc;
                                    } else if (ch == '<') {
                                        --bc;
                                    }
                                    if (Character.isWhitespace(ch)) {
                                        if (off >= 0 && bc <= 0) {
                                            break;
                                        }
                                    } else if (Character.isJavaIdentifierPart(ch) || ch == '.' || ch == '$' || ch == '<' || ch == '>') {
                                        off = i;
                                        if (off0 < 0) {
                                            off0 = i + 1;
                                        }
                                    }
                                    --i;
                                }
                                if (off >= 0) {
                                    offset = sr.getOffset() + off;
                                    length = off0 - off;
                                }
                            }
                        }
                        d.init(offset, length);
                    }
                };
                return new TypeDeclaration(p, member.getResource(), lazy);
            }
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return null;
    }

    public void setTypeDeclaration(TypeDeclaration typeDeclaration) {
        this.typeDeclaration = typeDeclaration;
    }

    public TypeDeclaration getTypeDeclaration() {
        return this.typeDeclaration;
    }

    @Override
    public IClassBean getClassBean() {
        return this.classBean;
    }

    public void setClassBean(ClassBean classBean) {
        this.classBean = classBean;
        this.setParent(classBean);
    }

    public IParametedType getType() {
        return this.typeDeclaration;
    }

    @Override
    public IParametedType getMemberType() {
        return this.typeDeclaration;
    }

    @Override
    public IResource getResource() {
        if (this.definition.getOriginalDefinition() != null) {
            return this.definition.getOriginalDefinition().getResource();
        }
        return super.getResource();
    }

    protected ISourceReference getSourceReference() {
        return this.getSourceMember();
    }

    protected ISourceRange getSourceRange() {
        ISourceRange result = null;
        try {
            result = this.getSourceReference().getSourceRange();
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return result;
    }

    public int getLength() {
        if (this.definition.getOriginalDefinition() != null) {
            return this.definition.getOriginalDefinition().getLength();
        }
        ISourceRange r = this.getSourceRange();
        return r == null ? 0 : r.getLength();
    }

    public int getStartPosition() {
        if (this.definition.getOriginalDefinition() != null) {
            return this.definition.getOriginalDefinition().getStartPosition();
        }
        ISourceRange r = this.getSourceRange();
        return r == null ? 0 : r.getOffset();
    }

    public boolean isNullable() {
        return this.typeDeclaration == null ? false : !this.typeDeclaration.isPrimitive();
    }
}

