/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIVersion;
import org.jboss.tools.cdi.core.ICDIBuilderDelegate;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.extension.IDefinitionContextExtension;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipant2Feature;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationHelper;
import org.jboss.tools.cdi.internal.core.impl.definition.DefinitionContext;
import org.jboss.tools.cdi.internal.core.impl.definition.Dependencies;
import org.jboss.tools.cdi.internal.core.impl.definition.PackageDefinition;
import org.jboss.tools.cdi.internal.core.scanner.CDIBuilderDelegate;
import org.jboss.tools.cdi.internal.core.scanner.FileSet;
import org.jboss.tools.cdi.internal.core.scanner.lib.BeanArchiveDetector;
import org.jboss.tools.cdi.internal.core.scanner.lib.JarSet;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.UniquePaths;
import org.jboss.tools.common.web.WebUtils;

public class CDICoreBuilder
extends IncrementalProjectBuilder {
    public static String BUILDER_ID = "org.jboss.tools.cdi.core.cdibuilder";
    public static final String PACKAGE_INFO = "package-info.java";
    static Set<ICDIBuilderDelegate> delegates = null;
    ICDIBuilderDelegate builderDelegate;
    CDIResourceVisitor resourceVisitor = null;
    Set<IBuildParticipantFeature> buildParticipants = null;
    Set<IBuildParticipant2Feature> buildParticipants2 = null;
    CDICoreNature cdi;

    static Set<ICDIBuilderDelegate> getDelegates() {
        if (delegates == null) {
            delegates = new HashSet<ICDIBuilderDelegate>();
            delegates.add(new CDIBuilderDelegate());
        }
        return delegates;
    }

    public CDICoreBuilder() {
    }

    public CDICoreBuilder(CDICoreNature cdi) throws CoreException {
        this.cdi = cdi;
        this.build(6, null, (IProgressMonitor)new NullProgressMonitor());
    }

    CDICoreNature getCDICoreNature() {
        if (this.cdi != null) {
            return this.cdi;
        }
        IProject p = this.getProject();
        if (p == null) {
            return null;
        }
        return CDICorePlugin.getCDI(p, false);
    }

    IProject getCurrentProject() {
        return this.cdi != null ? this.cdi.getProject() : this.getProject();
    }

    CDIResourceVisitor getResourceVisitor() {
        if (this.resourceVisitor == null) {
            this.resourceVisitor = new CDIResourceVisitor();
        }
        return this.resourceVisitor;
    }

    private void findDelegate() {
        Set<ICDIBuilderDelegate> ds = CDICoreBuilder.getDelegates();
        int relevance = 0;
        for (ICDIBuilderDelegate d : ds) {
            int r = d.computeRelevance(this.getCurrentProject());
            if (r <= relevance) continue;
            this.builderDelegate = d;
            relevance = r;
        }
    }

    public ICDIBuilderDelegate getDelegate() {
        return this.builderDelegate;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.resourceVisitor = null;
        this.findDelegate();
        if (this.getDelegate() == null) {
            return null;
        }
        CDICoreNature n = this.getCDICoreNature();
        if (n == null) {
            return null;
        }
        if (n.updateVersion() || n.hasNoStorage()) {
            kind = 6;
        }
        n.postponeFiring();
        long begin = System.currentTimeMillis();
        try {
            n.resolveStorage(kind != 6);
            if (!n.requestForBuild()) {
                return null;
            }
            try {
                if (n.getDelegate() == null || n.getDelegate().getClass() != this.getDelegate().getProjectImplementationClass()) {
                    if (n.getDelegate() != null) {
                        n.clean();
                        n.postponeFiring();
                    }
                    kind = 6;
                    try {
                        ICDIProject delegate = this.getDelegate().getProjectImplementationClass().newInstance();
                        n.setCDIProject(delegate);
                    }
                    catch (IllegalAccessException e1) {
                        CDICorePlugin.getDefault().logError(e1);
                    }
                    catch (InstantiationException e2) {
                        CDICorePlugin.getDefault().logError(e2);
                    }
                }
                n.cleanTypeFactory();
                if (kind == 6) {
                    n.getClassPath().reset();
                }
                boolean isClassPathUpdated = n.getClassPath().update();
                JarSet newJars = new JarSet();
                if (isClassPathUpdated || kind == 6) {
                    n.getClassPath().setSrcs(this.getResourceVisitor().srcs);
                    newJars = n.getClassPath().process();
                }
                if (isClassPathUpdated || this.buildParticipants == null) {
                    this.buildParticipants = n.getExtensionManager().getBuildParticipantFeatures();
                    this.buildParticipants2 = new HashSet<IBuildParticipant2Feature>();
                    HashSet<IDefinitionContextExtension> es = new HashSet<IDefinitionContextExtension>();
                    for (IBuildParticipantFeature iBuildParticipantFeature : this.buildParticipants) {
                        IDefinitionContextExtension e = iBuildParticipantFeature.getContext();
                        if (e != null) {
                            es.add(e);
                        }
                        if (!(iBuildParticipantFeature instanceof IBuildParticipant2Feature)) continue;
                        this.buildParticipants2.add((IBuildParticipant2Feature)iBuildParticipantFeature);
                    }
                    n.getDefinitions().setExtensions(es);
                }
                n.getDefinitions().newWorkingCopy(kind == 6);
                if (isClassPathUpdated) {
                    n.getClassPath().applyRemovedPaths();
                }
                for (IBuildParticipantFeature p : this.buildParticipants) {
                    p.beginVisiting();
                }
                if (isClassPathUpdated || kind == 6) {
                    this.buildJars(newJars);
                    n.getClassPath().validateProjectDependencies();
                    kind = 6;
                } else if (n.getClassPath().hasToUpdateProjectDependencies()) {
                    n.getClassPath().validateProjectDependencies();
                }
                if (this.updateBeanDiscoveryMode()) {
                    kind = 6;
                }
                IResourceDelta delta = null;
                if (kind != 6) {
                    delta = this.getDelta(this.getCurrentProject());
                }
                if (kind == 6 || delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
                for (IBuildParticipantFeature iBuildParticipantFeature : this.buildParticipants) {
                    iBuildParticipantFeature.buildDefinitions();
                }
                this.getCDICoreNature().getDefinitions().applyWorkingCopy();
                long l = System.currentTimeMillis();
                n.fullBuildTime += l - begin;
                try {
                    n.store();
                }
                catch (IOException e) {
                    CDICorePlugin.getDefault().logError(e);
                }
            }
            finally {
                n.releaseBuild();
            }
        }
        finally {
            n.fireChanges();
        }
        this.resourceVisitor = null;
        return null;
    }

    private boolean updateBeanDiscoveryMode() {
        int oldValue = this.getCDICoreNature().getBeanDiscoveryMode();
        int newValue = 3;
        if (this.getCDICoreNature().getVersion() != CDIVersion.CDI_1_0) {
            newValue = this.getBeanDiscoveryMode(this.getPrimaryBeanXML());
        }
        this.getCDICoreNature().setBeanDiscoveryMode(newValue);
        return oldValue != newValue;
    }

    private int getBeanDiscoveryMode(XModelObject beansXML) {
        if (this.getCDICoreNature().getVersion() == CDIVersion.CDI_1_0) {
            return 3;
        }
        if (beansXML == null) {
            return 2;
        }
        String bdm = beansXML.getAttributeValue("bean-discovery-mode");
        if ("annotated".equals(bdm)) {
            return 2;
        }
        if ("none".equals(bdm)) {
            return 1;
        }
        return 3;
    }

    private XModelObject getPrimaryBeanXML() {
        XModelObject o;
        IFile f;
        IPath p;
        IWorkspaceRoot root = this.getCurrentProject().getWorkspace().getRoot();
        CDIResourceVisitor visitor = this.getResourceVisitor();
        IPath[] iPathArray = visitor.webinfs;
        int n = visitor.webinfs.length;
        int n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            f = root.getFile(p.append("beans.xml"));
            if (f.exists()) {
                o = EclipseResourceUtil.getObjectByResource((IResource)f);
                if (o == null) {
                    o = EclipseResourceUtil.createObjectForResource((IResource)f);
                }
                if (o != null) {
                    return o;
                }
            }
            ++n2;
        }
        iPathArray = visitor.srcs;
        n = visitor.srcs.length;
        n2 = 0;
        while (n2 < n) {
            p = iPathArray[n2];
            f = root.getFile(p.append("META-INF/beans.xml"));
            if (f.exists()) {
                o = EclipseResourceUtil.getObjectByResource((IResource)f);
                if (o == null) {
                    o = EclipseResourceUtil.createObjectForResource((IResource)f);
                }
                if (o != null) {
                    return o;
                }
            }
            ++n2;
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        if (this.getCDICoreNature().getBeanDiscoveryMode() == 1) {
            return;
        }
        try {
            CDIResourceVisitor rv = this.getResourceVisitor();
            rv.incremental = false;
            this.getCurrentProject().accept((IResourceVisitor)rv);
            FileSet fs = rv.fileSet;
            this.invokeBuilderDelegates(fs, this.getCDICoreNature());
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        if (this.getCDICoreNature().getBeanDiscoveryMode() == 1) {
            return;
        }
        CDIResourceVisitor rv = this.getResourceVisitor();
        rv.incremental = true;
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
        FileSet fs = rv.fileSet;
        this.invokeBuilderDelegates(fs, this.getCDICoreNature());
    }

    protected void buildJars(JarSet newJars) throws CoreException {
        Path path;
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.getCDICoreNature().getProject());
        if (jp == null) {
            return;
        }
        FileSet fileSet = new FileSet();
        fileSet.setCheckVetoed(this.getCDICoreNature().getVersion() != CDIVersion.CDI_1_0);
        for (String jar : newJars.getBeanModules().keySet()) {
            IJavaElement[] es;
            XModelObject beansXML;
            int bdm;
            path = new Path(jar);
            IPackageFragmentRoot root = BeanArchiveDetector.findPackageFragmentRoot(jar, jp);
            if (root == null || !root.exists() || (bdm = this.getBeanDiscoveryMode(beansXML = newJars.getBeanModules().get(jar))) == 1) continue;
            boolean annotatedOnly = bdm == 2;
            IJavaElement[] iJavaElementArray = es = root.getChildren();
            int n = es.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pf;
                IClassFile[] cs;
                IType packageInfo;
                IJavaElement e = iJavaElementArray[n2];
                if (e instanceof IPackageFragment && ((packageInfo = BeanArchiveDetector.findPackageInfo(cs = (pf = (IPackageFragment)e).getClassFiles())) == null || !BeanArchiveDetector.isVetoed(packageInfo))) {
                    IClassFile[] iClassFileArray = cs;
                    int n3 = cs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClassFile c = iClassFileArray[n4];
                        IType t = c.getType();
                        if (!annotatedOnly || BeanArchiveDetector.isAnnotatedBean(t, this.getCDICoreNature())) {
                            fileSet.add((IPath)path, c.getType());
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (beansXML != null) {
                fileSet.setBeanXML((IPath)path, beansXML);
            }
            for (IBuildParticipantFeature p : this.buildParticipants) {
                p.visitJar((IPath)path, root, beansXML);
            }
        }
        if (!this.buildParticipants2.isEmpty()) {
            for (String jar : newJars.getFileSystems().keySet()) {
                path = new Path(jar);
                XModelObject fs = newJars.getFileSystems().get(jar);
                for (IBuildParticipant2Feature p : this.buildParticipants2) {
                    p.visitJar((IPath)path, fs);
                }
            }
        }
        this.addBasicTypes(fileSet);
        this.invokeBuilderDelegates(fileSet, this.getCDICoreNature());
    }

    void invokeBuilderDelegates(FileSet fileSet, CDICoreNature n) {
        this.builderDelegate.build(fileSet, n);
        for (IBuildParticipantFeature p : this.buildParticipants) {
            p.buildDefinitions(fileSet);
        }
    }

    void addBasicTypes(FileSet fs) throws CoreException {
        IType type;
        IJavaProject jp = EclipseResourceUtil.getJavaProject((IProject)this.getCurrentProject());
        if (jp == null) {
            return;
        }
        for (String s : AnnotationHelper.SCOPE_ANNOTATION_TYPES) {
            type = EclipseJavaUtil.findType((IJavaProject)jp, (String)s);
            if (type == null) continue;
            fs.add(type.getPath(), type);
        }
        for (String s : AnnotationHelper.QUALIFIER_ANNOTATION_TYPES) {
            type = EclipseJavaUtil.findType((IJavaProject)jp, (String)s);
            if (type == null) continue;
            fs.add(type.getPath(), type);
        }
        for (String s : AnnotationHelper.STEREOTYPE_ANNOTATION_TYPES) {
            type = EclipseJavaUtil.findType((IJavaProject)jp, (String)s);
            if (type == null) continue;
            fs.add(type.getPath(), type);
        }
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        CDICoreNature n = this.getCDICoreNature();
        if (n != null) {
            n.clean();
        }
    }

    Set<IFile> getDependentFiles(IPath path, Set<IPath> visited) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Dependencies d = this.getCDICoreNature().getDefinitions().getWorkingCopy().getDependencies();
        HashSet<IFile> result = new HashSet<IFile>();
        Set<IPath> ps = d.getDirectDependencies(path);
        if (ps != null) {
            for (IPath p : ps) {
                IFile f;
                if (visited.contains(p) || !(f = root.getFile(p)).exists()) continue;
                result.add(f);
            }
        }
        return result;
    }

    private void addBeansXML(IFile f, FileSet fileSet) {
        if (f.getName().equals("beans.xml")) {
            XModelObject beansXML = EclipseResourceUtil.getObjectByResource((IResource)f);
            if (beansXML == null) {
                beansXML = EclipseResourceUtil.createObjectForResource((IResource)f);
            }
            if (beansXML != null) {
                fileSet.setBeanXML(f.getFullPath(), beansXML);
            }
        }
    }

    public static boolean isPackageInfo(IResource f) {
        return f instanceof IFile && f.getName().equals(PACKAGE_INFO);
    }

    class CDIResourceVisitor
    implements IResourceVisitor {
        boolean incremental = false;
        FileSet fileSet = new FileSet();
        IPath[] outs = new IPath[0];
        IPath[] srcs = new IPath[0];
        IPath[] webinfs = new IPath[0];
        Set<IPath> visited = new HashSet<IPath>();
        Map<IPath, PackageInfo> checkedPackages = new HashMap<IPath, PackageInfo>();

        CDIResourceVisitor() {
            this.fileSet.setCheckVetoed(CDICoreBuilder.this.getCDICoreNature().getVersion() != CDIVersion.CDI_1_0);
            this.webinfs = WebUtils.getWebInfPaths((IProject)CDICoreBuilder.this.getCurrentProject());
            this.getJavaSourceRoots(CDICoreBuilder.this.getCurrentProject());
        }

        void getJavaSourceRoots(IProject project) {
            IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                return;
            }
            ArrayList<IPath> ps = new ArrayList<IPath>();
            ArrayList<IPath> os = new ArrayList<IPath>();
            try {
                IPath output = javaProject.getOutputLocation();
                if (output != null) {
                    os.add(output);
                }
                IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < es.length) {
                    if (es[i].getEntryKind() == 3) {
                        IPath out;
                        IResource findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                        if (findMember != null && findMember.exists()) {
                            ps.add(findMember.getFullPath());
                        }
                        if ((out = es[i].getOutputLocation()) != null && !os.contains(out)) {
                            os.add(out);
                        }
                    }
                    ++i;
                }
                this.srcs = ps.toArray(new IPath[ps.size()]);
                this.outs = os.toArray(new IPath[os.size()]);
            }
            catch (CoreException ce) {
                CDICorePlugin.getDefault().logError("Error while locating java source roots for " + project, ce);
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            IPath path = resource.getFullPath();
            path = UniquePaths.getInstance().intern(path);
            if (resource instanceof IFile) {
                if (this.visited.contains(path)) {
                    return false;
                }
                this.visited.add(path);
                IFile f = (IFile)resource;
                int i = 0;
                while (i < this.outs.length) {
                    if (this.outs[i].isPrefixOf(path)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.srcs.length) {
                    if (this.srcs[i].isPrefixOf(path)) {
                        if (f.getName().endsWith(".java")) {
                            ICompilationUnit unit = EclipseUtil.getCompilationUnit((IFile)f);
                            if (unit != null) {
                                if (CDICoreBuilder.isPackageInfo((IResource)f)) {
                                    IPackageDeclaration[] pkg = unit.getPackageDeclarations();
                                    if (pkg != null && pkg.length > 0) {
                                        this.fileSet.add(f.getFullPath(), pkg[0]);
                                        if (this.incremental) {
                                            IResource[] ms;
                                            IResource[] iResourceArray = ms = resource.getParent().members();
                                            int n = ms.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                IResource m = iResourceArray[n2];
                                                if (m instanceof IFile && !CDICoreBuilder.isPackageInfo((IResource)((IFile)m))) {
                                                    this.visit(m);
                                                }
                                                ++n2;
                                            }
                                        }
                                    }
                                } else {
                                    IType[] ts;
                                    IType[] iTypeArray = ts = this.isInVetoedPackage(f) ? new IType[]{} : unit.getTypes();
                                    if (ts.length > 0 && CDICoreBuilder.this.getCDICoreNature().getBeanDiscoveryMode() == 2) {
                                        ts = BeanArchiveDetector.getAnnotatedTypes(ts, CDICoreBuilder.this.getCDICoreNature());
                                    }
                                    this.fileSet.add(f.getFullPath(), ts);
                                }
                            }
                        } else if (path.segmentCount() == this.srcs[i].segmentCount() + 2 && "META-INF".equals(path.segments()[path.segmentCount() - 2])) {
                            CDICoreBuilder.this.addBeansXML(f, this.fileSet);
                        }
                        for (IBuildParticipantFeature p : CDICoreBuilder.this.buildParticipants) {
                            p.visit(f, this.srcs[i], null);
                        }
                        Set<IFile> ds = CDICoreBuilder.this.getDependentFiles(path, this.visited);
                        if (ds != null) {
                            for (IFile d : ds) {
                                this.visit((IResource)d);
                            }
                        }
                        return false;
                    }
                    ++i;
                }
                IPath[] iPathArray = this.webinfs;
                int n = this.webinfs.length;
                int ds = 0;
                while (ds < n) {
                    IPath webinf = iPathArray[ds];
                    if (webinf.isPrefixOf(path)) {
                        if (webinf.segmentCount() == path.segmentCount() - 1) {
                            CDICoreBuilder.this.addBeansXML(f, this.fileSet);
                        }
                        for (IBuildParticipantFeature p : CDICoreBuilder.this.buildParticipants) {
                            p.visit(f, null, webinf);
                        }
                    }
                    ++ds;
                }
                Set<IFile> ds2 = CDICoreBuilder.this.getDependentFiles(path, this.visited);
                if (ds2 != null) {
                    for (IFile d : ds2) {
                        this.visit((IResource)d);
                    }
                }
            }
            if (resource instanceof IFolder) {
                IPath[] iPathArray = this.outs;
                int n = this.outs.length;
                int n3 = 0;
                while (n3 < n) {
                    IPath out = iPathArray[n3];
                    if (out.isPrefixOf(path)) {
                        return false;
                    }
                    ++n3;
                }
                iPathArray = this.srcs;
                n = this.srcs.length;
                n3 = 0;
                while (n3 < n) {
                    IPath src = iPathArray[n3];
                    if (src.isPrefixOf(path) || path.isPrefixOf(src)) {
                        return true;
                    }
                    ++n3;
                }
                iPathArray = this.webinfs;
                n = this.webinfs.length;
                n3 = 0;
                while (n3 < n) {
                    IPath webinf = iPathArray[n3];
                    if (webinf.isPrefixOf(path) || path.isPrefixOf(webinf)) {
                        return true;
                    }
                    ++n3;
                }
                return resource == resource.getProject();
            }
            return true;
        }

        private boolean isInVetoedPackage(IFile f) throws CoreException {
            if (CDICoreBuilder.this.getCDICoreNature().getVersion() == CDIVersion.CDI_1_0) {
                return false;
            }
            IContainer c = f.getParent();
            PackageInfo b = this.checkedPackages.get(c.getFullPath());
            if (b == null) {
                b = new PackageInfo(c);
                this.checkedPackages.put(c.getFullPath(), b);
            }
            return b.exists && b.isVetoed;
        }
    }

    private class PackageInfo {
        IPath path = null;
        boolean exists = false;
        boolean isVetoed = false;

        PackageInfo(IContainer c) throws CoreException {
            IFile f = c.getFile((IPath)new Path(CDICoreBuilder.PACKAGE_INFO));
            this.path = f.getFullPath();
            this.exists = f.exists();
            if (this.exists) {
                DefinitionContext context = CDICoreBuilder.this.getCDICoreNature().getDefinitions().getWorkingCopy();
                ICompilationUnit unit = EclipseUtil.getCompilationUnit((IFile)f);
                IPackageDeclaration[] pkg = unit.getPackageDeclarations();
                if (pkg != null && pkg.length > 0) {
                    PackageDefinition def = null;
                    if (def == null) {
                        def = new PackageDefinition();
                        def.setPackage(pkg[0], context);
                    }
                    this.isVetoed = def.isVetoed();
                }
            }
        }
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    return CDICoreBuilder.this.getResourceVisitor().visit(resource);
                }
                case 2: {
                    CDICoreNature p = CDICoreBuilder.this.getCDICoreNature();
                    CDIResourceVisitor v = CDICoreBuilder.this.getResourceVisitor();
                    Set<IFile> fs = CDICoreBuilder.this.getDependentFiles(resource.getFullPath(), v.visited);
                    for (IFile f : fs) {
                        v.visit((IResource)f);
                    }
                    if (p == null) break;
                    p.getDefinitions().getWorkingCopy().clean(resource.getFullPath());
                    break;
                }
                case 4: {
                    return CDICoreBuilder.this.getResourceVisitor().visit(resource);
                }
            }
            return true;
        }
    }
}

