/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.dnd;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.tools.modeshape.jcr.JcrModelObject;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.ui.dnd.JcrTransfer;
import org.jboss.tools.modeshape.ui.UiUtils;

public final class NamespaceMappingTransfer
extends JcrTransfer {
    private static NamespaceMappingTransfer _instance;

    public static NamespaceMappingTransfer get() {
        if (_instance == null) {
            _instance = new NamespaceMappingTransfer();
        }
        return _instance;
    }

    private NamespaceMappingTransfer() {
        super(NamespaceMappingTransfer.class);
    }

    @Override
    protected Class<? extends JcrModelObject> getJcrModelObjectClass() {
        return NamespaceMapping.class;
    }

    @Override
    protected JcrModelObject readFromStream(DataInputStream inStream) throws Exception {
        NamespaceMapping namespaceMapping = new NamespaceMapping();
        namespaceMapping.setPrefix(inStream.readUTF());
        namespaceMapping.setUri(inStream.readUTF());
        namespaceMapping.setComment(inStream.readUTF());
        return namespaceMapping;
    }

    @Override
    protected void writeToStream(JcrModelObject jcrModelObject, DataOutputStream outStream) throws Exception {
        assert (jcrModelObject instanceof NamespaceMapping);
        NamespaceMapping namespaceMapping = (NamespaceMapping)jcrModelObject;
        outStream.writeUTF(UiUtils.ensureNotNull((String)namespaceMapping.getPrefix()));
        outStream.writeUTF(UiUtils.ensureNotNull((String)namespaceMapping.getUri()));
        outStream.writeUTF(UiUtils.ensureNotNull((String)namespaceMapping.getComment()));
    }
}

