/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;

abstract class StringValueEditorDialog
extends FormDialog {
    private Button btnOk;
    private String originalValue;
    private ScrolledForm scrolledForm;
    private final Settings settings = this.getSettings();
    private String valueBeingEdited;

    protected StringValueEditorDialog(Shell parentShell) {
        super(parentShell);
        assert (this.settings != null) : "settings is null";
        assert (this.settings.acceptMessage != null) : "settings.acceptMessage is null";
        assert (this.settings.initialMessage != null) : "settings.initialMessage is null";
        assert (this.settings.labelText != null) : "settings.labelText is null";
        assert (this.settings.messageAreaTitle != null) : "settings.messageAreaTitle is null";
        if (this.settings.valueBeingEdited == null) {
            this.valueBeingEdited = "";
        } else {
            this.originalValue = this.settings.valueBeingEdited;
            this.valueBeingEdited = this.settings.valueBeingEdited;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CndMessages.valueEditorDialogTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.settings.messageAreaTitle);
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setMessage(this.settings.initialMessage, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        Label lblValue = toolkit.createLabel(body, this.settings.labelText, 0);
        lblValue.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text txtValue = toolkit.createText(body, null, 2048);
        txtValue.setToolTipText(this.settings.valueToolTip);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        txtValue.setLayoutData((Object)gd);
        if (this.isEditMode()) {
            txtValue.setText(this.valueBeingEdited);
        }
        txtValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringValueEditorDialog.this.handleValueChanged(((Text)e.widget).getText());
            }
        });
        txtValue.setFocus();
    }

    protected abstract Settings getSettings();

    public String getValue() {
        return this.valueBeingEdited;
    }

    void handleValueChanged(String newValue) {
        this.valueBeingEdited = newValue;
        this.updateState();
    }

    private boolean isEditMode() {
        return this.originalValue != null;
    }

    private void updateState() {
        boolean enable = true;
        ValidationStatus status = ValidationStatus.OK_STATUS;
        if (this.settings.validator != null) {
            status = this.settings.validator.validate(this.valueBeingEdited);
            enable = !status.isError();
        }
        this.scrolledForm.setMessage("", 1);
        if (!enable) {
            this.scrolledForm.setMessage(status.getMessage(), 3);
        } else if (this.isEditMode() && this.originalValue.equals(this.valueBeingEdited) || !this.isEditMode() && Utils.isEmpty((String)this.valueBeingEdited)) {
            enable = false;
            this.scrolledForm.setMessage(this.settings.initialMessage, 0);
        } else {
            int severity = 0;
            String message = status.getMessage();
            if (status.isWarning()) {
                severity = 2;
            } else if (status.isInfo()) {
                severity = 1;
            } else {
                message = this.settings.initialMessage;
            }
            this.scrolledForm.setMessage(message, severity);
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }

    class Settings {
        String acceptMessage;
        String initialMessage;
        String labelText;
        String messageAreaTitle;
        Validator validator;
        String valueBeingEdited;
        String valueToolTip;

        Settings() {
        }
    }

    static interface Validator {
        public ValidationStatus validate(String var1);
    }
}

