/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameProposalProvider;

final class QualifiedNameEditor
extends Composite {
    private CCombo cbxQualifiers;
    private Collection<QualifiedName> existingQNames;
    private Label lblName;
    private Label lblQualifier;
    private QualifiedName qnameBeingEdited;
    private final String qualifiedNameType;
    private String qualifier;
    private ContentProposalAdapter proposalAdapter;
    private QualifiedNameProposalProvider proposalProvider;
    private boolean residualNameAllowed = false;
    private ValidationStatus status;
    private final FormToolkit toolkit;
    private Text txtName;
    private String unqualifiedName;
    private List<String> validQualifiers;

    public QualifiedNameEditor(Composite parent, int style, FormToolkit toolkit, String qualifiedNameType, Collection<String> existingQualifiers, QualifiedName qnameBeingEdited) {
        super(parent, style);
        Utils.verifyIsNotNull((Object)qualifiedNameType, (String)"qualifiedNameType");
        Utils.verifyIsNotNull((Object)toolkit, (String)"toolkit");
        this.qualifiedNameType = qualifiedNameType;
        this.toolkit = toolkit;
        this.toolkit.adapt((Composite)this);
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 128, true, false));
        this.constructEditor();
        this.setValidQualifiers(existingQualifiers);
        this.setNameBeingEdited(qnameBeingEdited);
    }

    private void constructEditor() {
        this.lblQualifier = this.toolkit.createLabel((Composite)this, CndMessages.qualifierLabel, 0);
        this.lblQualifier.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbxQualifiers = new CCombo((Composite)this, 0x800808);
        this.toolkit.adapt((Control)this.cbxQualifiers, true, false);
        this.cbxQualifiers.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)this.cbxQualifiers.getLayoutData()).heightHint = this.cbxQualifiers.getItemHeight() + 4;
        this.cbxQualifiers.setToolTipText(CndMessages.validQualifiersToolTip);
        this.cbxQualifiers.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newQualifier = ((CCombo)e.widget).getText();
                QualifiedNameEditor.this.handleQualifierChanged(newQualifier);
            }
        });
        this.lblName = this.toolkit.createLabel((Composite)this, CndMessages.nameLabel, 0);
        this.lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtName = this.toolkit.createText((Composite)this, null, 2048);
        this.txtName.setToolTipText(CndMessages.unqualifiedNameToolTip);
        this.txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QualifiedNameEditor.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        this.proposalAdapter = new ContentProposalAdapter((Control)this.txtName, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new SimpleContentProposalProvider(new String[0]), KeyStroke.getInstance((int)262144, (int)32), "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.".toCharArray());
        this.proposalAdapter.setProposalAcceptanceStyle(2);
        this.txtName.setFocus();
    }

    public QualifiedName getQualifiedName() {
        return new QualifiedName(this.qualifier, this.unqualifiedName);
    }

    public ValidationStatus getStatus() {
        return this.status;
    }

    void handleNameChanged(String newName) {
        this.unqualifiedName = newName;
        this.validate();
    }

    void handleQualifierChanged(String newQualifier) {
        this.qualifier = CndMessages.noNameQualifierChoice.equals(newQualifier) ? "" : newQualifier;
        if (this.proposalProvider != null) {
            this.proposalProvider.setQualifier(this.qualifier);
        }
        this.validate();
    }

    private boolean isEditMode() {
        return this.qnameBeingEdited != null;
    }

    public void setAllowsResidualName(boolean newValue) {
        this.residualNameAllowed = newValue;
        this.validate();
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (this.txtName.getEnabled() != enable) {
            this.lblQualifier.setEnabled(enable);
            this.cbxQualifiers.setEnabled(enable);
            this.lblName.setEnabled(enable);
            this.txtName.setEnabled(enable);
        }
    }

    void setExistingQNames(Collection<QualifiedName> existingQNames) {
        if (Utils.isEmpty(existingQNames)) {
            this.existingQNames = null;
        } else {
            this.existingQNames = new ArrayList<QualifiedName>(existingQNames);
            if (this.isEditMode()) {
                this.existingQNames.remove(this.qnameBeingEdited);
            }
        }
    }

    public void setNameBeingEdited(QualifiedName qnameBeingEdited) {
        this.qnameBeingEdited = qnameBeingEdited;
        if (this.qnameBeingEdited == null) {
            this.qualifier = null;
            this.unqualifiedName = null;
        } else {
            this.qualifier = this.qnameBeingEdited.getQualifier();
            this.unqualifiedName = this.qnameBeingEdited.getUnqualifiedName();
        }
        this.updateUi();
        this.validate();
    }

    public void setProposalProvider(QualifiedNameProposalProvider proposalProvider) {
        this.proposalProvider = proposalProvider;
        this.proposalAdapter.setContentProposalProvider((IContentProposalProvider)proposalProvider);
    }

    void setValidQualifiers(Collection<String> validQualifiers) {
        List<String> list = this.validQualifiers = validQualifiers == null ? new ArrayList<String>(1) : new ArrayList<String>(validQualifiers);
        if (!this.validQualifiers.contains(CndMessages.noNameQualifierChoice)) {
            this.validQualifiers.add(0, CndMessages.noNameQualifierChoice);
        }
        this.updateUi();
    }

    private void updateUi() {
        String[] currentItems = this.cbxQualifiers.getItems();
        ArrayList<String> allQualifiers = new ArrayList<String>(this.validQualifiers);
        String currentQualifier = null;
        if (this.isEditMode() && !Utils.isEmpty((String)(currentQualifier = this.qnameBeingEdited.getQualifier())) && !this.validQualifiers.contains(currentQualifier)) {
            allQualifiers.add(currentQualifier);
        }
        if (allQualifiers.size() != currentItems.length || !allQualifiers.containsAll(Arrays.asList(currentItems))) {
            Object[] newQualifiers = allQualifiers.toArray(new String[allQualifiers.size()]);
            Arrays.sort(newQualifiers);
            this.cbxQualifiers.setItems((String[])newQualifiers);
        }
        if (this.isEditMode()) {
            if (Utils.isEmpty((String)currentQualifier)) {
                this.cbxQualifiers.select(0);
            } else {
                int index = this.cbxQualifiers.indexOf(currentQualifier);
                assert (index != -1) : "qualifier not found=" + currentQualifier;
                this.cbxQualifiers.select(index);
            }
            String name = this.qnameBeingEdited.getUnqualifiedName();
            this.txtName.setText(Utils.isEmpty((String)name) ? "" : name);
        } else {
            this.cbxQualifiers.select(0);
            this.txtName.setText("");
        }
    }

    private void validate() {
        if ("*".equals(this.unqualifiedName) && this.residualNameAllowed) {
            this.status = ValidationStatus.OK_STATUS;
        } else {
            QualifiedName currentQName = new QualifiedName(this.qualifier, this.unqualifiedName);
            this.status = CndValidator.validateQualifiedName((QualifiedName)currentQName, (String)this.qualifiedNameType, this.validQualifiers, this.existingQNames);
        }
        Event e = new Event();
        e.widget = this;
        e.type = 24;
        e.text = this.getQualifiedName().get();
        this.notifyListeners(24, e);
    }
}

