/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameEditor;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameProposalProvider;

final class QualifiedNameDialog
extends FormDialog {
    private Button btnOk;
    private Collection<QualifiedName> existingQNames;
    private QualifiedNameEditor nameEditor;
    private QualifiedName qnameBeingEdited;
    private final String qualifiedNameType;
    private QualifiedNameProposalProvider proposalProvider;
    private ScrolledForm scrolledForm;
    private final String title;
    private final List<String> validQualifiers;

    public QualifiedNameDialog(Shell parentShell, String title, String qualifiedNameType, Collection<String> existingQualifiers) {
        super(parentShell);
        Utils.verifyIsNotNull((Object)qualifiedNameType, (String)"qualifiedNameType");
        this.title = title;
        this.qualifiedNameType = qualifiedNameType;
        this.validQualifiers = existingQualifiers == null ? new ArrayList<String>(1) : new ArrayList<String>(existingQualifiers);
        this.validQualifiers.add(0, CndMessages.noNameQualifierChoice);
    }

    public QualifiedNameDialog(Shell parentShell, String title, String qualifiedNameType, Collection<String> existingQualifiers, QualifiedName qnameBeingEdited) {
        this(parentShell, title, qualifiedNameType, existingQualifiers);
        Utils.verifyIsNotNull((Object)qnameBeingEdited, (String)"qnameBeingEdited");
        this.qnameBeingEdited = qnameBeingEdited;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CndMessages.qualifiedNameDialogTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.title);
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setMessage(NLS.bind((String)CndMessages.qualifiedNameDialogMsg, (Object)this.qualifiedNameType), 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        this.nameEditor = new QualifiedNameEditor(body, 0, toolkit, this.qualifiedNameType, this.validQualifiers, this.qnameBeingEdited);
        this.nameEditor.setExistingQNames(this.existingQNames);
        this.nameEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                QualifiedNameDialog.this.handleNameChanged(e.text);
            }
        });
        this.nameEditor.setProposalProvider(this.proposalProvider);
    }

    public QualifiedName getQualifiedName() {
        return this.nameEditor.getQualifiedName();
    }

    void handleNameChanged(String newName) {
        this.updateState();
    }

    private boolean isEditMode() {
        return this.qnameBeingEdited != null;
    }

    void setExistingQNames(Collection<QualifiedName> existingQNames) {
        if (this.nameEditor == null) {
            this.existingQNames = existingQNames;
        } else {
            this.nameEditor.setExistingQNames(existingQNames);
        }
    }

    public void setProposalProvider(QualifiedNameProposalProvider proposalProvider) {
        if (this.nameEditor == null) {
            this.proposalProvider = proposalProvider;
        } else {
            this.nameEditor.setProposalProvider(proposalProvider);
        }
    }

    private void updateState() {
        QualifiedName modifiedQName = this.nameEditor.getQualifiedName();
        ValidationStatus status = this.nameEditor.getStatus();
        boolean enable = !status.isError();
        this.scrolledForm.setMessage("", 1);
        if (!enable) {
            this.scrolledForm.setMessage(status.getMessage(), 3);
        } else if (this.isEditMode() && modifiedQName.equals((Object)this.qnameBeingEdited) || !this.isEditMode() && Utils.isEmpty((String)modifiedQName.getQualifier()) && Utils.isEmpty((String)modifiedQName.getUnqualifiedName())) {
            enable = false;
            this.scrolledForm.setMessage(NLS.bind((String)CndMessages.qualifiedNameDialogMsg, (Object)this.qualifiedNameType), 0);
        } else {
            int severity = 0;
            String message = status.getMessage();
            if (status.isWarning()) {
                severity = 2;
            } else if (status.isInfo()) {
                severity = 1;
            } else {
                message = NLS.bind((String)CndMessages.acceptQualifiedNameDialogMsg, (Object)this.qualifiedNameType);
            }
            this.scrolledForm.setMessage(message, severity);
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }
}

