/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.jcr.MultiValidationStatus;
import org.jboss.tools.modeshape.jcr.NamespaceMapping;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.WorkspaceRegistry;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.ui.UiUtils;

final class NamespaceMappingDialog
extends FormDialog {
    private Button btnOk;
    private String comment;
    private final List<NamespaceMapping> existingNamespaces;
    private NamespaceMapping namespaceBeingEdited;
    private String prefix;
    private String saveUri = "";
    private ScrolledForm scrolledForm;
    private Text txtUri;
    private String uri;

    public NamespaceMappingDialog(Shell parentShell, Collection<NamespaceMapping> existingNamespaces) {
        super(parentShell);
        this.existingNamespaces = existingNamespaces == null ? new ArrayList<NamespaceMapping>() : new ArrayList<NamespaceMapping>(existingNamespaces);
    }

    public NamespaceMappingDialog(Shell parentShell, Collection<NamespaceMapping> existingNamespaces, NamespaceMapping namespaceBeingEdited) {
        this(parentShell, existingNamespaces);
        Utils.verifyIsNotNull((Object)namespaceBeingEdited, (String)"namespaceBeingEdited");
        this.namespaceBeingEdited = namespaceBeingEdited;
        this.prefix = this.namespaceBeingEdited.getPrefix();
        this.uri = this.namespaceBeingEdited.getUri();
        this.comment = this.namespaceBeingEdited.getComment();
        this.existingNamespaces.remove(this.namespaceBeingEdited);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CndMessages.namespaceDialogTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.isEditMode() ? CndMessages.editNamespaceDialogTitle : CndMessages.newNamespaceDialogTitle);
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setMessage(CndMessages.namespaceDialogMsg, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        Label lblPrefix = toolkit.createLabel(body, CndMessages.namespacePrefixLabel, 0);
        lblPrefix.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text txtPrefix = toolkit.createText(body, null, 2048);
        txtPrefix.setToolTipText(CndMessages.namespacePrefixToolTip);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        txtPrefix.setLayoutData((Object)gd);
        if (this.isEditMode()) {
            txtPrefix.setText(this.namespaceBeingEdited.getPrefix());
        }
        txtPrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamespaceMappingDialog.this.handlePrefixChanged(((Text)e.widget).getText());
            }
        });
        txtPrefix.setFocus();
        Label lblUri = toolkit.createLabel(body, CndMessages.uriLabel, 0);
        lblUri.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.txtUri = toolkit.createText(body, null, 2048);
        this.txtUri.setToolTipText(CndMessages.namespaceUriToolTip);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        this.txtUri.setLayoutData((Object)gd2);
        if (this.isEditMode()) {
            this.txtUri.setText(this.namespaceBeingEdited.getUri());
        }
        this.txtUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamespaceMappingDialog.this.handleUriChanged(((Text)e.widget).getText());
            }
        });
        Label lblComment = toolkit.createLabel(body, CndMessages.commentLabel, 0);
        lblComment.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text txtComment = toolkit.createText(body, null, 2818);
        txtComment.setToolTipText(CndMessages.commentedToolTip);
        gd = new GridData(4, 4, true, true);
        gd.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        gd.heightHint = txtComment.getLineHeight() * 3;
        txtComment.setLayoutData((Object)gd);
        if (this.isEditMode() && !Utils.isEmpty((String)this.namespaceBeingEdited.getComment())) {
            txtComment.setText(CommentedCndElement.Helper.removeCommentCharacters((String)this.namespaceBeingEdited.getComment()));
        }
        txtComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NamespaceMappingDialog.this.handleCommentChanged(((Text)e.widget).getText());
            }
        });
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.scrolledForm, JcrUiConstants.HelpContexts.NAMESPACE_EDITOR_HELP_CONTEXT);
    }

    public NamespaceMapping getNamespaceMapping() {
        NamespaceMapping namespaceMapping = new NamespaceMapping(this.prefix, this.uri);
        namespaceMapping.setComment(this.comment);
        return namespaceMapping;
    }

    void handleCommentChanged(String newComment) {
        this.comment = newComment;
        this.updateState();
    }

    void handlePrefixChanged(String newPrefix) {
        this.prefix = newPrefix;
        try {
            if (!Utils.isEmpty((String)this.prefix)) {
                if (!Utils.isEmpty((String)this.saveUri) && WorkspaceRegistry.get().getUri(this.prefix) == null) {
                    this.txtUri.setText(this.saveUri);
                    this.saveUri = "";
                } else {
                    this.saveUri = this.txtUri.getText();
                    this.txtUri.setText(UiUtils.ensureNotNull((String)WorkspaceRegistry.get().getUri(this.prefix)));
                }
            }
        }
        catch (Exception e) {
            Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, null, (Throwable)e));
        }
        this.updateState();
    }

    void handleUriChanged(String newUri) {
        this.uri = newUri;
        this.updateState();
    }

    private boolean isEditMode() {
        return this.namespaceBeingEdited != null;
    }

    private void updateState() {
        NamespaceMapping currentNamespace = this.getNamespaceMapping();
        MultiValidationStatus status = CndValidator.validateNamespaceMapping((NamespaceMapping)currentNamespace, this.existingNamespaces);
        boolean enable = !status.isError();
        this.scrolledForm.setMessage("", 1);
        if (!enable) {
            this.scrolledForm.setMessage(status.getMessage(), 3);
            Point preferredSize = this.getShell().computeSize(-1, -1);
            if (preferredSize.x > this.getShell().getSize().x) {
                this.getShell().pack();
            }
        } else if (this.isEditMode() && currentNamespace.equals((Object)this.namespaceBeingEdited) || !this.isEditMode() && Utils.isEmpty((String)this.prefix) && Utils.isEmpty((String)this.uri)) {
            enable = false;
            this.scrolledForm.setMessage(CndMessages.namespaceDialogMsg, 0);
        } else {
            int severity = 0;
            String message = status.getMessage();
            if (status.isWarning()) {
                severity = 2;
            } else if (status.isInfo()) {
                severity = 1;
            } else {
                try {
                    message = WorkspaceRegistry.get().isBuiltIn(currentNamespace) ? CndMessages.acceptBuiltInNamespaceDialogMsg : CndMessages.acceptNamespaceDialogMsg;
                }
                catch (Exception exception) {
                    message = CndMessages.acceptNamespaceDialogMsg;
                }
            }
            this.scrolledForm.setMessage(message, severity);
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }
}

