/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessage;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;
import org.jboss.tools.modeshape.jcr.cnd.CndImporter;
import org.jboss.tools.modeshape.jcr.cnd.CompactNodeTypeDefinition;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceConstants;
import org.jboss.tools.modeshape.jcr.preference.JcrPreferenceStore;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndEditorPage;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndFormsEditorPage;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.ui.UiMessages;
import org.jboss.tools.modeshape.ui.forms.MessageFormDialog;
import org.jboss.tools.modeshape.ui.forms.MessageSummaryDialog;

public final class CndEditor
extends SharedHeaderFormEditor
implements IPersistableEditor,
IResourceChangeListener,
PropertyChangeListener {
    private CompactNodeTypeDefinition cndBeingEdited;
    private boolean dirty = false;
    private final FileDocumentProvider documentProvider = new FileDocumentProvider();
    private final CndEditorPage formsPage = new CndFormsEditorPage(this);
    private IMemento memento;
    private long modificationStamp = 0L;
    private CompactNodeTypeDefinition originalCnd;
    private boolean readOnly = false;
    private Listener refreshListener;
    private ScrolledForm scrolledForm;

    CndEditor accessThis() {
        return this;
    }

    protected void addPages() {
        try {
            int value;
            this.addPage(0, (IFormPage)this.formsPage);
            TextEditor sourceEditor = new TextEditor(){

                public boolean isEditable() {
                    return false;
                }
            };
            this.addPage(1, (IEditorPart)sourceEditor, this.getEditorInput());
            this.setPageText(this.getPageCount() - 1, CndMessages.cndEditorSourcePageTitle);
            this.refreshListener = new Listener(){

                public void handleEvent(Event event) {
                    CndEditor.this.refreshCnd();
                }
            };
            this.getContainer().addListener(26, this.refreshListener);
            int selectedPageNum = 0;
            if (this.memento != null && (value = this.memento.getInteger("SELECTED_PAGE").intValue()) != -1) {
                selectedPageNum = value;
            }
            this.setActivePage(selectedPageNum);
        }
        catch (PartInitException e) {
            throw new RuntimeException(CndMessages.errorOpeningCndEditor, e);
        }
    }

    private void createCnd() throws Exception {
        CndImporter importer = new CndImporter();
        ArrayList errors = new ArrayList();
        this.originalCnd = importer.importFrom(this.getFile().getContents(), errors, this.getFile().getName());
        if (!errors.isEmpty()) {
            Throwable t = (Throwable)errors.iterator().next();
            if (t.getCause() == null) {
                throw new RuntimeException(t);
            }
            throw new RuntimeException(t.getCause());
        }
        if (this.cndBeingEdited != null) {
            this.cndBeingEdited.removeListener((PropertyChangeListener)this);
        }
        this.cndBeingEdited = CompactNodeTypeDefinition.copy((CompactNodeTypeDefinition)this.originalCnd);
        this.cndBeingEdited.addListener((PropertyChangeListener)this);
        this.formsPage.handleCndReloaded();
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.scrolledForm = headerForm.getForm();
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setText(CndMessages.cndEditorTitle);
        Form form = this.scrolledForm.getForm();
        this.getToolkit().decorateFormHeading(form);
        form.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                CndEditor.this.handleDisplayMessageDialog((IMessage[])e.data);
            }
        });
        form.getToolBarManager().add((IContributionItem)new ControlContribution(null){

            protected Control createControl(Composite parent) {
                Hyperlink hlink = CndEditor.this.getToolkit().createHyperlink(parent, CndMessages.openCndEditorPreferencesHyperlink, 0);
                hlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        CndEditor.this.handleOpenCndPreferencesPage();
                    }
                });
                return hlink;
            }
        });
        form.getToolBarManager().update(true);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.internalSave(monitor);
    }

    public void doSaveAs() {
        IProgressMonitor progressMonitor = this.getProgressMonitor();
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        dialog.setOriginalFile(this.getFile());
        dialog.create();
        if (dialog.open() == 1) {
            if (progressMonitor != null) {
                progressMonitor.setCanceled(true);
            }
            return;
        }
        IPath filePath = dialog.getResult();
        if (!"cnd".equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension("cnd");
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile(filePath);
        try {
            ByteArrayInputStream emptyStream = new ByteArrayInputStream(new byte[0]);
            file.create((InputStream)emptyStream, true, progressMonitor);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.internalSave(progressMonitor);
        }
        catch (Exception e) {
            Object status = null;
            status = !(e instanceof CoreException) ? new Status(4, JcrUiConstants.PLUGIN_ID, e.getLocalizedMessage()) : ((CoreException)((Object)e)).getStatus();
            ErrorDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (String)CndMessages.cndEditorSaveError, (IStatus)status);
        }
    }

    CompactNodeTypeDefinition getCnd() {
        return this.cndBeingEdited;
    }

    protected IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    IMessageManager getMessageManager() {
        return this.scrolledForm.getMessageManager();
    }

    private CndElement.NotationType getNotationTypePreference() {
        String notationTypeString = JcrPreferenceStore.get().get((JcrPreferenceConstants.Preference)JcrPreferenceConstants.CndPreference.NOTATION_TYPE);
        return CndElement.NotationType.valueOf((String)notationTypeString);
    }

    private IProgressMonitor getProgressMonitor() {
        IStatusLineManager statusLineMgr = this.getEditorSite().getActionBars().getStatusLineManager();
        return statusLineMgr == null ? null : statusLineMgr.getProgressMonitor();
    }

    Shell getShell() {
        return this.getEditorSite().getShell();
    }

    void handleDisplayMessageDialog(IMessage[] data) {
        Object message;
        int numErrors = 0;
        int numWarnings = 0;
        int numInfos = 0;
        int messageType = 3;
        IMessage[] iMessageArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            message = iMessageArray[n2];
            if (message.getMessageType() == 3) {
                ++numErrors;
            } else if (message.getMessageType() == 2) {
                ++numWarnings;
            } else if (message.getMessageType() == 1) {
                ++numInfos;
            }
            ++n2;
        }
        if (numErrors == 0) {
            messageType = numWarnings != 0 ? 2 : (numInfos != 0 ? 1 : 0);
        }
        message = NLS.bind((String)CndMessages.cndMessageDialogMessageAreaMessage, (Object[])new Object[]{this.getFile().getName(), numErrors, numWarnings, numInfos});
        MessageSummaryDialog dialog = new MessageSummaryDialog(this.getShell(), CndMessages.cndMessageDialogTitle, CndMessages.cndMessageDialogMessageAreaTitle, (String)message, messageType, data);
        dialog.create();
        dialog.getShell().pack();
        dialog.open();
    }

    void handleOpenCndPreferencesPage() {
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.jboss.tools.modeshape.jcr.ui.jcrPreferencePage", (String[])new String[]{"org.jboss.tools.modeshape.jcr.ui.jcrPreferencePage"}, null).open();
    }

    private void hookRefreshListener() {
        this.getContainer().addListener(26, this.refreshListener);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        assert (input instanceof IFileEditorInput) : "MED Editor input is not a file";
        try {
            this.createCnd();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            JcrPreferenceStore.get();
        }
        catch (Exception e) {
            throw new PartInitException(CndMessages.errorOpeningCndEditor, (Throwable)e);
        }
    }

    private void internalSave(IProgressMonitor progressMonitor) {
        IEditorInput input = this.getEditorInput();
        try {
            try {
                this.saveDocument(input, progressMonitor);
                this.createCnd();
            }
            catch (Exception e) {
                Object status = null;
                status = !(e instanceof CoreException) ? new Status(4, JcrUiConstants.PLUGIN_ID, e.getLocalizedMessage()) : ((CoreException)((Object)e)).getStatus();
                if (status == null || status.getSeverity() != 8) {
                    ErrorDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (String)CndMessages.cndEditorSaveError, (IStatus)status);
                }
                this.documentProvider.changed((Object)input);
                this.refreshDirtyState();
            }
        }
        finally {
            this.documentProvider.changed((Object)input);
            this.refreshDirtyState();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    boolean isSynchronized() {
        long currentModifiedStamp = this.documentProvider.getModificationStamp((Object)this.getEditorInput());
        return this.modificationStamp == currentModifiedStamp;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.refreshDirtyState();
        this.formsPage.handlePropertyChanged(e);
    }

    void refreshCnd() {
        if (!this.isSynchronized()) {
            this.unhookRefreshListener();
            if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.cndChangedOnFileSystemDialogTitle, (Image)Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"), (String)NLS.bind((String)CndMessages.cndChangedOnFileSystemDialogMsg, (Object)this.getFile().getName()))) {
                try {
                    this.getFile().refreshLocal(1, null);
                    this.modificationStamp = this.documentProvider.getModificationStamp((Object)this.getEditorInput());
                    this.createCnd();
                }
                catch (Exception e) {
                    Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, null, (Throwable)e));
                    MessageFormDialog.openError((Shell)this.getShell(), (String)CndMessages.cndEditorRefreshErrorTitle, (Image)Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"), (String)CndMessages.cndEditorRefreshErrorMsg);
                }
            }
            this.hookRefreshListener();
        }
        this.refreshReadOnlyState();
    }

    protected void refreshDirtyState() {
        boolean newValue;
        boolean bl = newValue = !this.originalCnd.equals((Object)this.cndBeingEdited);
        if (this.isDirty() != newValue) {
            this.dirty = newValue;
            this.getHeaderForm().dirtyStateChanged();
        }
    }

    private void refreshReadOnlyState() {
        boolean newValue;
        ResourceAttributes attributes = this.getFile().getResourceAttributes();
        boolean bl = newValue = attributes == null ? true : attributes.isReadOnly();
        if (this.isReadOnly() != newValue) {
            this.readOnly = newValue;
            this.formsPage.setResourceReadOnly(this.readOnly);
            this.formsPage.getManagedForm().refresh();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 1) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().equals((Object)CndEditor.this.getFile())) {
                            if ((delta.getKind() & 2) != 0) {
                                if (!CndEditor.this.getShell().isDisposed()) {
                                    CndEditor.this.getShell().getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            CndEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)CndEditor.this.accessThis(), false);
                                        }
                                    });
                                }
                            } else if (delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0 && !CndEditor.this.getShell().isDisposed()) {
                                CndEditor.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        CndEditor.this.refreshCnd();
                                    }
                                });
                            }
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                Activator.getSharedInstance().getLog().log((IStatus)new Status(4, JcrUiConstants.PLUGIN_ID, null, (Throwable)e));
            }
        }
    }

    public void restoreState(IMemento memento) {
        this.memento = memento;
        this.formsPage.restoreState(this.memento);
    }

    private void saveDocument(IEditorInput input, IProgressMonitor progressMonitor) throws Exception {
        IDocument document = this.documentProvider.getDocument((Object)input);
        document.set(this.getCnd().toCndNotation(this.getNotationTypePreference()));
        this.documentProvider.aboutToChange((Object)input);
        this.documentProvider.saveDocument(progressMonitor, (Object)input, document, true);
        this.modificationStamp = this.documentProvider.getModificationStamp((Object)input);
    }

    public void saveState(IMemento memento) {
        int selectedPageNum = this.getActivePage();
        memento.putInteger("SELECTED_PAGE", selectedPageNum);
        this.formsPage.saveState(memento);
    }

    public void setFocus() {
        super.setFocus();
        this.refreshCnd();
    }

    protected void setInput(IEditorInput input) {
        if (this.getEditorInput() != null) {
            this.documentProvider.disconnect((Object)this.getEditorInput());
        }
        if (input instanceof IFileEditorInput) {
            super.setInput(input);
            try {
                this.documentProvider.connect((Object)input);
                this.modificationStamp = this.documentProvider.getModificationStamp((Object)input);
                IAnnotationModel model = this.documentProvider.getAnnotationModel((Object)input);
                model.connect(this.documentProvider.getDocument((Object)input));
                this.setPartName(this.getEditorInput().getName());
            }
            catch (Exception e) {
                throw new RuntimeException(CndMessages.errorOpeningCndEditor, e);
            }
        } else {
            throw new RuntimeException(CndMessages.cndEditorInputNotAFile);
        }
    }

    private void unhookRefreshListener() {
        if (!this.getContainer().isDisposed()) {
            this.getContainer().removeListener(26, this.refreshListener);
        }
    }

    private static interface MementoKeys {
        public static final String SELECTED_PAGE = "SELECTED_PAGE";
    }
}

