/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.ui.cnd;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.jboss.tools.modeshape.jcr.ChildNodeDefinition;
import org.jboss.tools.modeshape.jcr.ItemOwnerProvider;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.QualifiedName;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.ValidationStatus;
import org.jboss.tools.modeshape.jcr.attributes.OnParentVersion;
import org.jboss.tools.modeshape.jcr.cnd.CndValidator;
import org.jboss.tools.modeshape.jcr.cnd.CommentedCndElement;
import org.jboss.tools.modeshape.jcr.ui.Activator;
import org.jboss.tools.modeshape.jcr.ui.JcrUiConstants;
import org.jboss.tools.modeshape.jcr.ui.JcrUiUtils;
import org.jboss.tools.modeshape.jcr.ui.cnd.CndMessages;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameDialog;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameEditor;
import org.jboss.tools.modeshape.jcr.ui.cnd.QualifiedNameProposalProvider;
import org.jboss.tools.modeshape.ui.UiMessages;
import org.jboss.tools.modeshape.ui.UiUtils;
import org.jboss.tools.modeshape.ui.actions.DelegateAction;
import org.jboss.tools.modeshape.ui.forms.ErrorMessage;
import org.jboss.tools.modeshape.ui.forms.FormUtils;
import org.jboss.tools.modeshape.ui.forms.MessageFormDialog;

final class ChildNodeDialog
extends FormDialog {
    private IAction addRequiredType;
    private Button btnOk;
    private CCombo cbxDefaultType;
    private ChildNodeDefinition childNodeBeingEdited;
    private final ErrorMessage defaultTypeError;
    private IAction deleteRequiredType;
    private IAction editRequiredType;
    private final Collection<QualifiedName> existingChildNodeNames;
    private final Collection<String> existingNamespacePrefixes;
    private QualifiedNameEditor nameEditor;
    private final ErrorMessage nameError;
    private ChildNodeDefinition originalChildNode;
    private QualifiedNameProposalProvider requiredTypeProposalProvider;
    private final ErrorMessage requiredTypesError;
    private TableViewer requiredTypesViewer;
    private ScrolledForm scrolledForm;

    public ChildNodeDialog(Shell parentShell, ItemOwnerProvider ownerProvider, Collection<QualifiedName> existingChildNodeNames, Collection<String> existingNamespacePrefixes) {
        super(parentShell);
        Utils.verifyIsNotNull((Object)ownerProvider, (String)"ownerProvider");
        this.existingChildNodeNames = existingChildNodeNames == null ? Collections.emptyList() : new ArrayList<QualifiedName>(existingChildNodeNames);
        this.existingNamespacePrefixes = existingNamespacePrefixes == null ? Collections.emptyList() : new ArrayList<String>(existingNamespacePrefixes);
        this.nameError = new ErrorMessage();
        this.defaultTypeError = new ErrorMessage();
        this.requiredTypesError = new ErrorMessage();
        this.childNodeBeingEdited = new ChildNodeDefinition(ownerProvider);
    }

    public ChildNodeDialog(Shell parentShell, ItemOwnerProvider ownerProvider, Collection<QualifiedName> existingChildNodeNames, Collection<String> existingNamespacePrefixes, ChildNodeDefinition childNodeBeingEdited) {
        this(parentShell, ownerProvider, existingChildNodeNames, existingNamespacePrefixes);
        Utils.verifyIsNotNull((Object)childNodeBeingEdited, (String)"childNodeBeingEdited");
        this.originalChildNode = childNodeBeingEdited;
        this.childNodeBeingEdited = ChildNodeDefinition.copy((ChildNodeDefinition)this.originalChildNode, (ItemOwnerProvider)ownerProvider);
        if (!Utils.isEmpty((String)this.childNodeBeingEdited.getName())) {
            this.existingChildNodeNames.remove(this.childNodeBeingEdited.getQualifiedName());
        }
    }

    ChildNodeDefinition accessModel() {
        return this.childNodeBeingEdited;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CndMessages.childNodeDialogTitle);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected void createFormContent(IManagedForm managedForm) {
        String currentOpv;
        int index;
        this.scrolledForm = managedForm.getForm();
        this.scrolledForm.setText(this.isEditMode() ? CndMessages.childNodeDialogEditTitle : CndMessages.childNodeDialogCreateTitle);
        this.scrolledForm.setImage(Activator.getSharedInstance().getImage("icons/cnd-editor-16x.png"));
        this.scrolledForm.setMessage(CndMessages.childNodeDialogMsg, 0);
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(this.scrolledForm.getForm());
        Composite body = this.scrolledForm.getBody();
        body.setLayout((Layout)new GridLayout(2, false));
        Composite leftContainer = toolkit.createComposite(body);
        leftContainer.setLayout((Layout)new GridLayout(2, false));
        leftContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        toolkit.paintBordersFor(leftContainer);
        this.nameEditor = new QualifiedNameEditor(leftContainer, 0, toolkit, Messages.childNodeDefinitionName, this.existingNamespacePrefixes, this.childNodeBeingEdited.getQualifiedName());
        ((GridData)this.nameEditor.getLayoutData()).horizontalSpan = 2;
        this.nameEditor.setAllowsResidualName(true);
        this.nameEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ChildNodeDialog.this.handleNameChanged(e.text);
            }
        });
        this.nameError.setControl((Control)this.nameEditor);
        Composite defaultTypeContainer = toolkit.createComposite(leftContainer);
        defaultTypeContainer.setLayout((Layout)new GridLayout(2, false));
        defaultTypeContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)defaultTypeContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(defaultTypeContainer);
        Label lblDefaultType = toolkit.createLabel(defaultTypeContainer, CndMessages.childNodeDefaultTypeLabel, 0);
        lblDefaultType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.cbxDefaultType = new CCombo(defaultTypeContainer, 0x800808);
        this.cbxDefaultType.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.cbxDefaultType.getLayoutData()).heightHint = this.cbxDefaultType.getItemHeight() + 4;
        this.cbxDefaultType.setToolTipText(CndMessages.childNodeDefaultTypeToolTip);
        toolkit.adapt((Control)this.cbxDefaultType, true, false);
        this.cbxDefaultType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newDefaultType = ((CCombo)e.widget).getText();
                if (CndMessages.notAssignedItemChoice.equals(newDefaultType)) {
                    newDefaultType = "";
                }
                ChildNodeDialog.this.handleDefaultTypeChanged(newDefaultType);
            }
        });
        this.refreshDefaultTypes();
        this.defaultTypeError.setControl((Control)this.cbxDefaultType);
        Group attributesContainer = new Group(leftContainer, 32);
        attributesContainer.setText(CndMessages.attributesHeaderText);
        attributesContainer.setLayout((Layout)new GridLayout(2, true));
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalSpan = 2;
        attributesContainer.setLayoutData((Object)gd);
        toolkit.adapt((Composite)attributesContainer);
        toolkit.paintBordersFor((Composite)attributesContainer);
        Button btnAutocreated = toolkit.createButton((Composite)attributesContainer, CndMessages.autocreatedAttribute, 32);
        btnAutocreated.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.childNodeBeingEdited.isAutoCreated()) {
            btnAutocreated.setSelection(true);
        }
        btnAutocreated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildNodeDialog.this.handleAutocreatedChanged(((Button)e.widget).getSelection());
            }
        });
        btnAutocreated.setToolTipText(CndMessages.autocreatedAttributeToolTip);
        Button btnMandatory = toolkit.createButton((Composite)attributesContainer, CndMessages.mandatoryAttribute, 32);
        btnMandatory.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.childNodeBeingEdited.isMandatory()) {
            btnMandatory.setSelection(true);
        }
        btnMandatory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildNodeDialog.this.handleMandatoryChanged(((Button)e.widget).getSelection());
            }
        });
        btnMandatory.setToolTipText(CndMessages.mandatoryAttributeToolTip);
        Button btnProtected = toolkit.createButton((Composite)attributesContainer, CndMessages.protectedAttribute, 32);
        btnProtected.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.childNodeBeingEdited.isProtected()) {
            btnProtected.setSelection(true);
        }
        btnProtected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildNodeDialog.this.handleProtectedChanged(((Button)e.widget).getSelection());
            }
        });
        btnProtected.setToolTipText(CndMessages.protectedAttributeToolTip);
        Button btnSameNamedSiblings = toolkit.createButton((Composite)attributesContainer, CndMessages.sameNamedSiblingsAttribute, 32);
        btnSameNamedSiblings.setBackground(attributesContainer.getBackground());
        if (this.isEditMode() && this.childNodeBeingEdited.allowsSameNameSiblings()) {
            btnSameNamedSiblings.setSelection(true);
        }
        btnSameNamedSiblings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChildNodeDialog.this.handleSameNamedSiblingsChanged(((Button)e.widget).getSelection());
            }
        });
        btnSameNamedSiblings.setToolTipText(CndMessages.sameNamedSiblingsAttributeToolTip);
        Composite opvContainer = toolkit.createComposite((Composite)attributesContainer);
        opvContainer.setLayout((Layout)new GridLayout(2, false));
        GridData gdOpv = new GridData(4, 0x1000000, true, false);
        gdOpv.horizontalSpan = 2;
        opvContainer.setLayoutData((Object)gdOpv);
        toolkit.paintBordersFor(opvContainer);
        Label lblOpv = toolkit.createLabel(opvContainer, CndMessages.onParentVersionLabel, 0);
        lblOpv.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        CCombo cbxOpvs = new CCombo(opvContainer, 0x800808);
        toolkit.adapt((Control)cbxOpvs, true, false);
        cbxOpvs.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ((GridData)cbxOpvs.getLayoutData()).heightHint = cbxOpvs.getItemHeight() + 4;
        cbxOpvs.setToolTipText(CndMessages.onParentVersionToolTip);
        OnParentVersion[] onParentVersionArray = OnParentVersion.values();
        int n = onParentVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnParentVersion opv = onParentVersionArray[n2];
            if (opv != OnParentVersion.VARIANT) {
                cbxOpvs.add(opv.toString());
            }
            ++n2;
        }
        if (this.isEditMode() && (index = cbxOpvs.indexOf(currentOpv = OnParentVersion.findUsingJcrValue((int)this.childNodeBeingEdited.getOnParentVersion()).toString())) != -1) {
            cbxOpvs.select(index);
        }
        cbxOpvs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newOpv = ((CCombo)e.widget).getText();
                ChildNodeDialog.this.handleOnParentVersionChanged(newOpv);
            }
        });
        Composite rightContainer = toolkit.createComposite(body);
        rightContainer.setLayout((Layout)new GridLayout(2, false));
        rightContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.paintBordersFor(rightContainer);
        Label label = toolkit.createLabel(rightContainer, CndMessages.requiredTypesLabel);
        label.setLayoutData((Object)new GridData(1, 128, false, false));
        this.createRequiredTypesActions();
        ToolBarManager toolBarManager = new ToolBarManager(0x800100);
        ToolBar toolBar = toolBarManager.createControl(rightContainer);
        toolkit.adapt((Composite)toolBar);
        Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolBar.setCursor(handCursor);
        toolBarManager.add(this.addRequiredType);
        toolBarManager.add(this.editRequiredType);
        toolBarManager.add(this.deleteRequiredType);
        toolBarManager.update(true);
        Table table = FormUtils.createTable((FormToolkit)toolkit, (Composite)rightContainer);
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        GridData gd2 = (GridData)table.getLayoutData();
        gd2.horizontalSpan = 2;
        gd2.heightHint = table.getItemHeight() * 4;
        gd2.widthHint = UiUtils.convertWidthInCharsToPixels((Control)table, (int)40);
        this.requiredTypesError.setControl((Control)table);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new DelegateAction(CndMessages.addRequiredTypeMenuText, this.addRequiredType));
        menuManager.add((IAction)new DelegateAction(CndMessages.editRequiredTypeMenuText, this.editRequiredType));
        menuManager.add((IAction)new DelegateAction(CndMessages.deleteRequiredTypeMenuText, this.deleteRequiredType));
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.createRequiredTypesViewer(table);
        this.requiredTypesViewer.setInput((Object)this);
        Composite commentsContainer = toolkit.createComposite(body);
        commentsContainer.setLayout((Layout)new GridLayout(2, false));
        commentsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)commentsContainer.getLayoutData()).horizontalSpan = 2;
        toolkit.paintBordersFor(commentsContainer);
        Label lblComment = toolkit.createLabel(commentsContainer, CndMessages.commentLabel, 0);
        lblComment.setLayoutData((Object)new GridData(16384, 128, false, false));
        Text txtComment = toolkit.createText(commentsContainer, null, 2818);
        txtComment.setToolTipText(CndMessages.commentedToolTip);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.verticalIndent += ((GridLayout)body.getLayout()).verticalSpacing;
        gd3.heightHint = txtComment.getLineHeight() * 3;
        gd3.widthHint = UiUtils.convertWidthInCharsToPixels((Control)txtComment, (int)80);
        txtComment.setLayoutData((Object)gd3);
        if (this.isEditMode() && !Utils.isEmpty((String)this.childNodeBeingEdited.getComment())) {
            txtComment.setText(CommentedCndElement.Helper.removeCommentCharacters((String)this.childNodeBeingEdited.getComment()));
        }
        txtComment.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChildNodeDialog.this.handleCommentChanged(((Text)e.widget).getText());
            }
        });
        this.childNodeBeingEdited.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ChildNodeDialog.this.handlePropertyChanged(e);
            }
        });
        this.validateAttributes();
        this.validateDefaultType();
        this.validateName();
        this.validateRequiredTypes();
        IWorkbenchHelpSystem helpSystem = Activator.getSharedInstance().getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)this.scrolledForm, JcrUiConstants.HelpContexts.CHILD_NODE_EDITOR_HELP_CONTEXT);
    }

    void createRequiredTypesActions() {
        this.addRequiredType = new Action(""){

            public void run() {
                ChildNodeDialog.this.handleAddRequiredType();
            }
        };
        this.addRequiredType.setToolTipText(CndMessages.addRequiredTypeToolTip);
        this.addRequiredType.setImageDescriptor(JcrUiUtils.getNewImageDescriptor());
        this.deleteRequiredType = new Action(""){

            public void run() {
                ChildNodeDialog.this.handleDeleteRequiredType();
            }
        };
        this.deleteRequiredType.setEnabled(false);
        this.deleteRequiredType.setToolTipText(CndMessages.deleteRequiredTypeToolTip);
        this.deleteRequiredType.setImageDescriptor(JcrUiUtils.getDeleteImageDescriptor());
        this.editRequiredType = new Action(""){

            public void run() {
                ChildNodeDialog.this.handleEditRequiredType();
            }
        };
        this.editRequiredType.setEnabled(false);
        this.editRequiredType.setToolTipText(CndMessages.editRequiredTypeToolTip);
        this.editRequiredType.setImageDescriptor(JcrUiUtils.getEditImageDescriptor());
    }

    private void createRequiredTypesViewer(Table requiredTypesTable) {
        this.requiredTypesViewer = new TableViewer(requiredTypesTable);
        this.requiredTypesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.requiredTypesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ChildNodeDefinition childNode = ChildNodeDialog.this.accessModel();
                Object[] requiredTypes = childNode.getRequiredPrimaryTypeNames();
                if (requiredTypes == null) {
                    return Utils.EMPTY_OBJECT_ARRAY;
                }
                return requiredTypes;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.requiredTypesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ChildNodeDialog.this.handleEditRequiredType();
            }
        });
        this.requiredTypesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChildNodeDialog.this.handleRequiredTypeSelected();
            }
        });
    }

    public ChildNodeDefinition getChildNodeDefinition() {
        return this.childNodeBeingEdited;
    }

    private String getSelectedRequiredType() {
        IStructuredSelection selection = (IStructuredSelection)this.requiredTypesViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        assert (selection.size() == 1) : "required types viewer should not allow multiple selections";
        assert (selection.getFirstElement() instanceof String) : "selection was not a string";
        return (String)selection.getFirstElement();
    }

    void handleAddRequiredType() {
        QualifiedName newQName;
        QualifiedNameDialog dialog = new QualifiedNameDialog(this.getShell(), CndMessages.newRequiredTypeDialogTitle, Messages.requiredTypeName, this.existingNamespacePrefixes);
        dialog.setExistingQNames(this.childNodeBeingEdited.getRequiredTypes());
        dialog.setProposalProvider(this.requiredTypeProposalProvider);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0 && !this.childNodeBeingEdited.addRequiredType((newQName = dialog.getQualifiedName()).get())) {
            MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorAddingRequiredType, (Object)newQName));
        }
    }

    void handleAutocreatedChanged(boolean newAutocreated) {
        this.childNodeBeingEdited.setAutoCreated(newAutocreated);
    }

    void handleCommentChanged(String newComment) {
        this.childNodeBeingEdited.setComment(newComment);
    }

    void handleDefaultTypeChanged(String newDefaultType) {
        this.childNodeBeingEdited.setDefaultPrimaryTypeName(newDefaultType);
    }

    void handleDeleteRequiredType() {
        assert (this.getSelectedRequiredType() != null) : "Delete required type handler called and there is no required type selected";
        String requiredTypeName = this.getSelectedRequiredType();
        if (Utils.isEmpty((String)requiredTypeName)) {
            requiredTypeName = Messages.missingName;
        }
        if (MessageFormDialog.openQuestion((Shell)this.getShell(), (String)CndMessages.deleteRequiredTypeDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.deleteRequiredTypeDialogMessage, (Object)requiredTypeName))) {
            this.childNodeBeingEdited.removeRequiredType(requiredTypeName);
        }
    }

    void handleEditRequiredType() {
        assert (this.getSelectedRequiredType() != null) : "Edit required type handler has been called when there is no required type selected";
        String selectedRequiredType = this.getSelectedRequiredType();
        QualifiedNameDialog dialog = new QualifiedNameDialog(this.getShell(), CndMessages.editRequiredTypeDialogTitle, Messages.requiredTypeName, this.existingNamespacePrefixes, QualifiedName.parse((String)selectedRequiredType));
        dialog.setExistingQNames(this.childNodeBeingEdited.getRequiredTypes());
        dialog.setProposalProvider(this.requiredTypeProposalProvider);
        dialog.create();
        dialog.getShell().pack();
        if (dialog.open() == 0) {
            QualifiedName modifiedRequiredType = dialog.getQualifiedName();
            boolean removed = false;
            boolean added = false;
            if (this.childNodeBeingEdited.removeRequiredType(selectedRequiredType)) {
                removed = true;
                if (this.childNodeBeingEdited.addRequiredType(modifiedRequiredType.get())) {
                    added = true;
                }
            }
            if (!removed || !added) {
                MessageFormDialog.openError((Shell)this.getShell(), (String)UiMessages.errorDialogTitle, (Image)JcrUiUtils.getCndEditorImage(), (String)NLS.bind((String)CndMessages.errorEditingRequiredType, (Object[])new Object[]{modifiedRequiredType, removed, added}));
            }
        }
    }

    void handleMandatoryChanged(boolean newMandatory) {
        this.childNodeBeingEdited.setMandatory(newMandatory);
    }

    void handleNameChanged(String newName) {
        this.childNodeBeingEdited.setName(newName);
    }

    void handleOnParentVersionChanged(String newOpv) {
        this.childNodeBeingEdited.setOnParentVersion(newOpv);
    }

    void handlePropertyChanged(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (ChildNodeDefinition.PropertyName.AUTOCREATED.toString().equals(propName) || ChildNodeDefinition.PropertyName.MANDATORY.toString().equals(propName) || ChildNodeDefinition.PropertyName.PROTECTED.toString().equals(propName) || ChildNodeDefinition.PropertyName.SAME_NAME_SIBLINGS.toString().equals(propName) || ChildNodeDefinition.PropertyName.ON_PARENT_VERSION.toString().equals(propName)) {
            this.validateAttributes();
        } else if (ChildNodeDefinition.PropertyName.DEFAULT_TYPE.toString().equals(propName)) {
            this.validateDefaultType();
        } else if (ChildNodeDefinition.PropertyName.NAME.toString().equals(propName)) {
            this.validateName();
        } else if (ChildNodeDefinition.PropertyName.REQUIRED_TYPES.toString().equals(propName)) {
            this.validateRequiredTypes();
            this.requiredTypesViewer.refresh();
            this.validateDefaultType();
        }
        this.updateState();
    }

    void handleProtectedChanged(boolean newProtected) {
        this.childNodeBeingEdited.setProtected(newProtected);
    }

    void handleRequiredTypeSelected() {
        boolean enable;
        boolean bl = enable = this.getSelectedRequiredType() != null;
        if (this.editRequiredType.isEnabled() != enable) {
            this.editRequiredType.setEnabled(enable);
        }
        if (this.deleteRequiredType.isEnabled() != enable) {
            this.deleteRequiredType.setEnabled(enable);
        }
    }

    void handleSameNamedSiblingsChanged(boolean newSns) {
        this.childNodeBeingEdited.setSameNameSiblings(newSns);
    }

    private boolean isEditMode() {
        return this.originalChildNode != null;
    }

    private void refreshDefaultTypes() {
        String defaultTypeName;
        String[] temp = this.childNodeBeingEdited.getRequiredPrimaryTypeNames();
        String[] currentRequiredTypes = new String[temp.length + 1];
        currentRequiredTypes[0] = CndMessages.notAssignedItemChoice;
        if (temp.length != 0) {
            System.arraycopy(temp, 0, currentRequiredTypes, 1, temp.length);
        }
        if (this.cbxDefaultType.getItemCount() != currentRequiredTypes.length || !Arrays.asList(currentRequiredTypes).containsAll(Arrays.asList(this.cbxDefaultType.getItems()))) {
            this.cbxDefaultType.setItems(currentRequiredTypes);
        }
        if (Utils.isEmpty((String)(defaultTypeName = this.childNodeBeingEdited.getDefaultPrimaryTypeName()))) {
            this.cbxDefaultType.select(0);
        } else {
            int index = this.cbxDefaultType.indexOf(defaultTypeName);
            if (index == -1) {
                this.cbxDefaultType.add(defaultTypeName);
                this.cbxDefaultType.select(this.cbxDefaultType.getItemCount() - 1);
            } else {
                this.cbxDefaultType.select(index);
            }
        }
    }

    public void setRequiredTypeProposalProvider(QualifiedNameProposalProvider proposalProvider) {
        this.requiredTypeProposalProvider = proposalProvider;
    }

    private void updateMessage(ValidationStatus status, ErrorMessage errorMsg) {
        JcrUiUtils.setMessage(status, errorMsg);
        if (errorMsg.isOk()) {
            this.scrolledForm.getMessageManager().removeMessage(errorMsg.getKey(), errorMsg.getControl());
        } else {
            this.scrolledForm.getMessageManager().addMessage(errorMsg.getKey(), errorMsg.getMessage(), null, errorMsg.getMessageType(), errorMsg.getControl());
        }
    }

    private void updateState() {
        boolean enable;
        int messageType = this.scrolledForm.getMessageType();
        boolean bl = enable = messageType != 3;
        if (enable && this.isEditMode() && this.originalChildNode.equals((Object)this.childNodeBeingEdited)) {
            enable = false;
        }
        if (this.btnOk.getEnabled() != enable) {
            this.btnOk.setEnabled(enable);
        }
    }

    private void validateAttributes() {
    }

    private void validateDefaultType() {
        this.updateMessage((ValidationStatus)CndValidator.validateDefaultType((ChildNodeDefinition)this.childNodeBeingEdited, this.existingNamespacePrefixes), this.defaultTypeError);
    }

    private void validateName() {
        this.updateMessage(this.nameEditor.getStatus(), this.nameError);
    }

    private void validateRequiredTypes() {
        this.updateMessage((ValidationStatus)CndValidator.validateRequiredTypes((ChildNodeDefinition)this.childNodeBeingEdited, this.existingNamespacePrefixes), this.requiredTypesError);
    }
}

