/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.branding.wizards.project.AbstractCreateProjectJob;
import org.fusesource.ide.branding.wizards.project.AbstractFuseProjectWizard;
import org.fusesource.ide.branding.wizards.project.ArchetypeDetails;
import org.fusesource.ide.branding.wizards.project.FuseProjectWizardArchetypePage;
import org.fusesource.ide.branding.wizards.project.FuseProjectWizardLocationPage;
import org.fusesource.ide.branding.wizards.project.SelectionUtil;
import org.fusesource.ide.maven.MavenFacade;

public class FuseProjectWizard
extends AbstractFuseProjectWizard
implements INewWizard {
    protected FuseProjectWizardLocationPage locationPage;
    private FuseProjectWizardArchetypePage archetypePage;

    public FuseProjectWizard() {
        this.setWindowTitle(WizardMessages.wizardProjectTitle);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_fuse_project_wizard.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.locationPage = new FuseProjectWizardLocationPage(WizardMessages.wizardProjectPageProjectTitle, WizardMessages.wizardProjectPageProjectDescription, this.workingSets){

            protected void createAdditionalControls(Composite container) {
                Label label = new Label(container, 0);
                GridData labelData = new GridData(4, 128, false, false, 3, 1);
                labelData.heightHint = 10;
                label.setLayoutData((Object)labelData);
            }

            public IWizardPage getNextPage() {
                return FuseProjectWizard.this.getPage("MavenProjectWizardArchetypePage");
            }
        };
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation(this.selection));
        this.archetypePage = new FuseProjectWizardArchetypePage();
        this.addPage((IWizardPage)this.locationPage);
        this.addPage((IWizardPage)this.archetypePage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }

    public boolean performFinish() {
        final String projectName = this.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = this.locationPage.isInWorkspace() ? null : this.locationPage.getLocationPath();
        final IWorkspaceRoot root = workspace.getRoot();
        final IPath rootPath = this.locationPage.isInWorkspace() ? root.getLocation().append(projectName) : location;
        final File pomFile = rootPath.append("pom.xml").toFile();
        boolean pomExists = pomFile.exists();
        if (pomExists) {
            MessageDialog.openError((Shell)this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)WizardMessages.wizardProjectErrorPomAlreadyExists);
            return false;
        }
        final String groupId = this.archetypePage.getGroupId();
        final String artifactId = this.archetypePage.getArtifactId();
        final String version = this.archetypePage.getVersion();
        final ArchetypeDetails archetype = this.archetypePage.getArchetype();
        final String javaPackage = this.archetypePage.getJavaPackage();
        this.archetypePage.getProperties();
        Activator.getLogger().debug("About to create project: " + projectName + " from archetype: " + archetype + " for " + groupId + ": " + artifactId + ":" + version + " at " + rootPath);
        String jobName = NLS.bind((String)WizardMessages.wizardProjectJobCreating, (Object)projectName);
        AbstractCreateProjectJob job = new AbstractCreateProjectJob(jobName, this.workingSets){

            @Override
            protected List<IProject> doCreateMavenProjects(IProgressMonitor monitor) throws CoreException {
                try {
                    URL resource = archetype.getResource();
                    InputStream in = resource.openStream();
                    File outputDir = rootPath.toFile();
                    FuseProjectWizard.this.createProject(in, outputDir, groupId, artifactId, version, javaPackage);
                    IProject project = root.getProject(projectName);
                    MavenFacade facade = new MavenFacade();
                    facade.importProjects(monitor, pomFile, projectName, groupId, artifactId, version);
                    return Arrays.asList(project);
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.fusesource.ide.plugin.wizards", 0, NLS.bind((String)WizardMessages.failedToOpenArchetype, (Object)e.getMessage()), (Throwable)e);
                    throw new CoreException((IStatus)status);
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                final IStatus result = event.getResult();
                if (!result.isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)FuseProjectWizard.this.getShell(), (String)NLS.bind((String)WizardMessages.wizardProjectJobFailed, (Object)projectName), (String)result.getMessage());
                        }
                    });
                } else {
                    IProject project = root.getProject(projectName);
                    try {
                        FuseProjectWizard.this.enforceNatures(project, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ex) {
                        Activator.getLogger().error((Throwable)ex);
                    }
                }
            }
        });
        ISchedulingRule rule = ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        job.setRule(rule);
        job.schedule();
        return true;
    }

    private void enforceNatures(final IProject project, final IProgressMonitor monitor) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IProjectDescription projectDescription = project.getDescription();
                    String[] ids = projectDescription.getNatureIds();
                    boolean camelNatureFound = false;
                    boolean javaNatureFound = false;
                    String[] stringArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (id.equals("org.eclipse.jdt.core.javanature")) {
                            javaNatureFound = true;
                        } else if (id.equals("org.fusesource.ide.project.RiderProjectNature")) {
                            camelNatureFound = true;
                        }
                        ++n2;
                    }
                    int toAdd = 0;
                    if (!camelNatureFound) {
                        ++toAdd;
                    }
                    if (!javaNatureFound) {
                        ++toAdd;
                    }
                    String[] newIds = new String[ids.length + toAdd];
                    System.arraycopy(ids, 0, newIds, 0, ids.length);
                    if (!camelNatureFound && !javaNatureFound) {
                        newIds[ids.length] = "org.fusesource.ide.project.RiderProjectNature";
                        newIds[newIds.length - 1] = "org.eclipse.jdt.core.javanature";
                    } else if (!camelNatureFound) {
                        newIds[ids.length] = "org.fusesource.ide.project.RiderProjectNature";
                    } else if (!javaNatureFound) {
                        newIds[ids.length] = "org.eclipse.jdt.core.javanature";
                    }
                    projectDescription.setNatureIds(newIds);
                    project.setDescription(projectDescription, monitor);
                    IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
                    MavenPlugin.getMavenProjectRegistry();
                    MavenUpdateRequest request = new MavenUpdateRequest(false, true);
                    request.addPomFile(project.getFile("pom.xml"));
                    configurationManager.updateProjectConfiguration(request, monitor);
                }
                catch (CoreException ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
        });
    }

    public String getProjectName() {
        return this.locationPage != null ? this.locationPage.getProjectName() : null;
    }
}

