/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.JUnitWizard;
import org.eclipse.jdt.ui.text.java.ClasspathFixProcessor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.NewCamelTestWizardPageOne;
import org.fusesource.ide.branding.wizards.NewCamelTestWizardPageTwo;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.commons.contenttype.BlueprintXmlMatchingStrategy;
import org.fusesource.ide.commons.contenttype.XmlMatchingStrategySupport;

public class NewCamelTestWizard
extends JUnitWizard {
    private static final String CAMEL_GROUP_ID = "org.apache.camel";
    private static final String CAMEL_ARTIFACT_ID_WILDCARD = "camel-";
    private static final String CAMEL_TEST_ARTIFACT_ID = "camel-test";
    private static final String CAMEL_TEST_SCOPE = "test";
    private String camelVersion = null;
    private XmlMatchingStrategySupport blueprintXmlMatcher = new BlueprintXmlMatchingStrategy();
    private NewCamelTestWizardPageOne fPage1;
    private NewCamelTestWizardPageTwo fPage2;

    public NewCamelTestWizard() {
        this.setWindowTitle(WizardMessages.Wizard_title_new_testcase);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_camel_test_case_wizard.png"));
        this.initDialogSettings();
    }

    private IRunnableWithProgress addJUnitToClasspath(IJavaProject project, final IRunnableWithProgress runnable, boolean isJUnit4) {
        String typeToLookup = isJUnit4 ? "org.junit.*" : "junit.awtui.*";
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals = ClasspathFixProcessor.getContributedFixImportProposals((IJavaProject)project, (String)typeToLookup, null);
        String superClass = "org.apache.camel.test.junit4.*";
        ClasspathFixProcessor.ClasspathFixProposal[] fixProposals2 = ClasspathFixProcessor.getContributedFixImportProposals((IJavaProject)project, (String)superClass, null);
        ArrayList<ClasspathFixProcessor.ClasspathFixProposal> proposals = new ArrayList<ClasspathFixProcessor.ClasspathFixProposal>();
        proposals.addAll(Arrays.asList(fixProposals));
        proposals.addAll(Arrays.asList(fixProposals2));
        fixProposals = proposals.toArray(new ClasspathFixProcessor.ClasspathFixProposal[proposals.size()]);
        ClasspathFixSelectionDialog dialog = new ClasspathFixSelectionDialog(this.getShell(), isJUnit4, project, fixProposals);
        if (dialog.open() != 0) {
            throw new OperationCanceledException();
        }
        final ClasspathFixProcessor.ClasspathFixProposal fix = dialog.getSelectedClasspathFix();
        if (fix != null) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(WizardMessages.NewTestCaseCreationWizard_create_progress, 4);
                    try {
                        try {
                            Change change = fix.createChange((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            new PerformChangeOperation(change).run((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                        }
                        catch (OperationCanceledException operationCanceledException) {
                            throw new InterruptedException();
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
        }
        return runnable;
    }

    public void addPages() {
        super.addPages();
        this.fPage2 = new NewCamelTestWizardPageTwo();
        this.fPage1 = new NewCamelTestWizardPageOne(this, this.fPage2);
        this.addPage((IWizardPage)this.fPage1);
        this.addPage((IWizardPage)this.fPage2);
        this.fPage1.init(this.getSelection());
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JUnitPlugin.getImageDescriptor((String)"wizban/newtest_wiz.png"));
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(WizardMessages.NewTestCaseCreationWizard_create_progress, 2);
                NewCamelTestWizard.this.fPage1.superClassChanged();
                monitor.worked(1);
                try {
                    try {
                        NewCamelTestWizard.this.fPage1.createType(monitor);
                        monitor.worked(1);
                    }
                    catch (Exception ex) {
                        Activator.getLogger().error((Throwable)ex);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.finishPage(runnable);
        IJavaProject project = this.fPage1.getJavaProject();
        runnable = this.fPage1.getRunnable();
        try {
            runnable = this.addCamelTestToPomDeps(project, runnable);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.finishPage(runnable)) {
            IType newClass = this.fPage1.getCreatedType();
            if (newClass == null) {
                return false;
            }
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    public boolean isBlueprintFile(String filePath) {
        boolean isBlueprint = false;
        if (filePath != null && filePath.trim().length() > 0) {
            String rawPath = null;
            rawPath = filePath.startsWith("file:") ? filePath.substring(5) : filePath;
            Path f = new Path(rawPath);
            File nf = new File(f.toOSString());
            if (nf.exists() && nf.isFile()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(f.makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()));
                isBlueprint = this.blueprintXmlMatcher.matches(file);
            }
        }
        return isBlueprint;
    }

    private IRunnableWithProgress addCamelTestToPomDeps(final IJavaProject project, final IRunnableWithProgress runnable) throws Exception {
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        final File pomFile = new File(pomPath);
        final Model model = MavenPlugin.getMaven().readModel(pomFile);
        boolean hasCamelTestDep = false;
        List deps = model.getDependencies();
        for (Dependency dep : deps) {
            if (dep.getArtifactId().startsWith(CAMEL_ARTIFACT_ID_WILDCARD)) {
                this.camelVersion = dep.getVersion();
            }
            if (!dep.getArtifactId().equalsIgnoreCase(CAMEL_TEST_ARTIFACT_ID)) continue;
            hasCamelTestDep = true;
            break;
        }
        if (hasCamelTestDep) {
            return new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                }
            };
        }
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(WizardMessages.NewTestCaseCreationWizard_create_progress, 4);
                Dependency dep = new Dependency();
                dep.setGroupId(NewCamelTestWizard.CAMEL_GROUP_ID);
                dep.setArtifactId(NewCamelTestWizard.CAMEL_TEST_ARTIFACT_ID);
                dep.setVersion(NewCamelTestWizard.this.camelVersion);
                dep.setScope(NewCamelTestWizard.CAMEL_TEST_SCOPE);
                model.addDependency(dep);
                OutputStream os = null;
                try {
                    try {
                        os = new BufferedOutputStream(new FileOutputStream(pomFile));
                        MavenPlugin.getMaven().writeModel(model, os);
                        IFile pomIFile = project.getProject().getFile("pom.xml");
                        if (pomIFile != null) {
                            pomIFile.refreshLocal(2, monitor);
                        }
                        runnable.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    }
                    catch (Exception ex) {
                        Activator.getLogger().error((Throwable)ex);
                        try {
                            if (os != null) {
                                os.close();
                            }
                        }
                        catch (IOException e) {
                            Activator.getLogger().error((Throwable)e);
                        }
                        monitor.done();
                    }
                }
                finally {
                    try {
                        if (os != null) {
                            os.close();
                        }
                    }
                    catch (IOException e) {
                        Activator.getLogger().error((Throwable)e);
                    }
                    monitor.done();
                }
            }
        };
    }

    private static class ClasspathFixSelectionDialog
    extends MessageDialog
    implements SelectionListener,
    IDoubleClickListener {
        private static final String BUILD_PATH_BLOCK = "block_until_buildpath_applied";
        private static final String BUILD_PATH_PAGE_ID = "org.eclipse.jdt.ui.propertyPages.BuildPathsPropertyPage";
        private final ClasspathFixProcessor.ClasspathFixProposal[] fFixProposals;
        private TableViewer fFixSelectionTable;
        private Button fNoActionRadio;
        private Button fOpenBuildPathRadio;
        private Button fPerformFix;
        private final IJavaProject fProject;
        private ClasspathFixProcessor.ClasspathFixProposal fSelectedFix;

        private static String getDialogMessage(boolean isJunit4) {
            return isJunit4 ? WizardMessages.NewTestCaseCreationWizard_fix_selection_junit4_description : WizardMessages.NewTestCaseCreationWizard_fix_selection_junit3_description;
        }

        public ClasspathFixSelectionDialog(Shell parent, boolean isJUnit4, IJavaProject project, ClasspathFixProcessor.ClasspathFixProposal[] fixProposals) {
            super(parent, WizardMessages.Wizard_title_new_testcase, null, ClasspathFixSelectionDialog.getDialogMessage(isJUnit4), 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.fProject = project;
            this.fFixProposals = fixProposals;
            this.fSelectedFix = null;
        }

        protected void buttonPressed(int buttonId) {
            this.fSelectedFix = null;
            if (buttonId == 0 && !this.fNoActionRadio.getSelection()) {
                IStructuredSelection selection;
                Object firstElement;
                if (this.fOpenBuildPathRadio.getSelection()) {
                    String id = BUILD_PATH_PAGE_ID;
                    HashMap<String, Boolean> input = new HashMap<String, Boolean>();
                    input.put(BUILD_PATH_BLOCK, Boolean.TRUE);
                    if (PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fProject, (String)id, (String[])new String[]{id}, input).open() != 0) {
                        return;
                    }
                } else if (this.fFixSelectionTable != null && (firstElement = (selection = (IStructuredSelection)this.fFixSelectionTable.getSelection()).getFirstElement()) instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    this.fSelectedFix = (ClasspathFixProcessor.ClasspathFixProposal)firstElement;
                }
            }
            super.buttonPressed(buttonId);
        }

        protected Control createCustomArea(Composite composite) {
            this.fNoActionRadio = new Button(composite, 16);
            this.fNoActionRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fNoActionRadio.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_not_now);
            this.fNoActionRadio.addSelectionListener((SelectionListener)this);
            this.fOpenBuildPathRadio = new Button(composite, 16);
            this.fOpenBuildPathRadio.setLayoutData((Object)new GridData(16384, 128, false, false));
            this.fOpenBuildPathRadio.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_open_build_path_dialog);
            this.fOpenBuildPathRadio.addSelectionListener((SelectionListener)this);
            if (this.fFixProposals.length > 0) {
                this.fPerformFix = new Button(composite, 16);
                this.fPerformFix.setLayoutData((Object)new GridData(16384, 128, false, false));
                this.fPerformFix.setText(WizardMessages.NewTestCaseCreationWizard_fix_selection_invoke_fix);
                this.fPerformFix.addSelectionListener((SelectionListener)this);
                this.fFixSelectionTable = new TableViewer(composite, 2052);
                this.fFixSelectionTable.setContentProvider((IContentProvider)new ArrayContentProvider());
                this.fFixSelectionTable.setLabelProvider((IBaseLabelProvider)new ClasspathFixLabelProvider());
                this.fFixSelectionTable.setComparator(new ViewerComparator());
                this.fFixSelectionTable.addDoubleClickListener((IDoubleClickListener)this);
                this.fFixSelectionTable.setInput((Object)this.fFixProposals);
                this.fFixSelectionTable.setSelection((ISelection)new StructuredSelection((Object)this.fFixProposals[0]));
                GridData gridData = new GridData(4, 4, true, true);
                gridData.heightHint = this.convertHeightInCharsToPixels(4);
                gridData.horizontalIndent = this.convertWidthInCharsToPixels(2);
                this.fFixSelectionTable.getControl().setLayoutData((Object)gridData);
                this.fNoActionRadio.setSelection(false);
                this.fOpenBuildPathRadio.setSelection(false);
                this.fPerformFix.setSelection(true);
            } else {
                this.fNoActionRadio.setSelection(true);
                this.fOpenBuildPathRadio.setSelection(false);
            }
            this.updateEnableStates();
            return composite;
        }

        public void doubleClick(DoubleClickEvent event) {
            this.okPressed();
        }

        public ClasspathFixProcessor.ClasspathFixProposal getSelectedClasspathFix() {
            return this.fSelectedFix;
        }

        protected boolean isResizable() {
            return true;
        }

        private void updateEnableStates() {
            if (this.fPerformFix != null) {
                this.fFixSelectionTable.getTable().setEnabled(this.fPerformFix.getSelection());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateEnableStates();
        }

        static class ClasspathFixLabelProvider
        extends LabelProvider {
            ClasspathFixLabelProvider() {
            }

            public Image getImage(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getImage();
                }
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ClasspathFixProcessor.ClasspathFixProposal) {
                    ClasspathFixProcessor.ClasspathFixProposal classpathFixProposal = (ClasspathFixProcessor.ClasspathFixProposal)element;
                    return classpathFixProposal.getDisplayString();
                }
                return null;
            }
        }
    }
}

