/*
 * Decompiled with CFR 0.152.
 */
package tern.server.nodejs;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import tern.TernException;
import tern.TernProject;
import tern.server.AbstractTernServer;
import tern.server.IInterceptor;
import tern.server.IResponseHandler;
import tern.server.ITernDef;
import tern.server.ITernPlugin;
import tern.server.ITernServer;
import tern.server.nodejs.NodejsTernHelper;
import tern.server.nodejs.process.INodejsProcessListener;
import tern.server.nodejs.process.NodejsProcess;
import tern.server.nodejs.process.NodejsProcessAdapter;
import tern.server.nodejs.process.NodejsProcessException;
import tern.server.nodejs.process.NodejsProcessManager;
import tern.server.protocol.JsonHelper;
import tern.server.protocol.TernDoc;
import tern.server.protocol.completions.ITernCompletionCollector;
import tern.server.protocol.definition.ITernDefinitionCollector;
import tern.server.protocol.lint.ITernLintCollector;
import tern.server.protocol.type.ITernTypeCollector;

public class NodejsTernServer
extends AbstractTernServer {
    private String baseURL;
    private List<IInterceptor> interceptors;
    private NodejsProcess process;
    private List<INodejsProcessListener> listeners;
    private long timeout = 200L;
    private int testNumber = 50;
    private final INodejsProcessListener listener = new NodejsProcessAdapter(){

        @Override
        public void onStart(NodejsProcess server) {
            NodejsTernServer.this.fireStartServer();
        }

        @Override
        public void onStop(NodejsProcess server) {
            NodejsTernServer.this.dispose();
        }
    };
    private boolean persistent;

    public NodejsTernServer(File projectDir, int port) {
        this(new TernProject(projectDir), port);
    }

    public NodejsTernServer(TernProject project, int port) {
        super(project);
        this.baseURL = this.computeBaseURL(port);
    }

    public NodejsTernServer(TernProject project) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir()));
    }

    public NodejsTernServer(TernProject project, File nodejsBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir));
    }

    public NodejsTernServer(TernProject project, File nodejsBaseDir, File nodejsTernBaseDir) throws TernException {
        this(project, NodejsProcessManager.getInstance().create(project.getProjectDir(), nodejsBaseDir, nodejsTernBaseDir));
    }

    public NodejsTernServer(TernProject project, NodejsProcess process) {
        super(project);
        this.process = process;
        process.setPersistent(this.persistent);
        process.addProcessListener(this.listener);
    }

    private String computeBaseURL(Integer port) {
        return "http://localhost:" + port + "/";
    }

    public void addDef(ITernDef def) throws TernException {
        TernProject project = this.getProject();
        project.addLib(def);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new TernException((Throwable)e);
        }
    }

    public void addPlugin(ITernPlugin plugin) throws TernException {
        TernProject project = this.getProject();
        project.addPlugin(plugin);
        try {
            project.save();
        }
        catch (IOException e) {
            throw new TernException((Throwable)e);
        }
    }

    public void addFile(String name, String text) {
        TernDoc t = new TernDoc();
        t.addFile(name, text, null);
        try {
            this.makeRequest(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void request(TernDoc doc, IResponseHandler handler) {
        try {
            JsonObject json = this.makeRequest(doc);
            handler.onSuccess((Object)json, handler.isDataAsJsonString() ? json.toString() : null);
        }
        catch (Exception e) {
            handler.onError(e.getMessage());
        }
    }

    private JsonObject makeRequest(TernDoc doc) throws IOException, InterruptedException, TernException {
        String baseURL = null;
        try {
            baseURL = this.getBaseURL();
        }
        catch (NodejsProcessException e) {
            this.dispose();
            throw e;
        }
        JsonObject json = NodejsTernHelper.makeRequest(baseURL, doc, false, this.interceptors, (ITernServer)this);
        return json;
    }

    public void addInterceptor(IInterceptor interceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<IInterceptor>();
        }
        this.interceptors.add(interceptor);
    }

    public void removeInterceptor(IInterceptor interceptor) {
        if (this.interceptors != null) {
            this.interceptors.remove(interceptor);
        }
    }

    public String getBaseURL() throws InterruptedException, TernException {
        if (this.baseURL == null) {
            int port = this.getProcess().start(this.timeout, this.testNumber);
            this.baseURL = this.computeBaseURL(port);
        }
        return this.baseURL;
    }

    private NodejsProcess getProcess() throws TernException {
        if (this.process != null) {
            this.process.setPersistent(this.persistent);
            return this.process;
        }
        TernProject project = super.getProject();
        this.process = NodejsProcessManager.getInstance().create(project.getProjectDir());
        this.process.setPersistent(this.persistent);
        this.process.addProcessListener(this.listener);
        return this.process;
    }

    public void addProcessListener(INodejsProcessListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<INodejsProcessListener>();
        }
        this.listeners.add(listener);
        if (this.process != null) {
            this.process.addProcessListener(listener);
        }
    }

    public void removeProcessListener(INodejsProcessListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
        if (this.process != null) {
            this.process.removeProcessListener(listener);
        }
    }

    public void request(TernDoc doc, ITernCompletionCollector collector) throws TernException {
        try {
            JsonObject jsonObject = this.makeRequest(doc);
            if (jsonObject != null) {
                JsonArray completions;
                Long startCh = this.getCh(jsonObject, "start");
                Long endCh = this.getCh(jsonObject, "end");
                int pos = 0;
                if (startCh != null && endCh != null) {
                    pos = endCh.intValue() - startCh.intValue();
                }
                if ((completions = (JsonArray)jsonObject.get("completions")) != null) {
                    for (JsonValue value : completions) {
                        if (value.isString()) {
                            collector.addProposal(value.asString(), null, null, null, pos, (Object)value, (ITernServer)this);
                            continue;
                        }
                        super.addProposal((Object)value, pos, collector);
                    }
                }
            }
        }
        catch (TernException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TernException(e);
        }
    }

    public String getText(Object value) {
        return JsonHelper.getString((JsonValue)((JsonValue)value));
    }

    public Object getValue(Object value, String name) {
        return ((JsonObject)value).get(name);
    }

    private Long getCh(JsonObject data, String name) {
        JsonValue loc = data.get(name);
        if (loc == null) {
            return null;
        }
        if (loc.isNumber()) {
            return loc.asLong();
        }
        return loc != null ? JsonHelper.getLong((JsonObject)((JsonObject)loc), (String)"ch") : null;
    }

    public void request(TernDoc doc, ITernDefinitionCollector collector) throws TernException {
        try {
            JsonObject jsonObject = this.makeRequest(doc);
            if (jsonObject != null) {
                Long startCh = this.getCh(jsonObject, "start");
                Long endCh = this.getCh(jsonObject, "end");
                String file = this.getText(jsonObject.get("file"));
                collector.setDefinition(file, startCh, endCh);
            }
        }
        catch (Throwable e) {
            throw new TernException(e);
        }
    }

    public void request(TernDoc doc, ITernTypeCollector collector) throws TernException {
        try {
            JsonObject jsonObject = this.makeRequest(doc);
            if (jsonObject != null) {
                String type = this.getText(jsonObject.get("type"));
                boolean guess = JsonHelper.getBoolean((JsonObject)jsonObject, (String)"guess", (boolean)false);
                String name = this.getText(jsonObject.get("name"));
                String exprName = this.getText(jsonObject.get("exprName"));
                String documentation = this.getText(jsonObject.get("doc"));
                String url = this.getText(jsonObject.get("url"));
                String origin = this.getText(jsonObject.get("origin"));
                collector.setType(type, guess, name, exprName, documentation, url, origin);
            }
        }
        catch (Throwable e) {
            throw new TernException(e);
        }
    }

    public void request(TernDoc doc, ITernLintCollector collector) throws TernException {
        try {
            JsonArray messages;
            JsonObject jsonObject = this.makeRequest(doc);
            if (jsonObject != null && (messages = (JsonArray)jsonObject.get("messages")) != null) {
                String message = null;
                String severity = null;
                JsonObject messageObject = null;
                for (JsonValue value : messages) {
                    messageObject = (JsonObject)value;
                    message = this.getText(messageObject.get("message"));
                    severity = this.getText(messageObject.get("severity"));
                    Long startCh = this.getCh(messageObject, "from");
                    Long endCh = this.getCh(messageObject, "to");
                    collector.addMessage(message, startCh, endCh, severity);
                }
            }
        }
        catch (Throwable e) {
            throw new TernException(e);
        }
    }

    public void doDispose() {
        if (this.process != null) {
            this.process.kill();
        }
        this.baseURL = null;
        this.process = null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTestNumber(int testNumber) {
        this.testNumber = testNumber;
    }

    public int getTestNumber() {
        return this.testNumber;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

