/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.wizards;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.WildcardType;
import org.hibernate.FetchMode;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.EntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefEntityInfo;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.RefType;
import org.hibernate.eclipse.jdt.ui.internal.jpa.common.Utils;
import org.hibernate.mapping.Array;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.PrimitiveArray;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.EnumType;
import org.hibernate.util.xpl.StringHelper;

class TypeVisitor
extends ASTVisitor {
    private String varName;
    private java.util.Map<String, RootClass> rootClasses;
    private RootClass rootClass;
    private EntityInfo entityInfo;
    private RefEntityInfo ref;
    private Property prop;

    TypeVisitor(java.util.Map<String, RootClass> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public void init(String varName, EntityInfo entityInfo) {
        this.varName = varName;
        this.entityInfo = entityInfo;
        java.util.Map<String, RefEntityInfo> refs = entityInfo.getReferences();
        this.ref = refs.get(varName);
        this.prop = null;
        this.rootClass = this.rootClasses.get(entityInfo.getFullyQualifiedName());
    }

    public boolean visit(ArrayType type) {
        PrimitiveArray array = null;
        Type componentType = type.getComponentType();
        ITypeBinding tb = componentType.resolveBinding();
        if (tb == null) {
            return false;
        }
        if (tb.isPrimitive()) {
            array = new PrimitiveArray((PersistentClass)this.rootClass);
            SimpleValue value = this.buildSimpleValue(tb.getName());
            value.setTable(this.rootClass.getTable());
            array.setElement((Value)value);
            array.setCollectionTable(this.rootClass.getTable());
        } else {
            RootClass associatedClass = this.rootClasses.get(tb.getBinaryName());
            array = new Array((PersistentClass)this.rootClass);
            array.setElementClassName(tb.getBinaryName());
            array.setCollectionTable(associatedClass.getTable());
            OneToMany oValue = new OneToMany((PersistentClass)this.rootClass);
            oValue.setAssociatedClass((PersistentClass)associatedClass);
            oValue.setReferencedEntityName(tb.getBinaryName());
            array.setElement((Value)oValue);
        }
        SimpleValue key = new SimpleValue();
        if (StringHelper.isNotEmpty((String)this.entityInfo.getPrimaryIdName())) {
            key.addColumn(new Column(this.entityInfo.getPrimaryIdName().toUpperCase()));
        }
        array.setKey((KeyValue)key);
        array.setFetchMode(FetchMode.JOIN);
        SimpleValue index = new SimpleValue();
        array.setIndex((Value)index);
        this.buildProperty((Value)array);
        this.prop.setCascade("none");
        return false;
    }

    public boolean visit(ParameterizedType type) {
        Assert.isNotNull((Object)type, (String)"Type object cannot be null");
        Assert.isNotNull((Object)this.entityInfo, (String)"EntityInfo object cannot be null");
        ITypeBinding tb = type.resolveBinding();
        if (tb == null) {
            return false;
        }
        this.rootClass = this.rootClasses.get(this.entityInfo.getFullyQualifiedName());
        Assert.isNotNull((Object)this.rootClass, (String)"RootClass not found.");
        ITypeBinding[] interfaces = Utils.getAllInterfaces(tb);
        org.hibernate.mapping.Collection value = this.buildCollectionValue(interfaces);
        if (value != null) {
            org.hibernate.mapping.Collection cValue = value;
            if (this.ref != null && this.rootClasses.get(this.ref.fullyQualifiedName) != null) {
                OneToMany oValue = new OneToMany((PersistentClass)this.rootClass);
                RootClass associatedClass = this.rootClasses.get(this.ref.fullyQualifiedName);
                oValue.setAssociatedClass((PersistentClass)associatedClass);
                oValue.setReferencedEntityName(associatedClass.getEntityName());
                cValue.setCollectionTable(associatedClass.getTable());
                cValue.setElement((Value)oValue);
            } else {
                SimpleValue elementValue = this.buildSimpleValue(tb.getTypeArguments()[0].getQualifiedName());
                elementValue.setTable(this.rootClass.getTable());
                cValue.setElement((Value)elementValue);
                cValue.setCollectionTable(this.rootClass.getTable());
            }
            if (value instanceof org.hibernate.mapping.List) {
                ((IndexedCollection)cValue).setIndex((Value)new SimpleValue());
            } else if (value instanceof Map) {
                SimpleValue map_key = new SimpleValue();
                map_key.setTypeName(tb.getTypeArguments()[0].getBinaryName());
                ((IndexedCollection)cValue).setIndex((Value)map_key);
            }
        }
        if (value == null) {
            value = this.buildSimpleValue(tb.getBinaryName());
        }
        this.buildProperty((Value)value);
        if (!(value instanceof SimpleValue)) {
            this.prop.setCascade("none");
        }
        return false;
    }

    public boolean visit(PrimitiveType type) {
        this.buildProperty((Value)this.buildSimpleValue(type.getPrimitiveTypeCode().toString()));
        return false;
    }

    public boolean visit(QualifiedType type) {
        return super.visit(type);
    }

    public boolean visit(SimpleType type) {
        ITypeBinding tb = type.resolveBinding();
        if (tb == null) {
            return false;
        }
        ITypeBinding[] interfaces = Utils.getAllInterfaces(tb);
        org.hibernate.mapping.Collection value = this.buildCollectionValue(interfaces);
        if (value != null) {
            SimpleValue element = this.buildSimpleValue("string");
            value.setElement((Value)element);
            value.setCollectionTable(this.rootClass.getTable());
            this.buildProperty((Value)value);
            if (value instanceof org.hibernate.mapping.List) {
                ((IndexedCollection)value).setIndex((Value)new SimpleValue());
            } else if (value instanceof Map) {
                SimpleValue map_key = new SimpleValue();
                map_key.setTypeName("string");
                ((IndexedCollection)value).setIndex((Value)map_key);
            }
            this.prop.setCascade("none");
        } else if (tb.isEnum()) {
            value = this.buildSimpleValue(EnumType.class.getName());
            Properties typeParameters = new Properties();
            typeParameters.put("enumClass", tb.getBinaryName());
            typeParameters.put("type", (Object)12);
            ((SimpleValue)value).setTypeParameters(typeParameters);
            this.buildProperty((Value)value);
        } else if (this.ref != null) {
            ManyToOne sValue = null;
            if (this.ref.refType == RefType.MANY2ONE) {
                sValue = new ManyToOne(this.rootClass.getTable());
            } else if (this.ref.refType == RefType.ONE2ONE) {
                sValue = new OneToOne(this.rootClass.getTable(), (PersistentClass)this.rootClass);
            } else if (this.ref.refType == RefType.UNDEF) {
                sValue = new OneToOne(this.rootClass.getTable(), (PersistentClass)this.rootClass);
            } else {
                throw new IllegalStateException(this.ref.refType.toString());
            }
            Column column = new Column(this.varName.toUpperCase());
            sValue.addColumn(column);
            sValue.setTypeName(tb.getBinaryName());
            sValue.setFetchMode(FetchMode.JOIN);
            sValue.setReferencedEntityName(this.ref.fullyQualifiedName);
            this.buildProperty((Value)sValue);
            this.prop.setCascade("none");
        } else {
            value = this.buildSimpleValue(tb.getBinaryName());
            this.buildProperty((Value)value);
        }
        return super.visit(type);
    }

    public boolean visit(WildcardType type) {
        return super.visit(type);
    }

    public Property getProperty() {
        return this.prop;
    }

    protected void buildProperty(Value value) {
        this.prop = new Property();
        this.prop.setName(this.varName);
        this.prop.setValue(value);
    }

    private SimpleValue buildSimpleValue(String typeName) {
        SimpleValue sValue = new SimpleValue();
        sValue.addColumn(new Column(this.varName.toUpperCase()));
        sValue.setTypeName(typeName);
        return sValue;
    }

    private org.hibernate.mapping.Collection buildCollectionValue(ITypeBinding[] interfaces) {
        org.hibernate.mapping.Set cValue = null;
        if (Utils.isImplementInterface(interfaces, Set.class.getName())) {
            cValue = new org.hibernate.mapping.Set((PersistentClass)this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, List.class.getName())) {
            cValue = new org.hibernate.mapping.List((PersistentClass)this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, java.util.Map.class.getName())) {
            cValue = new Map((PersistentClass)this.rootClass);
        } else if (Utils.isImplementInterface(interfaces, Collection.class.getName())) {
            cValue = new Bag((PersistentClass)this.rootClass);
        }
        if (cValue == null) {
            return null;
        }
        cValue.setCollectionTable(this.rootClass.getTable());
        SimpleValue key = new SimpleValue();
        key.setTypeName("string");
        if (StringHelper.isNotEmpty((String)this.entityInfo.getPrimaryIdName())) {
            key.addColumn(new Column(this.entityInfo.getPrimaryIdName().toUpperCase()));
        }
        cValue.setKey((KeyValue)key);
        cValue.setLazy(true);
        cValue.setRole(StringHelper.qualify((String)this.rootClass.getEntityName(), (String)this.varName));
        return cValue;
    }
}

