/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.plugin.log;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class StatusFactory {
    public static final String EMPTY_MESSAGE = "";
    private static final String NO_MESSAGE1 = ": <no message>";
    private static final String NO_MESSAGE2 = "<no message>";
    private String pluginId;

    public static IStatus getInstance(int severity, String pluginId, int code, String message, Throwable t) {
        return new Status(severity, pluginId, code, StatusFactory.checkMessage(message, t), t);
    }

    public static IStatus getInstance(int severity, String pluginId, String message, Throwable t) {
        return StatusFactory.getInstance(severity, pluginId, 0, message, t);
    }

    public static IStatus getInstance(int severity, String pluginId, String message) {
        return StatusFactory.getInstance(severity, pluginId, 0, message, null);
    }

    public static IStatus getInstance(int severity, String pluginId, Throwable t) {
        return StatusFactory.getInstance(severity, pluginId, 0, EMPTY_MESSAGE, t);
    }

    public static IStatus getInstance(int severity, String pluginId, int code, Throwable t) {
        return StatusFactory.getInstance(severity, pluginId, code, EMPTY_MESSAGE, t);
    }

    public static IStatus getInstance(int severity, String pluginId, int code, String message) {
        return StatusFactory.getInstance(severity, pluginId, code, message, null);
    }

    public static IStatus errorStatus(String pluginId, String message) {
        return StatusFactory.getInstance(4, pluginId, 0, message, null);
    }

    public static IStatus errorStatus(String pluginId, String message, Throwable throwable) {
        return StatusFactory.getInstance(4, pluginId, 0, message, throwable);
    }

    public static IStatus errorStatus(String pluginId, String message, Throwable throwable, int code) {
        return StatusFactory.getInstance(4, pluginId, code, message, throwable);
    }

    public static IStatus warningStatus(String pluginId, String message) {
        return StatusFactory.getInstance(2, pluginId, 0, message, null);
    }

    public static IStatus warningStatus(String pluginId, String message, Throwable throwable) {
        return StatusFactory.getInstance(2, pluginId, 0, message, throwable);
    }

    public static IStatus warningStatus(String pluginId, String message, Throwable throwable, int code) {
        return StatusFactory.getInstance(2, pluginId, code, message, throwable);
    }

    public static IStatus infoStatus(String pluginId, String message) {
        return StatusFactory.getInstance(1, pluginId, 0, message, null);
    }

    public static IStatus infoStatus(String pluginId, String message, Throwable throwable) {
        return StatusFactory.getInstance(1, pluginId, 0, message, throwable);
    }

    public static IStatus infoStatus(String pluginId, String message, Throwable throwable, int code) {
        return StatusFactory.getInstance(1, pluginId, code, message, throwable);
    }

    public static IStatus cancelStatus(String pluginId, String message) {
        return StatusFactory.getInstance(8, pluginId, 0, message, null);
    }

    public static IStatus cancelStatus(String pluginId, String message, Throwable throwable) {
        return StatusFactory.getInstance(8, pluginId, 0, message, throwable);
    }

    public static IStatus cancelStatus(String pluginId, String message, Throwable throwable, int code) {
        return StatusFactory.getInstance(8, pluginId, code, message, throwable);
    }

    public static IStatus throwableToStatus(String pluginId, Throwable t) {
        return StatusFactory.throwableToStatus(pluginId, t, 0);
    }

    public static IStatus throwableToStatus(String pluginId, Throwable t, int code) {
        return StatusFactory.throwableToStatus(4, pluginId, t, code);
    }

    public static IStatus throwableToStatus(int severity, String pluginId, Throwable t) {
        return StatusFactory.throwableToStatus(severity, pluginId, t, 0);
    }

    public static IStatus throwableToStatus(int severity, String pluginId, Throwable t, int code) {
        ArrayList<Status> causes = new ArrayList<Status>();
        Throwable temp = t;
        while (temp != null && temp.getCause() != temp) {
            causes.add(new Status(severity, pluginId, code, temp.getMessage() == null ? String.valueOf(temp.toString()) + NO_MESSAGE1 : temp.toString(), temp));
            temp = temp.getCause();
        }
        String msg = NO_MESSAGE2;
        if (t != null && t.getMessage() != null) {
            msg = t.toString();
        }
        if (causes.isEmpty()) {
            return new Status(severity, pluginId, code, msg, t);
        }
        return new MultiStatus(pluginId, code, causes.toArray(new IStatus[causes.size()]), msg, t);
    }

    public static IStatus getMultiStatusInstance(int severity, String pluginId, String message, Throwable t, IStatus ... status) {
        return new MultiStatus(pluginId, 0, status, message, t);
    }

    private static String checkMessage(String message, Throwable t) {
        if (message == null) {
            if (t != null && t.getMessage() != null) {
                return t.getMessage();
            }
            return NO_MESSAGE2;
        }
        return message;
    }

    public StatusFactory(String pluginId) {
        this.pluginId = pluginId;
    }

    public IStatus errorStatus(String message) {
        return StatusFactory.errorStatus(this.pluginId, StatusFactory.checkMessage(message, null));
    }

    public IStatus errorStatus(String message, Throwable t) {
        return StatusFactory.errorStatus(this.pluginId, StatusFactory.checkMessage(message, t), t);
    }

    public IStatus errorStatus(Throwable t) {
        return StatusFactory.throwableToStatus(4, this.pluginId, t);
    }

    public IStatus warningStatus(String message) {
        return StatusFactory.warningStatus(this.pluginId, StatusFactory.checkMessage(message, null));
    }

    public IStatus warningStatus(String message, Throwable t) {
        return StatusFactory.warningStatus(this.pluginId, StatusFactory.checkMessage(message, t), t);
    }

    public IStatus warningStatus(Throwable t) {
        return StatusFactory.throwableToStatus(2, this.pluginId, t);
    }

    public IStatus cancelStatus(String message) {
        return StatusFactory.cancelStatus(this.pluginId, StatusFactory.checkMessage(message, null));
    }

    public IStatus cancelStatus(String message, Throwable t) {
        return StatusFactory.cancelStatus(this.pluginId, StatusFactory.checkMessage(message, t), t);
    }

    public IStatus cancelStatus(Throwable t) {
        return StatusFactory.cancelStatus(this.pluginId, StatusFactory.checkMessage(null, t));
    }
}

