/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.core.Trace;
import org.jboss.tools.foundation.core.jobs.InterruptableJoinJob;

public class BarrierWaitJob
extends InterruptableJoinJob {
    private final Object[] barrier;
    private boolean canceled = false;

    public static void waitForSynchronous(String jobName, Object[] barrier, boolean system) throws InterruptedException {
        BarrierWaitJob wait = new BarrierWaitJob(jobName, barrier, system);
        try {
            wait.interruptableJoin(true);
        }
        catch (InterruptedException e) {
            wait.cancel();
            Trace.trace("/finer", "Canceling the barrier wait job due to interrupted flag: " + wait.getName());
            throw e;
        }
        if (wait.hasBeenCanceled()) {
            Trace.trace("/finer", "Job " + wait.getName() + " has been canceled");
            throw new InterruptedException();
        }
    }

    public BarrierWaitJob(String jobName, Object[] barrier, boolean system) {
        super(jobName);
        this.barrier = barrier;
        this.setSystem(system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IStatus run(IProgressMonitor monitor) {
        Object[] objectArray = this.barrier;
        synchronized (this.barrier) {
            while (!monitor.isCanceled()) {
                if (this.barrier[0] != null) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return Status.OK_STATUS;
                }
                try {
                    this.barrier.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return Status.OK_STATUS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void canceling() {
        Object[] objectArray = this.barrier;
        synchronized (this.barrier) {
            Trace.trace("/finer", "Job " + this.getName() + " has been canceled. Notifying the barrier");
            this.canceled = true;
            this.barrier.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenCanceled() {
        Object[] objectArray = this.barrier;
        synchronized (this.barrier) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.canceled;
        }
    }
}

