/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.ecf.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.security.ConnectContextFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemBrowserContainerAdapter;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.RemoteFileSystemException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemBrowseEvent;
import org.eclipse.ecf.filetransfer.events.IRemoteFileSystemEvent;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransferFactory;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.foundation.core.FoundationCorePlugin;
import org.jboss.tools.foundation.core.Trace;
import org.jboss.tools.foundation.core.ecf.Messages;
import org.jboss.tools.foundation.core.jobs.BarrierWaitJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class InternalURLTransport {
    private static final String BUNDLE_P2_UI_AUTHORIZATION = "org.eclipse.equinox.p2.ui.sdk";
    private static final String BUNDLE_ECF = "org.eclipse.ecf";
    private static final String BUNDLE_ECF_FILETRANSFER = "org.eclipse.ecf.provider.filetransfer";
    public static final String PROTOCOL_FILE = "file";
    public static final String PROTOCOL_PLATFORM = "platform";
    public static final String PROTOCOL_BUNDLEENTRY = "bundleentry";
    private static final int LOGIN_RETRIES = 3;
    private static final ProtocolException ERROR_401 = new ProtocolException();
    private static final String SERVER_REDIRECT = Messages.ECFExamplesTransport_Server_redirected_too_many_times;
    public static final String PREFERENCE_NODE = "org.jboss.tools.project.examples";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    private static InternalURLTransport INSTANCE;
    private ServiceTracker retrievalFactoryTracker;

    protected InternalURLTransport() {
    }

    public static synchronized InternalURLTransport getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalURLTransport();
        }
        return INSTANCE;
    }

    public long getLastModified(URL location, String user, String pass, IProgressMonitor monitor) throws CoreException {
        String[] stringArray;
        if (user == null || pass == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        }
        String[] creds = stringArray;
        return this.getLastModified(location, creds, monitor);
    }

    public long getLastModified(URL location, IProgressMonitor monitor) throws CoreException {
        return this.getLastModified(location, null, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getLastModified(URL location, String[] credentials, IProgressMonitor monitor) throws CoreException {
        Trace.trace("/finer", "Checking last-modified timestamp for " + location.toExternalForm());
        String locationString = location.toExternalForm();
        IConnectContext context = null;
        context = credentials == null ? this.getConnectionContext(locationString, false) : this.getConnectionContext(credentials[0], credentials[1]);
        try {
            int i = 0;
            while (true) {
                if (i >= 3) {
                    throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(Messages.ECFExamplesTransport_IO_error));
                }
                if (monitor.isCanceled()) {
                    return -1L;
                }
                try {
                    return this.doGetLastModified(locationString, context, monitor);
                }
                catch (ProtocolException e) {
                    if (ERROR_401 == e) {
                        context = this.getConnectionContext(locationString, true);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (UserCancelledException userCancelledException) {
            throw new OperationCanceledException();
        }
    }

    private long doGetLastModified(String location, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        IContainer container;
        try {
            container = ContainerFactory.getDefault().createContainer();
        }
        catch (ContainerCreateException containerCreateException) {
            return 0L;
        }
        IRemoteFileSystemBrowserContainerAdapter adapter = (IRemoteFileSystemBrowserContainerAdapter)container.getAdapter(IRemoteFileSystemBrowserContainerAdapter.class);
        if (adapter == null) {
            return 0L;
        }
        IRemoteFile remoteFile = this.checkFile(adapter, location, context, monitor);
        if (remoteFile == null) {
            return 0L;
        }
        return remoteFile.getInfo().getLastModified();
    }

    public IStatus download(String name, String url, OutputStream destination, int timeout, IProgressMonitor monitor) {
        return this.download(name, url, null, destination, timeout, monitor);
    }

    public IStatus download(String name, String url, String user, String pass, OutputStream destination, int timeout, IProgressMonitor monitor) {
        String[] stringArray;
        if (user == null || pass == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = user;
            stringArray = stringArray2;
            stringArray2[1] = pass;
        }
        String[] creds = stringArray;
        return this.download(name, url, creds, destination, timeout, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus download(String name, String url, String[] credentials, OutputStream destination, int timeout, IProgressMonitor monitor) {
        Trace.trace("/finer", "Downloading url " + url + " to an outputstream");
        status = null;
        context = null;
        try {
            context = credentials == null ? this.getConnectionContext(url, false) : this.getConnectionContext(credentials[0], credentials[1]);
            i = 0;
            if (true) ** GOTO lbl52
        }
        catch (UserCancelledException v0) {
            var13_16 = FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
            try {
                destination.close();
                return var13_16;
            }
            catch (IOException v1) {}
            return var13_16;
        }
        catch (CoreException e) {
            try {
                var13_17 = e.getStatus();
            }
            catch (Throwable var12_18) {
                try {
                    destination.close();
                    throw var12_18;
                }
                catch (IOException v2) {}
                throw var12_18;
                while (true) {
                    if (monitor.isCanceled()) {
                        var13_14 = FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
                        try {
                            destination.close();
                            return var13_14;
                        }
                        catch (IOException v3) {}
                        return var13_14;
                    }
                    status = this.performDownload(name, url, destination, context, timeout, credentials, monitor);
                    if (!status.isOK()) ** GOTO lbl-1000
                    var13_15 = status;
                    try {
                        destination.close();
                        return var13_15;
                    }
                    catch (IOException v4) {}
                    return var13_15;
lbl-1000:
                    // 1 sources

                    {
                        block25: {
                            try {
                                exception = status.getException();
                                if (exception instanceof IncomingFileTransferException && (code = ((IncomingFileTransferException)exception).getErrorCode()) == 401) {
                                    context = this.getConnectionContext(url, true);
                                }
                            }
                            catch (ProtocolException e) {
                                if (e != InternalURLTransport.ERROR_401) break block25;
                                context = this.getConnectionContext(url, true);
                            }
                        }
                        ++i;
lbl52:
                        // 2 sources

                        if (i < 3) continue;
                    }
                    break;
                }
            }
            try {
                destination.close();
                return var13_17;
            }
            catch (IOException v5) {}
            return var13_17;
        }
        try {
            destination.close();
        }
        catch (IOException v6) {}
        if (status == null) return FoundationCorePlugin.statusFactory().errorStatus(Messages.ECFExamplesTransport_IO_error);
        return status;
    }

    public IStatus performDownload(String name, String toDownload, OutputStream target, IConnectContext context, IProgressMonitor monitor) throws ProtocolException {
        return this.performDownload(name, toDownload, target, context, -1, monitor);
    }

    public IStatus performDownload(String name, String toDownload, OutputStream target, IConnectContext context, int timeout, IProgressMonitor monitor) throws ProtocolException {
        return this.performDownload(name, toDownload, target, context, timeout, null, monitor);
    }

    public IStatus performDownload(String name, String toDownload, OutputStream target, IConnectContext context, int timeout, String[] basicAuthCreds, IProgressMonitor monitor) throws ProtocolException {
        IRetrieveFileTransferFactory factory = (IRetrieveFileTransferFactory)this.getFileTransferServiceTracker().getService();
        if (factory == null) {
            return FoundationCorePlugin.statusFactory().errorStatus(Messages.ECFExamplesTransport_IO_error);
        }
        if (basicAuthCreds == null || basicAuthCreds.length != 2 || basicAuthCreds[0] == null || basicAuthCreds[1] == null) {
            return this.transfer(name, (IRetrieveFileTransferContainerAdapter)factory.newInstance(), toDownload, target, context, timeout, null, monitor);
        }
        return this.transfer(name, (IRetrieveFileTransferContainerAdapter)factory.newInstance(), toDownload, target, context, timeout, basicAuthCreds, monitor);
    }

    private IStatus transfer(String name, IRetrieveFileTransferContainerAdapter retrievalContainer, String toDownload, OutputStream target, IConnectContext context, int timeout, String[] basicAuthCreds, IProgressMonitor monitor) throws ProtocolException {
        Object[] result;
        block8: {
            Trace.trace("/finer", "Beginning transfer for remote file " + toDownload);
            result = new IStatus[1];
            IIncomingFileTransferReceiveStartEvent[] cancelable = new IIncomingFileTransferReceiveStartEvent[]{null};
            IFileTransferListener listener = this.getFileTransferListener((IStatus[])result, cancelable, target, toDownload, name, monitor);
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            if (timeout != -1) {
                map.put(IRetrieveFileTransferOptions.CONNECT_TIMEOUT, new Integer(timeout));
                map.put(IRetrieveFileTransferOptions.READ_TIMEOUT, new Integer(timeout));
            }
            if (basicAuthCreds != null) {
                HashMap<String, String> headers = new HashMap<String, String>();
                String userCredentials = String.valueOf(basicAuthCreds[0]) + ":" + basicAuthCreds[1];
                new Base64();
                String basicAuth = "Basic " + new String(Base64.encode((byte[])userCredentials.getBytes()));
                headers.put("Authorization", basicAuth);
                map.put(IRetrieveFileTransferOptions.REQUEST_HEADERS, headers);
            }
            try {
                retrievalContainer.setConnectContextForAuthentication(context);
                retrievalContainer.sendRetrieveRequest(FileIDFactory.getDefault().createFileID(retrievalContainer.getRetrieveNamespace(), toDownload), listener, map);
            }
            catch (IncomingFileTransferException e) {
                IStatus status = e.getStatus();
                Throwable exception = status.getException();
                if (exception instanceof IOException && exception.getMessage() != null && (exception.getMessage().indexOf("401") != -1 || exception.getMessage().indexOf(SERVER_REDIRECT) != -1)) {
                    throw ERROR_401;
                }
                return status;
            }
            catch (FileCreateException e) {
                return e.getStatus();
            }
            try {
                this.waitFor(toDownload, result);
            }
            catch (InterruptedException interruptedException) {
                if (cancelable[0] == null) break block8;
                cancelable[0].cancel();
                return FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
            }
        }
        return result[0];
    }

    private IFileTransferListener getFileTransferListener(final IStatus[] result, final IIncomingFileTransferReceiveStartEvent[] cancelable, final OutputStream target, final String toDownload, final String name, final IProgressMonitor monitor) {
        IFileTransferListener listener = new IFileTransferListener(){
            private long transferStartTime;
            protected int oldWorked;
            protected int tmpWorled;
            private long throttleMilliseconds = 250L;
            private long lastProgressUpdate = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleTransferEvent(IFileTransferEvent event) {
                IStatus[] iStatusArray;
                if (event instanceof IIncomingFileTransferReceiveStartEvent) {
                    IIncomingFileTransferReceiveStartEvent rse;
                    Trace.trace("/finer", "Transfer has begun for " + toDownload);
                    if (monitor.isCanceled()) {
                        IStatus[] iStatusArray2 = result;
                        // MONITORENTER : result
                        result[0] = FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
                        result.notify();
                        // MONITOREXIT : iStatusArray2
                    }
                    cancelable[0] = rse = (IIncomingFileTransferReceiveStartEvent)event;
                    try {
                        if (target != null) {
                            rse.receive(target);
                            this.transferStartTime = System.currentTimeMillis();
                        }
                        if (monitor != null) {
                            long fileLength = rse.getSource().getFileLength();
                            long totalWork = fileLength == -1L ? 100L : fileLength;
                            int work = totalWork > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalWork;
                            monitor.beginTask(NLS.bind((String)Messages.ECFExamplesTransport_Downloading, (Object)name), work);
                            this.lastProgressUpdate = System.currentTimeMillis();
                            this.oldWorked = 0;
                        }
                    }
                    catch (IOException e) {
                        IStatus status = InternalURLTransport.this.convertToStatus(e);
                        IStatus[] totalWork = result;
                        // MONITORENTER : result
                        result[0] = status;
                        result.notify();
                        // MONITOREXIT : totalWork
                    }
                }
                if (event instanceof IIncomingFileTransferReceiveDataEvent) {
                    IIncomingFileTransfer source = ((IIncomingFileTransferReceiveDataEvent)event).getSource();
                    if (monitor != null) {
                        if (monitor.isCanceled()) {
                            try {
                                source.cancel();
                            }
                            catch (Throwable throwable) {
                                FoundationCorePlugin.pluginLog().logWarning(Messages.ECFTransport_Operation_canceled);
                            }
                            IStatus status = FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
                            iStatusArray = result;
                            // MONITORENTER : result
                            result[0] = status;
                            result.notify();
                            // MONITOREXIT : iStatusArray
                            return;
                        }
                        long currentTime = System.currentTimeMillis();
                        if (this.lastProgressUpdate + this.throttleMilliseconds < currentTime) {
                            long fileLength = source.getFileLength();
                            long totalWork = fileLength == -1L ? 100L : fileLength;
                            double factor = totalWork > Integer.MAX_VALUE ? 2.147483647E9 / (double)totalWork : 1.0;
                            long received = source.getBytesReceived();
                            int worked = (int)Math.round(factor * (double)received);
                            double downloadRateBytesPerSecond = (double)received / ((double)(System.currentTimeMillis() + 1L - this.transferStartTime) / 1000.0);
                            String downloadRateString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)downloadRateBytesPerSecond);
                            String receivedString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)received);
                            String fileLengthString = AbstractRetrieveFileTransfer.toHumanReadableBytes((double)fileLength);
                            String str = null;
                            str = fileLength < 0L ? NLS.bind((String)Messages.ECFExamplesTransport_ReceivedSize_At_RatePerSecond, (Object[])new String[]{receivedString, downloadRateString}) : NLS.bind((String)Messages.ECFExamplesTransport_ReceivedSize_Of_FileSize_At_RatePerSecond, (Object[])new String[]{receivedString, fileLengthString, downloadRateString});
                            Trace.trace("/finest", "Transfer " + toDownload + " status: " + str);
                            monitor.subTask(str);
                            this.lastProgressUpdate = currentTime;
                            monitor.worked(worked - this.oldWorked);
                            this.oldWorked = worked;
                        }
                    }
                }
                if (!(event instanceof IIncomingFileTransferReceiveDoneEvent)) return;
                Trace.trace("/finer", "Transfer " + toDownload + " is complete");
                Exception exception = ((IIncomingFileTransferReceiveDoneEvent)event).getException();
                IStatus status = InternalURLTransport.this.convertToStatus(exception);
                iStatusArray = result;
                // MONITORENTER : result
                result[0] = status;
                result.notify();
                // MONITOREXIT : iStatusArray
                return;
            }
        };
        return listener;
    }

    private IRemoteFile checkFile(IRemoteFileSystemBrowserContainerAdapter retrievalContainer, String location, IConnectContext context, final IProgressMonitor monitor) throws ProtocolException {
        IOException ioException;
        String message;
        final Object[] result = new Object[2];
        final Object FAIL = new Object();
        IRemoteFileSystemListener listener = new IRemoteFileSystemListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public void handleRemoteFileEvent(IRemoteFileSystemEvent event) {
                Object[] objectArray;
                Exception exception = event.getException();
                if (exception != null) {
                    objectArray = result;
                    // MONITORENTER : result
                    result[0] = FAIL;
                    result[1] = exception;
                    result.notify();
                    // MONITOREXIT : objectArray
                }
                if (monitor.isCanceled()) {
                    objectArray = result;
                    // MONITORENTER : result
                    result[0] = FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
                    result.notify();
                    // MONITOREXIT : objectArray
                    return;
                }
                if (!(event instanceof IRemoteFileSystemBrowseEvent)) return;
                IRemoteFileSystemBrowseEvent fsbe = (IRemoteFileSystemBrowseEvent)event;
                IRemoteFile[] remoteFiles = fsbe.getRemoteFiles();
                if (remoteFiles != null && remoteFiles.length > 0 && remoteFiles[0] != null) {
                    Object[] objectArray2 = result;
                    // MONITORENTER : result
                    result[0] = remoteFiles[0];
                    result.notify();
                    // MONITOREXIT : objectArray2
                    return;
                }
                Object[] objectArray3 = result;
                // MONITORENTER : result
                result[0] = FAIL;
                result.notify();
                // MONITOREXIT : objectArray3
                return;
            }
        };
        try {
            retrievalContainer.setConnectContextForAuthentication(context);
            IFileID id = FileIDFactory.getDefault().createFileID(retrievalContainer.getBrowseNamespace(), location);
            retrievalContainer.sendBrowseRequest(id, listener);
        }
        catch (RemoteFileSystemException remoteFileSystemException) {
            return null;
        }
        catch (FileCreateException fileCreateException) {
            return null;
        }
        try {
            this.waitFor(location, result);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (result[0] == FAIL && result[1] instanceof IOException && (message = (ioException = (IOException)result[1]).getMessage()) != null && (message.indexOf(" 401 ") != -1 || message.indexOf(SERVER_REDIRECT) != -1)) {
            throw ERROR_401;
        }
        if (result[0] instanceof IRemoteFile) {
            return (IRemoteFile)result[0];
        }
        return null;
    }

    public IConnectContext getConnectionContext(String user, String pass) throws UserCancelledException, CoreException {
        return ConnectContextFactory.createUsernamePasswordConnectContext((String)user, (Object)pass);
    }

    public IConnectContext getConnectionContext(String xmlLocation, boolean prompt) throws UserCancelledException, CoreException {
        String nodeKey;
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        IPath hostLocation = new Path(xmlLocation).removeLastSegments(1);
        try {
            nodeKey = URLEncoder.encode(hostLocation.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            nodeKey = URLEncoder.encode(hostLocation.toString());
        }
        String nodeName = "org.jboss.tools.project.examples/" + nodeKey;
        ISecurePreferences prefNode = null;
        if (securePreferences.nodeExists(nodeName)) {
            prefNode = securePreferences.node(nodeName);
        }
        if (!prompt) {
            String password;
            String username;
            block15: {
                if (prefNode == null) {
                    return null;
                }
                try {
                    username = prefNode.get(PROP_USERNAME, null);
                    password = prefNode.get(PROP_PASSWORD, null);
                    if (username != null && password != null) break block15;
                    return null;
                }
                catch (StorageException e) {
                    String msg = Messages.ECFExamplesTransport_Internal_Error;
                    throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(msg, e));
                }
            }
            return ConnectContextFactory.createUsernamePasswordConnectContext((String)username, (Object)password);
        }
        this.forceStart(BUNDLE_P2_UI_AUTHORIZATION);
        FoundationCorePlugin.getDefault();
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)FoundationCorePlugin.getBundleContext(), (String)IProvisioningAgent.SERVICE_NAME);
        UIServices adminUIService = (UIServices)agent.getService(UIServices.SERVICE_NAME);
        UIServices.AuthenticationInfo loginDetails = null;
        if (adminUIService != null) {
            loginDetails = adminUIService.getUsernamePassword(hostLocation.toString());
        }
        if (loginDetails == null) {
            throw new UserCancelledException();
        }
        if (loginDetails.saveResult()) {
            if (prefNode == null) {
                prefNode = securePreferences.node(nodeName);
            }
            try {
                prefNode.put(PROP_USERNAME, loginDetails.getUserName(), true);
                prefNode.put(PROP_PASSWORD, loginDetails.getPassword(), true);
                prefNode.flush();
            }
            catch (StorageException e1) {
                String msg = Messages.ECFExamplesTransport_Internal_Error;
                throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(msg, e1));
            }
            catch (IOException e) {
                String msg = Messages.ECFExamplesTransport_Internal_Error;
                throw new CoreException(FoundationCorePlugin.statusFactory().errorStatus(msg, e));
            }
        }
        return ConnectContextFactory.createUsernamePasswordConnectContext((String)loginDetails.getUserName(), (Object)loginDetails.getPassword());
    }

    private IStatus convertToStatus(Exception e) {
        if (e == null) {
            return Status.OK_STATUS;
        }
        if (e instanceof UserCancelledException) {
            return FoundationCorePlugin.statusFactory().cancelStatus(e);
        }
        return FoundationCorePlugin.statusFactory().errorStatus(e);
    }

    private void waitFor(String location, Object[] barrier) throws InterruptedException {
        Trace.trace("/finer", "Waiting for remote file to download: " + location);
        BarrierWaitJob.waitForSynchronous(Messages.ECFExamplesTransport_Loading, barrier, true);
    }

    private synchronized ServiceTracker getFileTransferServiceTracker() {
        if (this.retrievalFactoryTracker == null) {
            FoundationCorePlugin.getDefault();
            this.retrievalFactoryTracker = new ServiceTracker(FoundationCorePlugin.getBundleContext(), IRetrieveFileTransferFactory.class.getName(), null);
            this.retrievalFactoryTracker.open();
            Trace.trace("/finer", "Ensuring all bundles for URLTransport are started");
            this.requestStart(BUNDLE_ECF);
            this.requestStart(BUNDLE_ECF_FILETRANSFER);
        }
        return this.retrievalFactoryTracker;
    }

    private boolean requestStart(String bundleId) {
        return this.requestStart(bundleId, null);
    }

    private boolean requestStart(String bundleId, Version version) {
        FoundationCorePlugin.getDefault();
        BundleContext bc = FoundationCorePlugin.getBundleContext();
        PackageAdmin packageAdmin = (PackageAdmin)ServiceHelper.getService((BundleContext)bc, (String)PackageAdmin.class.getName());
        if (packageAdmin == null) {
            return false;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleId, null);
        if (bundles != null && bundles.length > 0) {
            int i = 0;
            while (i < bundles.length) {
                if (version == null || bundles[i].getVersion().equals((Object)version)) {
                    try {
                        if ((bundles[i].getState() & 2) == 0) {
                            bundles[i].start(2);
                            bundles[i].start(1);
                            return true;
                        }
                    }
                    catch (BundleException bundleException) {}
                }
                ++i;
            }
        }
        return false;
    }

    private boolean forceStart(String bundleId) {
        Trace.trace("/finest", "Forcing " + bundleId + " to start");
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {}
        }
        return bundle.getState() == 32;
    }
}

