/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.foundation.core.ecf;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.tools.foundation.core.FoundationCorePlugin;
import org.jboss.tools.foundation.core.ecf.Messages;
import org.jboss.tools.foundation.core.ecf.internal.InternalURLTransport;
import org.jboss.tools.foundation.core.ecf.internal.URLTransportCache;
import org.jboss.tools.foundation.core.jobs.BarrierProgressWaitJob;

public class URLTransportUtility {
    public static final int CACHE_FOREVER = 1;
    public static final int CACHE_UNTIL_EXIT = 2;

    public File getCachedFileForURL(String url, String displayName, int lifespan, IProgressMonitor monitor) throws CoreException {
        return this.getCachedFileForURL(url, displayName, lifespan, URLTransportCache.getDefault(), monitor);
    }

    public File getCachedFileForURL(String url, String displayName, int lifespan, IPath cacheRoot, IProgressMonitor monitor) throws CoreException {
        URLTransportCache cache = URLTransportCache.getCache(cacheRoot);
        return this.getCachedFileForURL(url, displayName, lifespan, cache, monitor);
    }

    public boolean isCacheOutdated(String url, IProgressMonitor mon) throws CoreException {
        return this.isCacheOutdated(url, URLTransportCache.getDefault(), mon);
    }

    public boolean isCacheOutdated(String url, IPath cacheRoot, IProgressMonitor mon) throws CoreException {
        return this.isCacheOutdated(url, URLTransportCache.getCache(cacheRoot), mon);
    }

    public boolean isCacheOutdated(String url, URLTransportCache cache, IProgressMonitor mon) throws CoreException {
        return cache.isCacheOutdated(url, mon);
    }

    private File getCachedFileForURL(String url, String displayName, int lifespan, URLTransportCache cache, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(displayName, 200);
        SubProgressMonitor sub1 = new SubProgressMonitor(monitor, 100);
        if (cache.isCacheOutdated(url, (IProgressMonitor)sub1)) {
            sub1.done();
            SubProgressMonitor sub2 = new SubProgressMonitor(monitor, 100);
            return cache.downloadAndCache(url, displayName, lifespan, this, (IProgressMonitor)sub2);
        }
        return cache.getCachedFile(url);
    }

    public long getLastModified(URL location) throws CoreException {
        return this.getLastModified(location, (IProgressMonitor)new NullProgressMonitor());
    }

    public long getLastModified(URL location, IProgressMonitor monitor) throws CoreException {
        return this.getLastModified(location, null, null, monitor);
    }

    public long getLastModified(final URL location, final String user, final String pass, IProgressMonitor monitor) throws CoreException {
        BarrierProgressWaitJob j = new BarrierProgressWaitJob("Check Remote URL Last Modified", new BarrierProgressWaitJob.IRunnableWithProgress(){

            @Override
            public Object run(IProgressMonitor monitor) throws Exception {
                return URLTransportUtility.getTransport().getLastModified(location, user, pass, monitor);
            }
        });
        j.schedule();
        j.monitorSafeJoin(monitor);
        if (monitor.isCanceled()) {
            return -1L;
        }
        if (j.getThrowable() != null) {
            if (j.getThrowable() instanceof CoreException) {
                throw (CoreException)j.getThrowable();
            }
            throw new RuntimeException(j.getThrowable());
        }
        return (Long)j.getReturnValue();
    }

    public IStatus download(String displayName, String url, OutputStream destination, IProgressMonitor monitor) {
        return this.download(displayName, url, destination, -1, monitor);
    }

    public IStatus download(String displayName, String url, OutputStream destination, int timeout, IProgressMonitor monitor2) {
        return this.download(displayName, url, null, null, destination, timeout, monitor2);
    }

    public IStatus download(final String displayName, final String url, final String user, final String pass, final OutputStream destination, final int timeout, final IProgressMonitor monitor2) {
        BarrierProgressWaitJob j = new BarrierProgressWaitJob("Download Remote URL", new BarrierProgressWaitJob.IRunnableWithProgress(){

            @Override
            public Object run(IProgressMonitor monitor) throws Exception {
                return URLTransportUtility.getTransport().download(displayName, url, user, pass, destination, timeout, monitor2);
            }
        });
        j.schedule();
        j.monitorSafeJoin(monitor2);
        if (j.getReturnValue() != null) {
            return (IStatus)j.getReturnValue();
        }
        if (j.getThrowable() != null) {
            throw new RuntimeException(j.getThrowable());
        }
        return FoundationCorePlugin.statusFactory().cancelStatus(Messages.ECFTransport_Operation_canceled);
    }

    private static InternalURLTransport getTransport() {
        return InternalURLTransport.getInstance();
    }
}

