/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.xml.test;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.jboss.tools.common.xml.SAXValidator;
import org.xml.sax.InputSource;

public class SAXValidatorTest
extends TestCase {
    public static final String GOOD_XML = "<?xml version=\"1.0\"?><!DOCTYPE node1 [<!ELEMENT node1 (node2)><!ELEMENT node2 (#PCDATA)>]><node1><node2/></node1>";
    public static final String BAD_XML = "<?xml version=\"1.0\"?><!DOCTYPE node1 [<!ELEMENT node1 (node2)><!ELEMENT node2 (#PCDATA)>]><node1><node2/></node3></node1>";

    public void testGetXMLErrorsInputSource() {
        SAXValidator validator = new SAXValidator();
        InputSource is = new InputSource(new StringReader(GOOD_XML));
        String[] errors = validator.getXMLErrors(is);
        SAXValidatorTest.assertTrue((String)"There should be no error in simple exml parsing", (errors.length == 0 ? 1 : 0) != 0);
    }

    public void testGetXMLErrorsReader() {
        SAXValidator validator = new SAXValidator();
        String[] errors = validator.getXMLErrors((Reader)new StringReader(GOOD_XML));
        SAXValidatorTest.assertTrue((String)"There should be no error in simple exml parsing", (errors.length == 0 ? 1 : 0) != 0);
    }

    public void testGetXMLErrorsInputSourceNegative() {
        SAXValidator validator = new SAXValidator();
        InputSource is = new InputSource(new StringReader(BAD_XML));
        String[] errors = validator.getXMLErrors(is);
        SAXValidatorTest.assertTrue((String)"There should be 1 error in simple exml parsing", (errors.length == 1 ? 1 : 0) != 0);
    }

    public void testGetXMLErrorsReaderNegative() {
        SAXValidator validator = new SAXValidator();
        String[] errors = validator.getXMLErrors((Reader)new StringReader(BAD_XML));
        SAXValidatorTest.assertTrue((String)"There should be 1 error in simple exml parsing", (errors.length == 1 ? 1 : 0) != 0);
    }
}

